/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.SerialFields;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SerialScores {
    private Map<SerialFields, Integer> scores = new LinkedHashMap<SerialFields, Integer>();

    public SerialScores() {
        for (SerialFields field : SerialFields.values()) {
            if (field.equals((Object)SerialFields.ID)) continue;
            this.scores.put(field, 0);
        }
    }

    public void count(SerialFields key) {
        Utils.count(key, this.scores);
    }

    public void set(SerialFields key, int value) {
        this.scores.put(key, value);
    }

    public int get(SerialFields key) {
        return this.scores.getOrDefault((Object)key, null);
    }

    public void calculateTotal() {
        int total = 0;
        for (Map.Entry<SerialFields, Integer> entry : this.scores.entrySet()) {
            SerialFields field = entry.getKey();
            if (field.equals((Object)ThompsonTraillFields.TOTAL)) continue;
            if (field.isClassification()) {
                total += Math.min(entry.getValue(), 10);
                continue;
            }
            total += entry.getValue().intValue();
        }
        this.set(SerialFields.TOTAL, total);
    }

    public List<Integer> asList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<SerialFields, Integer> entry : this.scores.entrySet()) {
            SerialFields field = entry.getKey();
            if (field.isClassification()) {
                list.add(Math.min(entry.getValue(), 10));
                continue;
            }
            list.add(entry.getValue());
        }
        return list;
    }

    public Map<SerialFields, Integer> getScores() {
        return this.scores;
    }
}

