/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.Control008;
import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.analysis.SerialFields;
import de.gwdg.metadataqa.marc.analysis.SerialScores;
import java.util.LinkedList;
import java.util.List;

public class Serial {
    private MarcRecord record;
    private SerialScores scores;
    private Control008 control008;
    private static List<String> headers = new LinkedList<String>();

    public Serial(MarcRecord record) {
        this.record = record;
        this.scores = new SerialScores();
    }

    public static List<String> getHeader() {
        return headers;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.record.getDatafield("362") == null ? 0 : this.record.getDatafield("362").hashCode());
        result = 31 * result + (this.record.getDatafield("310") == null ? 0 : this.record.getDatafield("310").hashCode());
        result = 31 * result + (this.record.getDatafield("022") == null ? 0 : this.record.getDatafield("022").hashCode());
        result = 31 * result + (this.record.getDatafield("588") == null ? 0 : this.record.getDatafield("588").hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Serial other = (Serial)obj;
        if (this.getDatesOfPublication362() == null ? other.getDatesOfPublication362() != null : !this.getDatesOfPublication362().equals(other.getDatesOfPublication362())) {
            return false;
        }
        if (this.getFrequency310() == null ? other.getFrequency310() != null : !this.getFrequency310().equals(other.getFrequency310())) {
            return false;
        }
        if (this.getIssn022() == null ? other.getIssn022() != null : !this.getIssn022().equals(other.getIssn022())) {
            return false;
        }
        return !(this.getSourceOfDescription588() == null ? other.getSourceOfDescription588() != null : !this.getSourceOfDescription588().equals(other.getSourceOfDescription588()));
    }

    public String toString() {
        return "Serial [issn022=" + this.getIssn022() + ", frequency310=" + this.getFrequency310() + ", datesOfPublication362=" + this.getDatesOfPublication362() + ", sourceOfDescription588=" + this.getSourceOfDescription588() + "]";
    }

    private boolean empty(List<DataField> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        return list.get(0).parseSubfields().isEmpty();
    }

    private String first(List<DataField> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).toString();
    }

    public List<DataField> getIssn022() {
        return this.record.getDatafield("022");
    }

    public List<DataField> getFrequency310() {
        return this.record.getDatafield("310");
    }

    public List<DataField> getDatesOfPublication362() {
        return this.record.getDatafield("362");
    }

    public List<DataField> getSourceOfDescription588() {
        return this.record.getDatafield("588");
    }

    public String getEncodingLevel() {
        return this.record.getLeader().getEncodingLevel().getValue();
    }

    public List<Integer> determineRecordQualityScore() {
        List<DataField> notes;
        List<DataField> subjects;
        String encodingLevel;
        List<DataField> authenticationcode;
        this.control008 = this.record.getControl008();
        if (this.control008 != null && this.control008.getTag008all07() != null && this.control008.getTag008all07().getValue().equals("uuuu")) {
            this.scores.set(SerialFields.Date1Unknown, -3);
        }
        if (this.control008 != null && this.control008.getTag008all15() != null && this.control008.getTag008all15().getValue().matches("xx.+")) {
            this.scores.set(SerialFields.CountryUnknown, -1);
        }
        if (this.control008 != null && this.control008.getTag008all35() != null && this.control008.getTag008all35().getValue().matches("xxx.+")) {
            this.scores.set(SerialFields.Language, -1);
        }
        if (!this.empty(authenticationcode = this.record.getDatafield("042")) && !authenticationcode.get(0).getSubfield("a").isEmpty() && authenticationcode.get(0).getSubfield("a").get(0).getValue() != "") {
            this.scores.set(SerialFields.Auth, 7);
        }
        if ((encodingLevel = this.getEncodingLevel()).equals(" ") || encodingLevel.equals("1") || encodingLevel.equals("I")) {
            this.scores.set(SerialFields.EncodingLevelFull, 5);
        }
        if (encodingLevel.equals("M") || encodingLevel.equals("L") || encodingLevel.equals("K") || encodingLevel.equals("7")) {
            this.scores.set(SerialFields.EncodingLevelMinimal, 1);
        }
        if (this.record.getControl006() != null && this.record.getControl006().getContent() != "") {
            this.scores.set(SerialFields.Has006, 1);
        }
        if (!this.empty(this.record.getDatafield("260"))) {
            this.scores.set(SerialFields.HasPublisher260, 1);
        }
        if (!this.empty(this.record.getDatafield("264"))) {
            this.scores.set(SerialFields.HasPublisher264, 1);
        }
        if (!this.empty(this.record.getDatafield("310"))) {
            this.scores.set(SerialFields.HasPublicationFrequency310, 1);
        }
        if (!this.empty(this.record.getDatafield("336"))) {
            this.scores.set(SerialFields.HasContentType336, 1);
        }
        if (!this.empty(this.record.getDatafield("362"))) {
            this.scores.set(SerialFields.HasDatesOfPublication362, 1);
        }
        if (!this.empty(this.record.getDatafield("588"))) {
            this.scores.set(SerialFields.HasSourceOfDescription588, 1);
        }
        if ((subjects = this.record.getSubjects()).isEmpty()) {
            this.scores.set(SerialFields.HasNoSubject, -5);
        } else {
            int subjectCount = 0;
            for (DataField subject : subjects) {
                ++subjectCount;
            }
            this.scores.set(SerialFields.HasSubject, subjectCount);
        }
        if (!this.empty(this.record.getDatafield("042")) && this.record.getDatafield("042").get(0).getSubfield("a").equals("pcc")) {
            this.scores.set(SerialFields.PCC, 100);
        }
        if (this.control008 == null || this.control008.getValueByPosition(23) == null || !this.control008.getValueByPosition(23).equals("o")) {
            // empty if block
        }
        if (this.control008 == null || this.control008.getTag008all11() == null || this.control008.getTag008all11().getValue().matches("[0-8].+") || this.control008.getTag008all11().getValue().matches("u.+")) {
            // empty if block
        }
        if (this.empty(notes = this.record.getDatafield("936")) || notes.get(0).getSubfield("0").get(0).getValue().contains("DELETION")) {
            // empty if block
        }
        if (this.control008 != null && this.control008.getTag008all07() != null && this.control008.getTag008all07().getValue().matches("0.+")) {
            this.scores.set(SerialFields.Date1StartsWith0, -100);
        }
        if (encodingLevel.equals("3")) {
            this.scores.set(SerialFields.Abbreviated, -100);
        }
        this.scores.calculateTotal();
        return this.scores.asList();
    }

    public void print() {
        System.out.print(this.record.getId() + ", form of item: " + this.record.getControl008().getValueByPosition(23) + ", issn: " + this.record.getDatafield("022").get(0).getSubfield("a").get(0).getValue() + ", date1: " + this.record.getControl008().getTag008all07().getValue() + ", date2: " + this.record.getControl008().getTag008all11().getValue() + ", encodingLevel: " + this.getEncodingLevel() + ", " + this.scores.get(SerialFields.TOTAL));
    }

    public SerialScores getScores() {
        return this.scores;
    }

    static {
        for (SerialFields field : SerialFields.values()) {
            headers.add(field.getMachine());
        }
    }
}

