/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.AuthorityStatistics;
import de.gwdg.metadataqa.marc.cli.utils.Schema;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AuthorithyAnalyzer {
    private static final Logger logger = Logger.getLogger(AuthorithyAnalyzer.class.getCanonicalName());
    private static Pattern NUMERIC = Pattern.compile("^\\d");
    private MarcRecord marcRecord;
    private AuthorityStatistics authoritiesStatistics;

    public AuthorithyAnalyzer(MarcRecord marcRecord, AuthorityStatistics authoritiesStatistics) {
        this.marcRecord = marcRecord;
        this.authoritiesStatistics = authoritiesStatistics;
    }

    public int process() {
        int count = 0;
        for (DataField field : this.marcRecord.getAuthorityFields()) {
            SourceSpecificationType type = field.getDefinition().getSourceSpecificationType();
            if (type == null) continue;
            if (type.equals((Object)SourceSpecificationType.Subfield2)) {
                count += this.processFieldWithSubfield2(field);
                continue;
            }
            logger.severe("Unhandled type: " + (Object)((Object)type));
        }
        return count;
    }

    private int processFieldWithSubfield2(DataField field) {
        int count = 0;
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        Schema currentSchema = this.extractFromSubfield0(field, schemas);
        if (currentSchema == null) {
            currentSchema = this.extractSchemaFromSubfield2(field.getTag(), schemas, field);
        }
        this.updateSchemaSubfieldStatistics(field, currentSchema);
        this.addSchemasToStatistics(this.authoritiesStatistics.getInstances(), schemas);
        this.addSchemasToStatistics(this.authoritiesStatistics.getRecords(), this.deduplicateSchema(schemas));
        return ++count;
    }

    private Schema extractFromSubfield0(DataField field, List<Schema> schemas) {
        Schema currentSchema = null;
        List<MarcSubfield> subfields = field.getSubfield("0");
        if (subfields != null && !subfields.isEmpty()) {
            for (MarcSubfield subfield : subfields) {
                Map<String, String> content = subfield.parseContent();
                String organization = null;
                String organizationCode = null;
                if (content.containsKey("organization")) {
                    organization = content.get("organization");
                } else if (content.containsKey("organizationCode")) {
                    organizationCode = content.get("organizationCode");
                }
                if (organizationCode == null) continue;
                if (organization == null) {
                    organization = organizationCode;
                }
                currentSchema = new Schema(field.getTag(), "$0", organization, organizationCode);
                schemas.add(currentSchema);
            }
        }
        return currentSchema;
    }

    private Schema extractSchemaFromSubfield2(String tag, List<Schema> schemas, DataField field) {
        Schema currentSchema = null;
        List<MarcSubfield> altSchemes = field.getSubfield("2");
        if (altSchemes == null || altSchemes.isEmpty()) {
            currentSchema = new Schema(tag, "$2", "undetectable", "undetectable");
            schemas.add(currentSchema);
        } else {
            for (MarcSubfield altScheme : altSchemes) {
                currentSchema = new Schema(tag, "$2", altScheme.getValue(), altScheme.resolve());
                schemas.add(currentSchema);
            }
        }
        return currentSchema;
    }

    private void updateSchemaSubfieldStatistics(DataField field, Schema currentSchema) {
        Map<List<String>, Integer> subfieldsStatistics;
        if (currentSchema == null) {
            return;
        }
        List<String> subfields = this.orderSubfields(field.parseSubfields());
        if (!this.authoritiesStatistics.getSubfields().containsKey(currentSchema)) {
            this.authoritiesStatistics.getSubfields().put(currentSchema, new HashMap());
        }
        if (!(subfieldsStatistics = this.authoritiesStatistics.getSubfields().get(currentSchema)).containsKey(subfields)) {
            subfieldsStatistics.put(subfields, 1);
        } else {
            subfieldsStatistics.put(subfields, subfieldsStatistics.get(subfields) + 1);
        }
    }

    private void addSchemasToStatistics(Map<Schema, Integer> fieldStatistics, List<Schema> schemes) {
        if (!schemes.isEmpty()) {
            for (Schema scheme : schemes) {
                if (!fieldStatistics.containsKey(scheme)) {
                    fieldStatistics.put(scheme, 0);
                }
                fieldStatistics.put(scheme, fieldStatistics.get(scheme) + 1);
            }
        }
    }

    private List<String> orderSubfields(List<MarcSubfield> originalSubfields) {
        ArrayList<String> subfields = new ArrayList<String>();
        HashSet<String> multiFields = new HashSet<String>();
        for (MarcSubfield subfield : originalSubfields) {
            String code = subfield.getCode();
            if (!subfields.contains(code)) {
                subfields.add(code);
                continue;
            }
            multiFields.add(code);
        }
        if (!multiFields.isEmpty()) {
            for (String code : multiFields) {
                subfields.remove(code);
            }
            for (String code : multiFields) {
                subfields.add(code + "+");
            }
        }
        ArrayList<String> alphabetic = new ArrayList<String>();
        ArrayList<String> numeric = new ArrayList<String>();
        for (String subfield : subfields) {
            if (NUMERIC.matcher(subfield).matches()) {
                numeric.add(subfield);
                continue;
            }
            alphabetic.add(subfield);
        }
        if (!numeric.isEmpty()) {
            Collections.sort(alphabetic);
            Collections.sort(numeric);
            subfields = alphabetic;
            subfields.addAll(numeric);
        } else {
            Collections.sort(subfields);
        }
        return subfields;
    }

    private List<Schema> deduplicateSchema(List<Schema> schemas) {
        HashSet<Schema> set = new HashSet<Schema>(schemas);
        ArrayList<Schema> deduplicated = new ArrayList<Schema>();
        deduplicated.addAll(new HashSet<Schema>(schemas));
        return deduplicated;
    }
}

