/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private Utils() {
    }

    public static List<Code> generateCodes(String ... input) {
        if (input.length % 2 != 0) {
            throw new IllegalArgumentException("Number of input should be even");
        }
        ArrayList<Code> codes = new ArrayList<Code>();
        int len = input.length;
        for (int i = 0; i < len; i += 2) {
            codes.add(new Code(input[i], input[i + 1]));
        }
        return codes;
    }

    public static List<ControlSubfieldDefinition> generateControlSubfieldList(ControlSubfieldDefinition ... input) {
        ArrayList<ControlSubfieldDefinition> list = new ArrayList<ControlSubfieldDefinition>();
        list.addAll(Arrays.asList(input));
        return list;
    }

    public static String extractPackageName(DataField field) {
        return Utils.extractPackageName(field.getDefinition());
    }

    public static String extractPackageName(DataFieldDefinition field) {
        String packageName = field.getClass().getPackage().getName().replace("de.gwdg.metadataqa.marc.definition.tags.", "");
        return packageName;
    }

    public static List<Object> quote(List<? extends Serializable> values) {
        ArrayList<Object> quoted = new ArrayList<Object>();
        for (Serializable serializable : values) {
            quoted.add(Utils.quote(serializable));
        }
        return quoted;
    }

    public static Object quote(Object value) {
        if (value instanceof String) {
            return '\"' + ((String)value).replace("\\", "\\\\") + '\"';
        }
        return value;
    }

    public static <T> void count(T key, Map<T, Integer> counter) {
        if (!counter.containsKey(key)) {
            counter.put(key, 0);
        }
        counter.put(key, counter.get(key) + 1);
    }

    public static <T> List<String> counterToList(Map<T, Integer> counter) {
        return Utils.counterToList(':', counter);
    }

    public static <T> List<String> counterToList(char separator, Map<T, Integer> counter) {
        ArrayList<String> items = new ArrayList<String>();
        for (T entry : counter.keySet()) {
            items.add(String.format("%s%s%d", entry.toString(), Character.valueOf(separator), counter.get(entry)));
        }
        return items;
    }

    public static String solarize(String abbreviation) {
        abbreviation = StringUtils.stripAccents((String)abbreviation);
        abbreviation = abbreviation.replaceAll("\\W", "_").toLowerCase();
        return abbreviation;
    }

    public static String createRow(Object ... fields) {
        char separator = ',';
        if (fields[0].getClass() == Character.class) {
            separator = ((Character)fields[0]).charValue();
            fields = Arrays.copyOfRange(fields, 1, fields.length);
        }
        return Utils.createRowWithSep(separator, fields);
    }

    public static String createRowWithSep(char separator, Object ... fields) {
        if (fields.length == 1 && fields[0] instanceof List) {
            return StringUtils.join((Iterable)((List)fields[0]), (char)separator) + "\n";
        }
        return StringUtils.join((Object[])fields, (char)separator) + "\n";
    }
}

