/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MarcSubfield
implements Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcSubfield.class.getCanonicalName());
    private MarcRecord record;
    private DataField field;
    private SubfieldDefinition definition;
    private String code;
    private String value;
    private String codeForIndex = null;
    private List<ValidationError> validationErrors = null;
    private Linkage linkage;
    private String referencePath;

    public MarcSubfield(SubfieldDefinition definition, String code, String value) {
        this.definition = definition;
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public DataField getField() {
        return this.field;
    }

    public void setField(DataField field) {
        this.field = field;
    }

    public Linkage getLinkage() {
        return this.linkage;
    }

    public void setLinkage(Linkage linkage) {
        this.linkage = linkage;
    }

    public String getReferencePath() {
        return this.referencePath;
    }

    public void setReferencePath(String referencePath) {
        this.referencePath = referencePath;
    }

    public String getLabel() {
        String label = this.code;
        if (this.definition != null && this.definition.getLabel() != null) {
            label = this.definition.getLabel();
        }
        return label;
    }

    public String resolve() {
        if (this.definition == null) {
            return this.value;
        }
        return this.definition.resolve(this.value);
    }

    public SubfieldDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(SubfieldDefinition definition) {
        this.definition = definition;
    }

    public MarcRecord getRecord() {
        return this.record;
    }

    public void setRecord(MarcRecord record) {
        this.record = record;
    }

    public String getCodeForIndex() {
        if (this.codeForIndex == null) {
            this.codeForIndex = "_" + this.code;
            if (this.definition != null && this.definition.getCodeForIndex() != null) {
                this.codeForIndex = this.definition.getCodeForIndex();
            }
        }
        return this.codeForIndex;
    }

    public Map<String, String> parseContent() {
        if (this.definition.hasContentParser()) {
            try {
                return this.definition.getContentParser().parse(this.value);
            }
            catch (ParserException e) {
                String msg = String.format("Error in record: '%s' %s$%s: '%s'. Error message: '%s'", this.record.getId(), this.field.getTag(), this.definition.getCode(), this.value, e.getMessage());
                logger.severe(msg);
            }
        }
        return null;
    }

    public Map<String, List<String>> getKeyValuePairs(DataFieldKeyGenerator keyGenerator) {
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        String prefix = keyGenerator.forSubfield(this);
        pairs.put(prefix, Arrays.asList(this.resolve()));
        if (this.getDefinition() != null) {
            this.getKeyValuePairsForPositionalSubfields(pairs, prefix);
            this.getKeyValuePairsFromContentParser(keyGenerator, pairs);
        }
        return pairs;
    }

    private void getKeyValuePairsFromContentParser(DataFieldKeyGenerator keyGenerator, Map<String, List<String>> pairs) {
        Map<String, String> extra;
        if (this.getDefinition().hasContentParser() && (extra = this.parseContent()) != null) {
            for (String key : extra.keySet()) {
                pairs.put(keyGenerator.forSubfield(this, key), Arrays.asList(extra.get(key)));
            }
        }
    }

    private void getKeyValuePairsForPositionalSubfields(Map<String, List<String>> pairs, String prefix) {
        if (this.getDefinition().hasPositions()) {
            Map<String, String> extra = this.getDefinition().resolvePositional(this.getValue());
            for (String key : extra.keySet()) {
                pairs.put(prefix + "_" + key, Arrays.asList(extra.get(key)));
            }
        }
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList<ValidationError>();
        if (this.definition == null) {
            this.validationErrors.add(new ValidationError(this.record.getId(), this.field.getDefinition().getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, this.code, this.field.getDefinition().getDescriptionUrl()));
            isValid = false;
        } else if (this.code == null) {
            this.validationErrors.add(new ValidationError(this.record.getId(), this.field.getDefinition().getTag(), ValidationErrorType.SUBFIELD_NULL_CODE, this.code, this.field.getDefinition().getDescriptionUrl()));
            isValid = false;
        } else if (this.definition.hasValidator()) {
            if (!this.validateWithValidator()) {
                isValid = false;
            }
        } else if (this.definition.hasContentParser()) {
            if (!this.validateWithParser()) {
                isValid = false;
            }
        } else if (this.definition.getCodes() != null && this.definition.getCode(this.value) == null) {
            String message = this.value;
            if (this.referencePath != null) {
                message = message + String.format(" (the field is embedded in %s)", this.referencePath);
            }
            String path = this.referencePath == null ? this.definition.getPath() : this.referencePath + "->" + this.definition.getPath();
            this.validationErrors.add(new ValidationError(this.record.getId(), path, ValidationErrorType.SUBFIELD_INVALID_VALUE, message, this.definition.getParent().getDescriptionUrl()));
            isValid = false;
        }
        return isValid;
    }

    private boolean validateWithValidator() {
        boolean isValid = true;
        SubfieldValidator validator = this.definition.getValidator();
        ValidatorResponse response = validator.isValid(this);
        if (!response.isValid()) {
            this.validationErrors.addAll(response.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateWithParser() {
        boolean isValid = true;
        SubfieldContentParser parser = this.definition.getContentParser();
        try {
            parser.parse(this.getValue());
        }
        catch (ParserException e) {
            this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getPath(), ValidationErrorType.SUBFIELD_UNPARSABLE_CONTENT, e.getMessage(), this.definition.getParent().getDescriptionUrl()));
            isValid = false;
        }
        return isValid;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public String toString() {
        return "MarcSubfield{code='" + this.code + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

