/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.marc.Control001;
import de.gwdg.metadataqa.marc.Control003;
import de.gwdg.metadataqa.marc.Control005;
import de.gwdg.metadataqa.marc.Control006;
import de.gwdg.metadataqa.marc.Control007;
import de.gwdg.metadataqa.marc.Control008;
import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.MarcControlField;
import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.validator.ClassificationReferenceValidator;
import de.gwdg.metadataqa.marc.definition.tags.control.Control001Definition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MarcRecord
implements Extractable,
Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcRecord.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    private static final Pattern positionalPattern = Pattern.compile("^(Leader|00[678])/(.*)$");
    private static final List<String> simpleControlTags = Arrays.asList("001", "003", "005");
    private Leader leader;
    private MarcControlField control001;
    private MarcControlField control003;
    private MarcControlField control005;
    private Control006 control006;
    private Control007 control007;
    private Control008 control008;
    private List<DataField> datafields = new ArrayList<DataField>();
    private Map<String, List<DataField>> datafieldIndex = new TreeMap<String, List<DataField>>();
    private Map<String, List<MarcControlField>> controlfieldIndex = new TreeMap<String, List<MarcControlField>>();
    Map<String, List<String>> mainKeyValuePairs;
    private List<ValidationError> validationErrors = null;
    private List<String> unhandledTags = new ArrayList<String>();

    public MarcRecord() {
    }

    public MarcRecord(String id) {
        this();
        this.control001 = new MarcControlField(Control001Definition.getInstance(), id);
    }

    public void addDataField(DataField dataField) {
        dataField.setRecord(this);
        this.indexField(dataField);
        this.datafields.add(dataField);
    }

    private void indexField(DataField dataField) {
        String tag = dataField.getTag();
        if (!this.datafieldIndex.containsKey(tag)) {
            this.datafieldIndex.put(tag, new ArrayList());
        }
        this.datafieldIndex.get(tag).add(dataField);
    }

    public void addUnhandledTags(String tag) {
        this.unhandledTags.add(tag);
    }

    public void setLeader(Leader leader) {
        this.leader = leader;
        leader.setMarcRecord(this);
    }

    public void setLeader(String leader) {
        this.leader = new Leader(leader);
        this.leader.setMarcRecord(this);
    }

    public Leader getLeader() {
        return this.leader;
    }

    public Leader.Type getType() {
        return this.leader.getType();
    }

    public MarcControlField getControl001() {
        return this.control001;
    }

    public MarcRecord setControl001(MarcControlField control001) {
        this.control001 = control001;
        this.controlfieldIndex.put(control001.definition.getTag(), Arrays.asList(control001));
        return this;
    }

    public MarcControlField getControl003() {
        return this.control003;
    }

    public void setControl003(MarcControlField control003) {
        this.control003 = control003;
        this.controlfieldIndex.put(control003.definition.getTag(), Arrays.asList(control003));
    }

    public MarcControlField getControl005() {
        return this.control005;
    }

    public void setControl005(MarcControlField control005) {
        this.control005 = control005;
        this.controlfieldIndex.put(control005.definition.getTag(), Arrays.asList(control005));
    }

    public Control006 getControl006() {
        return this.control006;
    }

    public void setControl006(Control006 control006) {
        this.control006 = control006;
        control006.setMarcRecord(this);
        this.controlfieldIndex.put(control006.definition.getTag(), Arrays.asList(control006));
    }

    public Control007 getControl007() {
        return this.control007;
    }

    public void setControl007(Control007 control007) {
        this.control007 = control007;
        control007.setMarcRecord(this);
        this.controlfieldIndex.put(control007.definition.getTag(), Arrays.asList(control007));
    }

    public Control008 getControl008() {
        return this.control008;
    }

    public void setControl008(Control008 control008) {
        this.control008 = control008;
        control008.setMarcRecord(this);
        this.controlfieldIndex.put(control008.definition.getTag(), Arrays.asList(control008));
    }

    public String getId() {
        return this.control001.getContent();
    }

    public String getId(boolean trim) {
        String id = this.getId();
        if (trim) {
            id = id.trim();
        }
        return id;
    }

    public List<MarcControlField> getControlfields() {
        return Arrays.asList(this.control001, this.control003, this.control005, this.control006, this.control007, this.control008);
    }

    public List<MarcControlField> getSimpleControlfields() {
        return Arrays.asList(this.control001, this.control003, this.control005);
    }

    public List<MarcPositionalControlField> getPositionalControlfields() {
        return Arrays.asList(this.control006, this.control007, this.control008);
    }

    public boolean hasDatafield(String tag) {
        return this.datafieldIndex.containsKey(tag);
    }

    public List<DataField> getDatafield(String tag) {
        return this.datafieldIndex.getOrDefault(tag, null);
    }

    public List<DataField> getDatafields() {
        return this.datafields;
    }

    public boolean exists(String tag) {
        List<DataField> fields = this.getDatafield(tag);
        return fields != null && !fields.isEmpty();
    }

    public List<String> extract(String tag, String subfield) {
        return this.extract(tag, subfield, RESOLVE.NONE);
    }

    public List<String> extract(String tag, String subfield, RESOLVE doResolve) {
        ArrayList<String> values = new ArrayList<String>();
        List<DataField> fields = this.getDatafield(tag);
        if (fields != null && !fields.isEmpty()) {
            for (DataField field : fields) {
                if (subfield.equals("ind1") || subfield.equals("ind2")) {
                    Indicator indicator;
                    String value;
                    if (subfield.equals("ind1")) {
                        value = field.getInd1();
                        indicator = field.getDefinition().getInd1();
                    } else {
                        value = field.getInd2();
                        indicator = field.getDefinition().getInd2();
                    }
                    if (indicator.getCode(value) == null) {
                        values.add(value);
                        continue;
                    }
                    values.add(indicator.getCode(value).getLabel());
                    continue;
                }
                List<MarcSubfield> subfieldInstances = field.getSubfield(subfield);
                if (subfieldInstances == null) continue;
                for (MarcSubfield subfieldInstance : subfieldInstances) {
                    String value = null;
                    switch (doResolve) {
                        case RESOLVE: {
                            value = subfieldInstance.resolve();
                            break;
                        }
                        case NONE: {
                            value = subfieldInstance.getValue();
                            break;
                        }
                        case BOTH: {
                            value = subfieldInstance.resolve() + "##" + subfieldInstance.getValue();
                        }
                    }
                    values.add(value);
                }
            }
        }
        return values;
    }

    public List<String> getUnhandledTags() {
        return this.unhandledTags;
    }

    public String format() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.format());
        }
        return output.toString();
    }

    public String formatAsMarc() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.formatAsMarc());
        }
        return output.toString();
    }

    public String formatForIndex() {
        StringBuffer output = new StringBuffer();
        for (DataField field : this.datafields) {
            output.append(field.formatForIndex());
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        return this.getKeyValuePairs(type, false);
    }

    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type, boolean withDeduplication) {
        if (this.mainKeyValuePairs == null) {
            this.mainKeyValuePairs = new LinkedHashMap<String, List<String>>();
            this.mainKeyValuePairs.put("type", Arrays.asList(this.getType().getValue()));
            this.mainKeyValuePairs.putAll(this.leader.getKeyValuePairs(type));
            for (MarcControlField controlField : this.getControlfields()) {
                if (controlField == null) continue;
                this.mainKeyValuePairs.putAll(controlField.getKeyValuePairs(type));
            }
            for (DataField field : this.datafields) {
                Map<String, List<String>> keyValuePairs = field.getKeyValuePairs(type);
                for (Map.Entry<String, List<String>> entry : keyValuePairs.entrySet()) {
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (this.mainKeyValuePairs.containsKey(key)) {
                        this.mainKeyValuePairs.put(key, this.mergeValues(new ArrayList<String>((Collection)this.mainKeyValuePairs.get(key)), values, withDeduplication));
                        continue;
                    }
                    this.mainKeyValuePairs.put(key, values);
                }
            }
        }
        return this.mainKeyValuePairs;
    }

    @NotNull
    private List<String> mergeValues(List<String> existingValues, List<String> values, boolean withDeduplication) {
        if (withDeduplication) {
            for (String value : values) {
                if (existingValues.contains(value)) continue;
                existingValues.add(value);
            }
        } else {
            existingValues.addAll(values);
        }
        return existingValues;
    }

    public String asJson() {
        ObjectMapper mapper = new ObjectMapper();
        StringBuilder text = new StringBuilder();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("leader", this.leader.getContent());
        for (MarcControlField marcControlField : this.getControlfields()) {
            if (marcControlField == null) continue;
            map.put(marcControlField.getDefinition().getTag(), marcControlField.getContent());
        }
        for (DataField dataField : this.datafields) {
            if (dataField == null) continue;
            LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
            fieldMap.put("ind1", dataField.getInd1());
            fieldMap.put("ind2", dataField.getInd2());
            LinkedHashMap<String, String> subfields = new LinkedHashMap<String, String>();
            for (MarcSubfield subfield : dataField.parseSubfields()) {
                subfields.put(subfield.getCode(), subfield.getValue());
            }
            fieldMap.put("subfields", subfields);
            String tag = dataField.getDefinition().getTag();
            if (!map.containsKey(tag)) {
                map.put(tag, new ArrayList());
            }
            ((ArrayList)map.get(tag)).add(fieldMap);
        }
        String json = null;
        try {
            json = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonProcessingException.printStackTrace();
        }
        return json;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        return this.validate(marcVersion, false);
    }

    public boolean validate(MarcVersion marcVersion, boolean isSummary) {
        this.validationErrors = new ArrayList<ValidationError>();
        boolean isValidRecord = true;
        isValidRecord = this.validateLeader(marcVersion, isValidRecord);
        isValidRecord = this.validateUnhandledTags(isSummary, isValidRecord);
        isValidRecord = this.validateControlfields(marcVersion, isValidRecord);
        isValidRecord = this.validateDatafields(marcVersion, isValidRecord);
        return isValidRecord;
    }

    private boolean validateLeader(MarcVersion marcVersion, boolean isValidRecord) {
        boolean isValidComponent = this.leader.validate(marcVersion);
        if (!isValidComponent) {
            List<ValidationError> leaderErrors = this.leader.getValidationErrors();
            for (ValidationError leaderError : leaderErrors) {
                if (leaderError.getRecordId() != null) continue;
                leaderError.setRecordId(this.getId());
            }
            this.validationErrors.addAll(leaderErrors);
            isValidRecord = isValidComponent;
        }
        return isValidRecord;
    }

    private boolean validateUnhandledTags(boolean isSummary, boolean isValidRecord) {
        if (!this.unhandledTags.isEmpty()) {
            if (isSummary) {
                for (String tag : this.unhandledTags) {
                    this.validationErrors.add(new ValidationError(this.getId(), tag, ValidationErrorType.FIELD_UNDEFINED, tag, null));
                }
            } else {
                LinkedHashMap<String, Integer> tags = new LinkedHashMap<String, Integer>();
                for (String tag : this.unhandledTags) {
                    if (!tags.containsKey(tag)) {
                        tags.put(tag, 0);
                    }
                    tags.put(tag, (Integer)tags.get(tag) + 1);
                }
                ArrayList<String> unhandledTagsList = new ArrayList<String>();
                for (Map.Entry entry : tags.entrySet()) {
                    String tag = (String)entry.getKey();
                    if ((Integer)entry.getValue() == 1) {
                        unhandledTagsList.add(tag);
                        continue;
                    }
                    unhandledTagsList.add(String.format("%s (%d*)", tag, entry.getValue()));
                }
                for (String tag : unhandledTagsList) {
                    this.validationErrors.add(new ValidationError(this.getId(), tag, ValidationErrorType.FIELD_UNDEFINED, tag, null));
                }
            }
            isValidRecord = false;
        }
        return isValidRecord;
    }

    private boolean validateControlfields(MarcVersion marcVersion, boolean isValidRecord) {
        for (MarcControlField controlField : this.getControlfields()) {
            boolean isValidComponent;
            if (controlField == null || (isValidComponent = controlField.validate(marcVersion))) continue;
            this.validationErrors.addAll(controlField.getValidationErrors());
            isValidRecord = isValidComponent;
        }
        return isValidRecord;
    }

    private boolean validateDatafields(MarcVersion marcVersion, boolean isValidRecord) {
        HashMap repetitionCounter = new HashMap();
        for (DataField dataField : this.datafields) {
            ValidatorResponse validatorResponse;
            if (dataField.getDefinition() == null) continue;
            Utils.count(dataField.getDefinition(), repetitionCounter);
            if (!dataField.validate(marcVersion)) {
                isValidRecord = false;
                this.validationErrors.addAll(dataField.getValidationErrors());
            }
            if ((validatorResponse = ClassificationReferenceValidator.validate(dataField)).isValid()) continue;
            this.validationErrors.addAll(validatorResponse.getValidationErrors());
            isValidRecord = false;
        }
        for (Map.Entry entry : repetitionCounter.entrySet()) {
            DataFieldDefinition fieldDefinition = (DataFieldDefinition)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if (count <= 1 || !fieldDefinition.getCardinality().equals((Object)Cardinality.Nonrepeatable)) continue;
            this.validationErrors.add(new ValidationError(this.getId(), fieldDefinition.getTag(), ValidationErrorType.FIELD_NONREPEATABLE, String.format("there are %d instances", count), fieldDefinition.getDescriptionUrl()));
            isValidRecord = false;
        }
        return isValidRecord;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public List<String> search(String path, String query) {
        ArrayList<String> results = new ArrayList<String>();
        if (path.equals("001") || path.equals("003") || path.equals("005")) {
            this.searchControlField(path, query, results);
        } else if (path.startsWith("tag006")) {
            this.searchPositionalControlField(this.control006, path, query, results);
        } else if (path.startsWith("tag007")) {
            this.searchPositionalControlField(this.control007, path, query, results);
        } else if (path.startsWith("tag008")) {
            this.searchPositionalControlField(this.control008, path, query, results);
        } else {
            Matcher matcher = dataFieldPattern.matcher(path);
            if (matcher.matches()) {
                String tag = matcher.group(1);
                String subfieldCode = matcher.group(2);
                if (this.datafieldIndex.containsKey(tag)) {
                    for (DataField field : this.datafieldIndex.get(tag)) {
                        if (this.searchDatafield(query, results, subfieldCode, field)) break;
                    }
                }
            }
            if ((matcher = positionalPattern.matcher(path)).matches()) {
                this.searchByPosition(query, results, matcher);
            }
        }
        return results;
    }

    public List<String> select(MarcSpec selector) {
        ArrayList<String> results = new ArrayList<String>();
        if (this.controlfieldIndex.containsKey(selector.getFieldTag())) {
            for (MarcControlField field : this.controlfieldIndex.get(selector.getFieldTag())) {
                if (field == null) continue;
                if (!simpleControlTags.contains(field.definition.getTag())) {
                    // empty if block
                }
                results.add(field.getContent());
            }
        } else if (this.datafieldIndex.containsKey(selector.getFieldTag())) {
            for (DataField field : this.datafieldIndex.get(selector.getFieldTag())) {
                if (field == null) continue;
                for (String subfieldCode : selector.getSubfieldsAsList()) {
                    List<MarcSubfield> subfields = field.getSubfield(subfieldCode);
                    if (subfields == null) continue;
                    for (MarcSubfield subfield : subfields) {
                        results.add(subfield.getValue());
                    }
                }
            }
        } else if (selector.getFieldTag().equals("008")) {
            if (selector.getCharStart() != null) {
                ControlSubfieldDefinition definition = this.control008.getSubfieldByPosition(selector.getCharStart());
                results.add(this.control008.getMap().get(definition));
            } else {
                results.add(this.control008.getContent());
            }
        }
        return results;
    }

    private void searchByPosition(String query, List<String> results, Matcher matcher) {
        int end;
        int start;
        String tag = matcher.group(1);
        String position = matcher.group(2);
        if (position.contains("-")) {
            String[] parts = position.split("-", 2);
            start = Integer.parseInt(parts[0]);
            end = Integer.parseInt(parts[1]);
        } else {
            start = Integer.parseInt(position);
            end = start + 1;
        }
        String content = null;
        if (tag.equals("Leader")) {
            content = this.leader.getLeaderString();
        } else {
            MarcPositionalControlField controlField = null;
            switch (tag) {
                case "006": {
                    controlField = this.control006;
                    break;
                }
                case "007": {
                    controlField = this.control007;
                    break;
                }
                case "008": {
                    controlField = this.control008;
                    break;
                }
            }
            if (controlField != null) {
                content = controlField.getContent();
            }
        }
        if (content != null && content.substring(start, end).equals(query)) {
            results.add(content.substring(start, end));
        }
    }

    private boolean searchDatafield(String query, List<String> results, String subfieldCode, DataField field) {
        if (subfieldCode.equals("ind1") && field.getInd1().equals(query)) {
            results.add(field.getInd1());
            return true;
        }
        if (subfieldCode.equals("ind2") && field.getInd2().equals(query)) {
            results.add(field.getInd2());
            return true;
        }
        List<MarcSubfield> subfields = field.getSubfield(subfieldCode);
        if (subfields != null) {
            for (MarcSubfield subfield : subfields) {
                if (!subfield.getValue().equals(query)) continue;
                results.add(subfield.getValue());
                return true;
            }
        }
        return false;
    }

    private void searchControlField(String path, String query, List<String> results) {
        MarcControlField controlField = null;
        switch (path) {
            case "001": {
                controlField = this.control001;
                break;
            }
            case "003": {
                controlField = this.control003;
                break;
            }
            case "005": {
                controlField = this.control005;
                break;
            }
        }
        if (controlField != null && controlField.getContent().equals(query)) {
            results.add(controlField.getContent());
        }
    }

    private void searchPositionalControlField(MarcPositionalControlField controlField, String path, String query, List<String> results) {
        if (controlField != null) {
            Map<ControlSubfieldDefinition, String> map = controlField.getMap();
            for (ControlSubfieldDefinition subfield : controlField.getMap().keySet()) {
                if (!subfield.getId().equals(path)) continue;
                if (!map.get(subfield).equals(query)) break;
                results.add(map.get(subfield));
                break;
            }
        }
    }

    public List<DataField> getAuthorityFields() {
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        List<String> tags = Arrays.asList("100", "110", "111", "130", "700", "710", "711", "730", "720", "740", "751", "752", "753", "754", "800", "810", "811", "830");
        for (String tag : tags) {
            List<DataField> fields = this.getDatafield(tag);
            if (fields == null || fields.isEmpty()) continue;
            subjects.addAll(fields);
        }
        return subjects;
    }

    public List<DataField> getSubjects() {
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        List<String> tags = Arrays.asList("052", "055", "072", "080", "082", "083", "084", "085", "086", "600", "610", "611", "630", "647", "648", "650", "651", "653", "654", "655", "656", "657", "658", "662");
        for (String tag : tags) {
            List<DataField> fields = this.getDatafield(tag);
            if (fields == null || fields.isEmpty()) continue;
            subjects.addAll(fields);
        }
        return subjects;
    }

    public List<DataField> getSubject6xx() {
        ArrayList<DataField> subjects = new ArrayList<DataField>();
        List<String> tags = Arrays.asList("600", "610", "611", "630", "648", "650", "651");
        for (String tag : tags) {
            List<DataField> fields = this.getDatafield(tag);
            if (fields == null || fields.isEmpty()) continue;
            subjects.addAll(fields);
        }
        return subjects;
    }

    public void setField(String tag, String content) {
        this.setField(tag, content, null);
    }

    public void setField(String tag, String content, MarcVersion marcVersion) {
        if (tag.equals("001")) {
            this.setControl001(new Control001(content));
        } else if (tag.equals("003")) {
            this.setControl003(new Control003(content));
        } else if (tag.equals("005")) {
            this.setControl005(new Control005(content));
        } else if (tag.equals("006")) {
            this.setControl006(new Control006(content, this.getLeader().getType()));
        } else if (tag.equals("007")) {
            this.setControl007(new Control007(content));
        } else if (tag.equals("008")) {
            this.setControl008(new Control008(content, this.getLeader().getType()));
        } else {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(tag, marcVersion);
            if (definition == null) {
                this.addUnhandledTags(tag);
            }
            this.addDataField(new DataField(tag, content));
        }
    }

    public void setField(String tag, String ind1, String ind2, String content, MarcVersion marcVersion) {
        if (tag.equals("001")) {
            this.setControl001(new Control001(content));
        } else if (tag.equals("003")) {
            this.setControl003(new Control003(content));
        } else if (tag.equals("005")) {
            this.setControl005(new Control005(content));
        } else if (tag.equals("006")) {
            this.setControl006(new Control006(content, this.getLeader().getType()));
        } else if (tag.equals("007")) {
            this.setControl007(new Control007(content));
        } else if (tag.equals("008")) {
            this.setControl008(new Control008(content, this.getLeader().getType()));
        } else {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(tag, marcVersion);
            if (definition == null) {
                this.addUnhandledTags(tag);
            }
            this.addDataField(new DataField(tag, ind1, ind2, content));
        }
    }

    public static enum RESOLVE {
        NONE,
        RESOLVE,
        BOTH;

    }
}

