/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIfEmptyFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2For055OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DataField
implements Extractable,
Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(DataField.class.getCanonicalName());
    private DataFieldDefinition definition;
    private String tag;
    private String ind1;
    private String ind2;
    private List<MarcSubfield> subfields;
    private Map<String, List<MarcSubfield>> subfieldIndex = new LinkedHashMap<String, List<MarcSubfield>>();
    private List<ValidationError> validationErrors = null;
    private List<String> unhandledSubfields = null;
    private MarcRecord record;

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2) {
        this.definition = definition;
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, List<Map<String, String>> subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            for (Map<String, String> subfield : subfields) {
                String code = subfield.get("code");
                String value = subfield.get("content");
                SubfieldDefinition subfieldDefinition = definition.getSubfield(code);
                if (subfieldDefinition == null) {
                    if (definition.getTag().equals("886") && code.equals("k") || definition.getTag().equals("936")) continue;
                    System.err.printf("no definition for %s$%s (value: '%s') %s %s%n", definition.getTag(), code, value, definition.getTag().equals("886"), code.equals("k"));
                    continue;
                }
                MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
                marcSubfield.setField(this);
                this.subfields.add(marcSubfield);
                this.indexSubfield(code, marcSubfield);
            }
        }
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, String ... subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            this.parseSubfieldArray(subfields);
        }
    }

    public DataField(String tag, String input) {
        this.definition = TagDefinitionLoader.load(tag);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.subfields = new ArrayList<MarcSubfield>();
        this.ind1 = input.substring(0, 1);
        this.ind2 = input.substring(1, 2);
        this.parseAndAddSubfields(input.substring(2));
    }

    public DataField(String tag, String ind1, String ind2, String content) {
        this.definition = TagDefinitionLoader.load(tag);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
        this.parseAndAddSubfields(content);
    }

    private void parseAndAddSubfields(String content) {
        for (String[] sf : DataField.parseSubfields(content)) {
            this.addSubfield(sf[0], sf[1]);
        }
    }

    public static List<String[]> parseSubfields(String content) {
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        boolean codeFlag = false;
        String code = null;
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            String c = Character.toString(content.charAt(i));
            if (c.equals("$")) {
                codeFlag = true;
                if (code != null) {
                    subfields.add(new String[]{code, value.toString()});
                }
                code = null;
                value = new StringBuffer();
                continue;
            }
            if (codeFlag) {
                code = c;
                codeFlag = false;
                continue;
            }
            value.append(c);
        }
        subfields.add(new String[]{code, value.toString()});
        return subfields;
    }

    public MarcRecord getRecord() {
        return this.record;
    }

    public void setRecord(MarcRecord record) {
        this.record = record;
        for (MarcSubfield marcSubfield : this.subfields) {
            marcSubfield.setRecord(record);
        }
    }

    public void indexSubfields() {
        for (MarcSubfield marcSubfield : this.subfields) {
            this.indexSubfield(marcSubfield.getCode(), marcSubfield);
        }
    }

    private void indexSubfield(String code, MarcSubfield marcSubfield) {
        if (!this.subfieldIndex.containsKey(code)) {
            this.subfieldIndex.put(code, new LinkedList());
        }
        this.subfieldIndex.get(code).add(marcSubfield);
    }

    private void parseSubfieldArray(String[] subfields) {
        for (int i = 0; i < subfields.length; i += 2) {
            String code = subfields[i];
            String value = subfields[i + 1];
            this.addSubfield(code, value);
        }
    }

    private void addSubfield(String code, String value) {
        SubfieldDefinition subfieldDefinition = this.definition != null ? this.definition.getSubfield(code) : null;
        MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
        marcSubfield.setField(this);
        this.subfields.add(marcSubfield);
        this.indexSubfield(code, marcSubfield);
    }

    public Map<String, List<String>> getHumanReadableMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (this.definition.getInd1().exists()) {
            map.put(this.definition.getInd1().getLabel(), Arrays.asList(this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            map.put(this.definition.getInd2().getLabel(), Arrays.asList(this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            if (!map.containsKey(subfield.getLabel())) {
                map.put(subfield.getLabel(), new ArrayList());
            }
            ((List)map.get(subfield.getLabel())).add(subfield.resolve());
        }
        return map;
    }

    public String simpleFormat() {
        StringBuffer output = new StringBuffer();
        output.append(this.ind1);
        output.append(this.ind2);
        output.append(" ");
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("$%s%s", subfield.getDefinition().getCode(), subfield.getValue()));
        }
        return output.toString();
    }

    public String format() {
        StringBuffer output = new StringBuffer();
        output.append(String.format("[%s: %s]%n", this.definition.getTag(), this.definition.getLabel()));
        if (this.definition.getInd1().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd1().getLabel(), this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd2().getLabel(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s: %s%n", subfield.getLabel(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatAsMarc() {
        StringBuffer output = new StringBuffer();
        if (this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.definition.getTag(), this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.definition.getTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s_%s: %s%n", this.definition.getTag(), subfield.getCode(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatForIndex() {
        StringBuffer output = new StringBuffer();
        if (this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.definition.getIndexTag(), this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.definition.getIndexTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            Map<String, String> extra;
            String code = subfield.getCodeForIndex();
            output.append(String.format("%s%s: %s%n", this.definition.getIndexTag(), code, subfield.resolve()));
            if (subfield.getDefinition() == null || !subfield.getDefinition().hasContentParser() || (extra = subfield.parseContent()) == null) continue;
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                output.append(String.format("%s%s_%s: %s%n", this.definition.getIndexTag(), code, entry.getKey(), entry.getValue()));
            }
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        DataFieldKeyGenerator keyGenerator = new DataFieldKeyGenerator(this.definition, type, this.getTag());
        if (this.definition != null && this.definition.getInd1().exists()) {
            pairs.put(keyGenerator.forInd1(), Arrays.asList(this.resolveInd1()));
        } else if (this.getInd1() != null) {
            pairs.put(keyGenerator.forInd1(), Arrays.asList(this.getInd1()));
        }
        if (this.definition != null && this.definition.getInd2().exists()) {
            pairs.put(keyGenerator.forInd2(), Arrays.asList(this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            pairs.putAll(subfield.getKeyValuePairs(keyGenerator));
        }
        if (this.getFieldIndexer() != null) {
            try {
                Map<String, List<String>> extra = this.getFieldIndexer().index(this, keyGenerator);
                pairs.putAll(extra);
            }
            catch (IllegalArgumentException e) {
                logger.severe(String.format("%s  in record %s %s", e.getLocalizedMessage(), this.record.getId(), this.toString()));
            }
        }
        return pairs;
    }

    public FieldIndexer getFieldIndexer() {
        FieldIndexer fieldIndexer = null;
        if (this.definition != null && this.definition.getFieldIndexer() != null) {
            fieldIndexer = this.definition.getFieldIndexer();
        } else if (this.definition != null && this.definition.getSourceSpecificationType() != null) {
            SourceSpecificationType specificationType = this.definition.getSourceSpecificationType();
            switch (specificationType) {
                case Indicator1Is7AndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Indicator1IsSpaceAndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIfEmptyFromSubfield2.getInstance();
                    break;
                }
                case Indicator2AndSubfield2: {
                    fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
                    break;
                }
                case Indicator2For055AndSubfield2: {
                    fieldIndexer = SchemaFromInd2For055OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Subfield2: {
                    fieldIndexer = SchemaFromSubfield2.getInstance();
                }
            }
        }
        return fieldIndexer;
    }

    public String resolveInd1() {
        return this.resolveIndicator(this.definition.getInd1(), this.ind1);
    }

    public String resolveInd2() {
        return this.resolveIndicator(this.definition.getInd2(), this.ind2);
    }

    public String resolveIndicator(Indicator indicatorDefinition, String indicator) {
        if (indicatorDefinition.getLabel().equals("")) {
            return "";
        }
        if (!indicatorDefinition.hasCode(indicator)) {
            return indicator;
        }
        Code indCode = indicatorDefinition.getCode(indicator);
        assert (indCode != null);
        if (indCode.isRange()) {
            return indCode.getLabel() + ": " + indicator;
        }
        return indCode.getLabel();
    }

    public String getTag() {
        return this.definition != null ? this.definition.getTag() : this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public List<MarcSubfield> getSubfield(String code) {
        return this.subfieldIndex.getOrDefault(code, null);
    }

    public List<MarcSubfield> parseSubfields() {
        return this.subfields;
    }

    public DataFieldDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList<ValidationError>();
        DataFieldDefinition referencerDefinition = null;
        List<MarcSubfield> _subfields = null;
        boolean ambiguousLinkage = false;
        if (this.getTag().equals("880")) {
            List<MarcSubfield> subfield6s = this.getSubfield("6");
            if (subfield6s == null) {
                this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag(), ValidationErrorType.FIELD_MISSING_REFERENCE_SUBFIELD, "$6", this.definition.getDescriptionUrl()));
                isValid = false;
            } else if (!subfield6s.isEmpty()) {
                if (subfield6s.size() != 1) {
                    this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag() + "$6", ValidationErrorType.RECORD_AMBIGUOUS_LINKAGE, "There are multiple $6", this.definition.getDescriptionUrl()));
                    isValid = false;
                    ambiguousLinkage = true;
                } else {
                    MarcSubfield subfield6 = subfield6s.get(0);
                    Object var8_8 = null;
                    try {
                        Linkage linkage = LinkageParser.getInstance().create(subfield6.getValue());
                        if (linkage == null || linkage.getLinkingTag() == null) {
                            this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, String.format("Unparseable reference: '%s'", subfield6.getValue()), this.definition.getDescriptionUrl()));
                        } else {
                            referencerDefinition = this.definition;
                            this.definition = TagDefinitionLoader.load(linkage.getLinkingTag());
                            if (this.definition == null) {
                                this.definition = referencerDefinition;
                                this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, String.format("refers to field %s, which is not defined", linkage.getLinkingTag()), this.definition.getDescriptionUrl()));
                                isValid = false;
                            } else {
                                _subfields = this.subfields;
                                ArrayList<MarcSubfield> _subfieldsNew = new ArrayList<MarcSubfield>();
                                for (MarcSubfield subfield : this.subfields) {
                                    MarcSubfield alternativeSubfield = new MarcSubfield(this.definition.getSubfield(subfield.getCode()), subfield.getCode(), subfield.getValue());
                                    alternativeSubfield.setField(this);
                                    alternativeSubfield.setRecord(this.record);
                                    alternativeSubfield.setLinkage(linkage);
                                    alternativeSubfield.setReferencePath(referencerDefinition.getTag());
                                    _subfieldsNew.add(alternativeSubfield);
                                }
                                this.subfields = _subfieldsNew;
                            }
                        }
                    }
                    catch (ParserException e) {
                        this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, e.getMessage(), this.definition.getDescriptionUrl()));
                    }
                }
            }
        }
        if (this.unhandledSubfields != null) {
            this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, StringUtils.join(this.unhandledSubfields, (String)", "), this.definition.getDescriptionUrl()));
            isValid = false;
        }
        if (this.ind1 != null && !this.validateIndicator("ind1", this.definition.getInd1(), this.ind1, marcVersion, referencerDefinition)) {
            isValid = false;
        }
        if (this.ind2 != null && !this.validateIndicator("ind2", this.definition.getInd2(), this.ind2, marcVersion, referencerDefinition)) {
            isValid = false;
        }
        if (!ambiguousLinkage) {
            HashMap<SubfieldDefinition, Integer> counter = new HashMap<SubfieldDefinition, Integer>();
            for (MarcSubfield marcSubfield : this.subfields) {
                if (marcSubfield.getDefinition() == null) {
                    if (this.definition.isVersionSpecificSubfields(marcVersion, marcSubfield.getCode())) {
                        marcSubfield.setDefinition(this.definition.getVersionSpecificSubfield(marcVersion, marcSubfield.getCode()));
                    } else {
                        this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, marcSubfield.getCode(), this.definition.getDescriptionUrl()));
                        isValid = false;
                        continue;
                    }
                }
                if (!counter.containsKey(marcSubfield.getDefinition())) {
                    counter.put(marcSubfield.getDefinition(), 0);
                }
                counter.put(marcSubfield.getDefinition(), (Integer)counter.get(marcSubfield.getDefinition()) + 1);
                if (marcSubfield.validate(marcVersion)) continue;
                this.validationErrors.addAll(marcSubfield.getValidationErrors());
                isValid = false;
            }
            for (Map.Entry entry : counter.entrySet()) {
                SubfieldDefinition subfieldDefinition = (SubfieldDefinition)entry.getKey();
                Integer count = (Integer)entry.getValue();
                if (count <= 1 || !subfieldDefinition.getCardinality().equals((Object)Cardinality.Nonrepeatable)) continue;
                this.validationErrors.add(new ValidationError(this.record.getId(), subfieldDefinition.getPath(), ValidationErrorType.SUBFIELD_NONREPEATABLE, String.format("there are %d instances", count), this.definition.getDescriptionUrl()));
                isValid = false;
            }
        }
        if (referencerDefinition != null) {
            this.definition = referencerDefinition;
        }
        if (_subfields != null) {
            this.subfields = _subfields;
        }
        return isValid;
    }

    private boolean validateIndicator(String prefix, Indicator indicatorDefinition, String value, MarcVersion marcVersion, DataFieldDefinition referencerDefinition) {
        boolean isValid = true;
        String path = indicatorDefinition.getPath();
        if (referencerDefinition != null) {
            path = String.format("%s->%s", referencerDefinition.getTag(), path);
        }
        if (indicatorDefinition.exists()) {
            if (!indicatorDefinition.hasCode(value) && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
                isValid = false;
                if (indicatorDefinition.isHistoricalCode(value)) {
                    this.validationErrors.add(new ValidationError(this.record.getId(), path, ValidationErrorType.INDICATOR_OBSOLETE, value, this.definition.getDescriptionUrl()));
                } else {
                    this.validationErrors.add(new ValidationError(this.record.getId(), path, ValidationErrorType.INDICATOR_INVALID_VALUE, value, this.definition.getDescriptionUrl()));
                }
            }
        } else if (!value.equals(" ") && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
            this.validationErrors.add(new ValidationError(this.record.getId(), path, ValidationErrorType.INDICATOR_NON_EMPTY, value, this.definition.getDescriptionUrl()));
            isValid = false;
        }
        return isValid;
    }

    public DataFieldKeyGenerator getKeyGenerator(SolrFieldType type) {
        return new DataFieldKeyGenerator(this.getDefinition(), type);
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void addUnhandledSubfields(String code) {
        if (this.unhandledSubfields == null) {
            this.unhandledSubfields = new ArrayList<String>();
        }
        this.unhandledSubfields.add(code);
    }

    public String toString() {
        return "DataField{" + this.definition.getTag() + ", ind1='" + this.ind1 + '\'' + ", ind2='" + this.ind2 + '\'' + ", subfields=" + this.subfields + '}';
    }
}

