/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.controlsubfields.Control006Subfields;
import de.gwdg.metadataqa.marc.definition.controltype.Control008Type;
import de.gwdg.metadataqa.marc.definition.tags.control.Control006Definition;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Control006
extends MarcPositionalControlField
implements Serializable {
    private static final Logger logger = Logger.getLogger(Control006.class.getCanonicalName());
    private ControlValue tag006all00;
    private ControlValue tag006book01;
    private ControlValue tag006book05;
    private ControlValue tag006book06;
    private ControlValue tag006book07;
    private ControlValue tag006book11;
    private ControlValue tag006book12;
    private ControlValue tag006book13;
    private ControlValue tag006book14;
    private ControlValue tag006book16;
    private ControlValue tag006book17;
    private ControlValue tag006computer05;
    private ControlValue tag006computer06;
    private ControlValue tag006computer09;
    private ControlValue tag006computer11;
    private ControlValue tag006map01;
    private ControlValue tag006map05;
    private ControlValue tag006map08;
    private ControlValue tag006map11;
    private ControlValue tag006map12;
    private ControlValue tag006map14;
    private ControlValue tag006map16;
    private ControlValue tag006music01;
    private ControlValue tag006music03;
    private ControlValue tag006music04;
    private ControlValue tag006music05;
    private ControlValue tag006music06;
    private ControlValue tag006music07;
    private ControlValue tag006music13;
    private ControlValue tag006music16;
    private ControlValue tag006continuing01;
    private ControlValue tag006continuing02;
    private ControlValue tag006continuing04;
    private ControlValue tag006continuing05;
    private ControlValue tag006continuing06;
    private ControlValue tag006continuing07;
    private ControlValue tag006continuing08;
    private ControlValue tag006continuing11;
    private ControlValue tag006continuing12;
    private ControlValue tag006continuing16;
    private ControlValue tag006continuing17;
    private ControlValue tag006visual01;
    private ControlValue tag006visual05;
    private ControlValue tag006visual11;
    private ControlValue tag006visual12;
    private ControlValue tag006visual16;
    private ControlValue tag006visual17;
    private ControlValue tag006mixed06;
    private Map<Integer, ControlSubfieldDefinition> byPosition = new LinkedHashMap<Integer, ControlSubfieldDefinition>();

    public Control006(String content, Leader.Type recordType) {
        super(Control006Definition.getInstance(), content, recordType);
        if (content != null) {
            this.process();
        }
    }

    private void process() {
        for (ControlSubfieldDefinition subfield : Control006Subfields.getInstance().get(Control008Type.ALL_MATERIALS)) {
            int end = Math.min(this.content.length(), subfield.getPositionEnd());
            if (end < 0) {
                logger.severe(this.content.length() + " " + subfield.getPositionEnd());
            }
            try {
                String value = this.content.substring(subfield.getPositionStart(), end);
                ControlValue controlValue = new ControlValue(subfield, value);
                this.valuesList.add(controlValue);
                switch (subfield.getId()) {
                    case "tag006all00": {
                        this.tag006all00 = controlValue;
                        break;
                    }
                    default: {
                        logger.severe(String.format("Unhandled 006 subfield: %s", subfield.getId()));
                    }
                }
                this.valuesMap.put(subfield, value);
                this.byPosition.put(subfield.getPositionStart(), subfield);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.severe(this.content.length() + " " + subfield.getPositionStart() + "-" + subfield.getPositionEnd());
            }
        }
        Control008Type actual = Control008Type.byCode(this.recordType.getValue().toString());
        for (ControlSubfieldDefinition subfield : Control006Subfields.getInstance().get(actual)) {
            int end = Math.min(this.content.length(), subfield.getPositionEnd());
            String value = null;
            if (subfield.getPositionStart() > this.content.length() || subfield.getPositionStart() >= end) break;
            try {
                value = this.content.substring(subfield.getPositionStart(), end);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.severe(String.format("Problem with processing 006 ('%s'). The content length is only %d while reading position @%d-%d (for %s '%s')", this.content, this.content.length(), subfield.getPositionStart(), subfield.getPositionEnd(), subfield.getId(), subfield.getLabel()));
            }
            ControlValue controlValue = new ControlValue(subfield, value);
            this.valuesList.add(controlValue);
            block8 : switch (actual) {
                case BOOKS: {
                    switch (subfield.getId()) {
                        case "tag006book01": {
                            this.tag006book01 = controlValue;
                            break block8;
                        }
                        case "tag006book05": {
                            this.tag006book05 = controlValue;
                            break block8;
                        }
                        case "tag006book06": {
                            this.tag006book06 = controlValue;
                            break block8;
                        }
                        case "tag006book07": {
                            this.tag006book07 = controlValue;
                            break block8;
                        }
                        case "tag006book11": {
                            this.tag006book11 = controlValue;
                            break block8;
                        }
                        case "tag006book12": {
                            this.tag006book12 = controlValue;
                            break block8;
                        }
                        case "tag006book13": {
                            this.tag006book13 = controlValue;
                            break block8;
                        }
                        case "tag006book14": {
                            this.tag006book14 = controlValue;
                            break block8;
                        }
                        case "tag006book16": {
                            this.tag006book16 = controlValue;
                            break block8;
                        }
                        case "tag006book17": {
                            this.tag006book17 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case COMPUTER_FILES: {
                    switch (subfield.getId()) {
                        case "tag006computer05": {
                            this.tag006computer05 = controlValue;
                            break block8;
                        }
                        case "tag006computer06": {
                            this.tag006computer06 = controlValue;
                            break block8;
                        }
                        case "tag006computer09": {
                            this.tag006computer09 = controlValue;
                            break block8;
                        }
                        case "tag006computer11": {
                            this.tag006computer11 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case MAPS: {
                    switch (subfield.getId()) {
                        case "tag006map01": {
                            this.tag006map01 = controlValue;
                            break block8;
                        }
                        case "tag006map05": {
                            this.tag006map05 = controlValue;
                            break block8;
                        }
                        case "tag006map08": {
                            this.tag006map08 = controlValue;
                            break block8;
                        }
                        case "tag006map11": {
                            this.tag006map11 = controlValue;
                            break block8;
                        }
                        case "tag006map12": {
                            this.tag006map12 = controlValue;
                            break block8;
                        }
                        case "tag006map14": {
                            this.tag006map14 = controlValue;
                            break block8;
                        }
                        case "tag006map16": {
                            this.tag006map16 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case MUSIC: {
                    switch (subfield.getId()) {
                        case "tag006music01": {
                            this.tag006music01 = controlValue;
                            break block8;
                        }
                        case "tag006music03": {
                            this.tag006music03 = controlValue;
                            break block8;
                        }
                        case "tag006music04": {
                            this.tag006music04 = controlValue;
                            break block8;
                        }
                        case "tag006music05": {
                            this.tag006music05 = controlValue;
                            break block8;
                        }
                        case "tag006music06": {
                            this.tag006music06 = controlValue;
                            break block8;
                        }
                        case "tag006music07": {
                            this.tag006music07 = controlValue;
                            break block8;
                        }
                        case "tag006music13": {
                            this.tag006music13 = controlValue;
                            break block8;
                        }
                        case "tag006music16": {
                            this.tag006music16 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case CONTINUING_RESOURCES: {
                    switch (subfield.getId()) {
                        case "tag006continuing01": {
                            this.tag006continuing01 = controlValue;
                            break block8;
                        }
                        case "tag006continuing02": {
                            this.tag006continuing02 = controlValue;
                            break block8;
                        }
                        case "tag006continuing04": {
                            this.tag006continuing04 = controlValue;
                            break block8;
                        }
                        case "tag006continuing05": {
                            this.tag006continuing05 = controlValue;
                            break block8;
                        }
                        case "tag006continuing06": {
                            this.tag006continuing06 = controlValue;
                            break block8;
                        }
                        case "tag006continuing07": {
                            this.tag006continuing07 = controlValue;
                            break block8;
                        }
                        case "tag006continuing08": {
                            this.tag006continuing08 = controlValue;
                            break block8;
                        }
                        case "tag006continuing11": {
                            this.tag006continuing11 = controlValue;
                            break block8;
                        }
                        case "tag006continuing12": {
                            this.tag006continuing12 = controlValue;
                            break block8;
                        }
                        case "tag006continuing16": {
                            this.tag006continuing16 = controlValue;
                            break block8;
                        }
                        case "tag006continuing17": {
                            this.tag006continuing17 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case VISUAL_MATERIALS: {
                    switch (subfield.getId()) {
                        case "tag006visual01": {
                            this.tag006visual01 = controlValue;
                            break block8;
                        }
                        case "tag006visual05": {
                            this.tag006visual05 = controlValue;
                            break block8;
                        }
                        case "tag006visual11": {
                            this.tag006visual11 = controlValue;
                            break block8;
                        }
                        case "tag006visual12": {
                            this.tag006visual12 = controlValue;
                            break block8;
                        }
                        case "tag006visual16": {
                            this.tag006visual16 = controlValue;
                            break block8;
                        }
                        case "tag006visual17": {
                            this.tag006visual17 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                case MIXED_MATERIALS: {
                    switch (subfield.getId()) {
                        case "tag006mixed06": {
                            this.tag006mixed06 = controlValue;
                            break block8;
                        }
                    }
                    logger.severe(String.format("Unhandled 006 subfield (for %s): %s", actual.getValue(), subfield.getId()));
                    break;
                }
                default: {
                    logger.severe(String.format("Unhandled 006 type: %s", actual.getValue()));
                }
            }
            this.valuesMap.put(subfield, value);
            this.byPosition.put(subfield.getPositionStart(), subfield);
        }
    }

    public String resolve(ControlSubfieldDefinition key) {
        String value = (String)this.valuesMap.get(key);
        String text = key.resolve(value);
        return text;
    }

    @Override
    public Map<ControlSubfieldDefinition, String> getMap() {
        return this.valuesMap;
    }

    public Map<ControlSubfieldDefinition, String> getValueMap() {
        return this.valuesMap;
    }

    public String getValueByPosition(int position) {
        return (String)this.valuesMap.get(this.getSubfieldByPosition(position));
    }

    public ControlSubfieldDefinition getSubfieldByPosition(int position) {
        return this.byPosition.get(position);
    }

    public Set<Integer> getSubfieldPositions() {
        return this.byPosition.keySet();
    }

    public Leader.Type getRecordType() {
        return this.recordType;
    }

    public ControlValue getTag006all00() {
        return this.tag006all00;
    }

    public ControlValue getTag006book01() {
        return this.tag006book01;
    }

    public ControlValue getTag006book05() {
        return this.tag006book05;
    }

    public ControlValue getTag006book06() {
        return this.tag006book06;
    }

    public ControlValue getTag006book07() {
        return this.tag006book07;
    }

    public ControlValue getTag006book11() {
        return this.tag006book11;
    }

    public ControlValue getTag006book12() {
        return this.tag006book12;
    }

    public ControlValue getTag006book13() {
        return this.tag006book13;
    }

    public ControlValue getTag006book14() {
        return this.tag006book14;
    }

    public ControlValue getTag006book16() {
        return this.tag006book16;
    }

    public ControlValue getTag006book17() {
        return this.tag006book17;
    }

    public ControlValue getTag006computer05() {
        return this.tag006computer05;
    }

    public ControlValue getTag006computer06() {
        return this.tag006computer06;
    }

    public ControlValue getTag006computer09() {
        return this.tag006computer09;
    }

    public ControlValue getTag006computer11() {
        return this.tag006computer11;
    }

    public ControlValue getTag006map01() {
        return this.tag006map01;
    }

    public ControlValue getTag006map05() {
        return this.tag006map05;
    }

    public ControlValue getTag006map08() {
        return this.tag006map08;
    }

    public ControlValue getTag006map11() {
        return this.tag006map11;
    }

    public ControlValue getTag006map12() {
        return this.tag006map12;
    }

    public ControlValue getTag006map14() {
        return this.tag006map14;
    }

    public ControlValue getTag006map16() {
        return this.tag006map16;
    }

    public ControlValue getTag006music01() {
        return this.tag006music01;
    }

    public ControlValue getTag006music03() {
        return this.tag006music03;
    }

    public ControlValue getTag006music04() {
        return this.tag006music04;
    }

    public ControlValue getTag006music05() {
        return this.tag006music05;
    }

    public ControlValue getTag006music06() {
        return this.tag006music06;
    }

    public ControlValue getTag006music07() {
        return this.tag006music07;
    }

    public ControlValue getTag006music13() {
        return this.tag006music13;
    }

    public ControlValue getTag006music16() {
        return this.tag006music16;
    }

    public ControlValue getTag006continuing01() {
        return this.tag006continuing01;
    }

    public ControlValue getTag006continuing02() {
        return this.tag006continuing02;
    }

    public ControlValue getTag006continuing04() {
        return this.tag006continuing04;
    }

    public ControlValue getTag006continuing05() {
        return this.tag006continuing05;
    }

    public ControlValue getTag006continuing06() {
        return this.tag006continuing06;
    }

    public ControlValue getTag006continuing07() {
        return this.tag006continuing07;
    }

    public ControlValue getTag006continuing08() {
        return this.tag006continuing08;
    }

    public ControlValue getTag006continuing11() {
        return this.tag006continuing11;
    }

    public ControlValue getTag006continuing12() {
        return this.tag006continuing12;
    }

    public ControlValue getTag006continuing16() {
        return this.tag006continuing16;
    }

    public ControlValue getTag006continuing17() {
        return this.tag006continuing17;
    }

    public ControlValue getTag006visual01() {
        return this.tag006visual01;
    }

    public ControlValue getTag006visual05() {
        return this.tag006visual05;
    }

    public ControlValue getTag006visual11() {
        return this.tag006visual11;
    }

    public ControlValue getTag006visual12() {
        return this.tag006visual12;
    }

    public ControlValue getTag006visual16() {
        return this.tag006visual16;
    }

    public ControlValue getTag006visual17() {
        return this.tag006visual17;
    }

    public ControlValue getTag006mixed06() {
        return this.tag006mixed06;
    }
}

