package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.ThematicIndexCodeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

/**
 * Numeric Designation of Musical Work
 * http://www.loc.gov/marc/bibliographic/bd383.html
 */
public class Tag383 extends DataFieldDefinition {
  private static Tag383 uniqueInstance;

  private Tag383() {
    initialize();
    postCreation();
  }

  public static Tag383 getInstance() {
    if (uniqueInstance == null)
      uniqueInstance = new Tag383();
    return uniqueInstance;
  }

  private void initialize() {
    tag = "383";
    label = "Numeric Designation of Musical Work";
    cardinality = Cardinality.Repeatable;
    descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd383.html";
    setCompilanceLevels("O");

    ind1 = new Indicator();
    ind2 = new Indicator();

    setSubfieldsWithCardinality(
      "a", "Serial number", "R",
      "b", "Opus number", "R",
      "c", "Thematic index number", "R",
      "d", "Thematic index code", "NR",
      "e", "Publisher associated with opus number", "NR",
      "2", "Source", "NR",
      "6", "Linkage", "NR",
      "8", "Field link and sequence number", "R"
    );

    getSubfield("2").setCodeList(ThematicIndexCodeSourceCodes.getInstance());

    getSubfield("6").setContentParser(LinkageParser.getInstance());

    // TODO: set Bibframe tag

    getSubfield("a")
      .setMqTag("serialNumber")
      .setCompilanceLevels("A");

    getSubfield("b")
      .setMqTag("opusNumber")
      .setCompilanceLevels("M");

    getSubfield("c")
      .setMqTag("thematicIndexNumber")
      .setCompilanceLevels("A");

    getSubfield("d")
      .setMqTag("thematicIndexCode");

    getSubfield("e")
      .setMqTag("publisher");

    getSubfield("2")
      .setMqTag("source");

    getSubfield("6")
      .setBibframeTag("linkage")
      .setCompilanceLevels("A");

    getSubfield("8")
      .setMqTag("fieldLink")
      .setCompilanceLevels("O");

  }
}
