/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import java.util.List;

public class InstanceCounter {
    boolean isNA = true;
    boolean ignoreNA = false;
    int count = 0;
    private final Selector cache;
    private final DataElement field;
    private boolean allowEmptyInstances = true;

    public InstanceCounter(Selector cache, DataElement field) {
        this.cache = cache;
        this.field = field;
        this.count();
    }

    public InstanceCounter(Selector cache, DataElement field, boolean allowEmptyInstances) {
        this.cache = cache;
        this.field = field;
        this.allowEmptyInstances = allowEmptyInstances;
        this.count();
    }

    private void count() {
        List instances = this.cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!this.allowEmptyInstances && !instance.hasValue()) continue;
                ++this.count;
                this.isNA = false;
            }
        }
    }

    public boolean isNA() {
        if (this.ignoreNA) {
            return false;
        }
        return this.isNA;
    }

    public int getCount() {
        return this.count;
    }

    public void ignoreNA() {
        this.ignoreNA = true;
    }

    public String toString() {
        return "InstanceCounter{isNA=" + this.isNA + ", count=" + this.count + "}";
    }
}

