/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class ContentTypeExtractor {
    private static final Logger LOGGER = Logger.getLogger(ContentTypeExtractor.class.getCanonicalName());
    private static int timeout = 1000;

    public static String getContentType(String url) throws IOException {
        String contentType = null;
        URL urlObj = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)urlObj.openConnection();
        int timeout = 1000;
        urlConnection.setConnectTimeout(timeout);
        urlConnection.setReadTimeout(timeout);
        urlConnection.connect();
        int responseCode = urlConnection.getResponseCode();
        if (responseCode == 200) {
            String rawContentType = urlConnection.getHeaderField("Content-Type");
            if (rawContentType != null && StringUtils.isNotBlank((CharSequence)rawContentType)) {
                contentType = rawContentType.replaceAll("; ?charset.*$", "");
            }
        } else {
            if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                String location = urlConnection.getHeaderField("Location");
                return ContentTypeExtractor.getContentType(location);
            }
            LOGGER.warning(String.format("URL %s returns unhandled status code: %d.\n", url, responseCode));
        }
        return contentType;
    }
}

