/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.uniqueness;

import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.UniquenessExtractor;
import de.gwdg.metadataqa.api.uniqueness.UniquenessField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class UniquenessFieldCalculator {
    private static final Logger LOGGER = Logger.getLogger(UniquenessFieldCalculator.class.getCanonicalName());
    private Selector cache;
    private String recordId;
    private UniquenessField uniquenessField;
    private SolrClient solrClient;
    List<Double> counts = new ArrayList<Double>();
    List<Double> scores = new ArrayList<Double>();
    UniquenessExtractor extractor;
    double averageCount;
    double averageScore;

    public UniquenessFieldCalculator(Selector cache, String recordId, SolrClient solrClient, UniquenessField solrField) {
        this.cache = cache;
        this.recordId = recordId;
        this.solrClient = solrClient;
        this.uniquenessField = solrField;
        this.extractor = new UniquenessExtractor();
    }

    public void calculate() {
        List values = this.cache.get(this.uniquenessField.getPath());
        if (values != null) {
            for (XmlFieldInstance fieldInstance : values) {
                String value = fieldInstance.getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                String solrResponse = this.solrClient.getSolrSearchResponse(this.uniquenessField.getSolrField(), value);
                Integer count = UniquenessExtractor.extractNumFound(solrResponse);
                if (count == 0) {
                    count = 1;
                }
                double score = Math.pow(UniquenessFieldCalculator.calculateScore(this.uniquenessField.getTotal(), count.intValue()) / this.uniquenessField.getScoreForUniqueValue(), 3.0);
                this.counts.add((double)count);
                this.scores.add(score);
            }
        }
        this.averageCount = this.getAverage(this.counts, this.recordId, "count");
        this.averageScore = this.getAverage(this.scores, this.recordId, "score");
    }

    public static double calculateScore(double total, double actual) {
        return Math.log(1.0 + (total - actual + 0.5) / (actual + 0.5));
    }

    private Double getAverage(List<Double> numbers, String recordId, String type) {
        double result = 0.0;
        if (!numbers.isEmpty()) {
            if (numbers.size() == 1) {
                result = numbers.get(0);
            } else {
                double total = 0.0;
                for (double number : numbers) {
                    total += number;
                }
                result = total / (double)numbers.size();
            }
            if (type.equals("score") && (result < 0.0 || result > 1.0)) {
                ArrayList<String> pairs = new ArrayList<String>();
                for (int i = 0; i < numbers.size(); ++i) {
                    pairs.add(String.format("%f -> %f", this.counts.get(i), numbers.get(i)));
                }
                LOGGER.severe(String.format("EXTREME AVERAGE at %s: %f <- average of %s", recordId, result, StringUtils.join(pairs, (String)", ")));
            }
        }
        return result;
    }

    public double getAverageCount() {
        return this.averageCount;
    }

    public double getAverageScore() {
        return this.averageScore;
    }
}

