/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.uniqueness;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.TfIdf;
import de.gwdg.metadataqa.api.util.Converter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TfIdfExtractor {
    private static final JsonProvider JSON_PROVIDER = Configuration.defaultConfiguration().jsonProvider();
    private final Schema schema;
    private Map<String, List<TfIdf>> termsCollection;

    public TfIdfExtractor(Schema schema) {
        this.schema = schema;
    }

    public FieldCounter<Double> extract(String jsonString, String recordId) {
        return this.extract(jsonString, recordId, false);
    }

    public FieldCounter<Double> extract(String jsonString, String recordId, boolean doCollectTerms) {
        FieldCounter<Double> results = new FieldCounter<Double>();
        this.termsCollection = new LinkedHashMap<String, List<TfIdf>>();
        Object document = JSON_PROVIDER.parse(jsonString);
        String path = String.format("$.termVectors.['%s']", recordId);
        LinkedHashMap value = (LinkedHashMap)JsonPath.read((Object)document, (String)path, (Predicate[])new Predicate[0]);
        for (DataElement dataElement : this.schema.getIndexFields()) {
            if (doCollectTerms) {
                this.termsCollection.put(dataElement.getPath(), new ArrayList());
            }
            String solrField = dataElement.getIndexField();
            double sum = 0.0;
            double count = 0.0;
            if (value.containsKey(solrField)) {
                LinkedHashMap terms = (LinkedHashMap)value.get(solrField);
                for (Map.Entry entry : terms.entrySet()) {
                    String term = (String)entry.getKey();
                    Map termInfo = (Map)entry.getValue();
                    double tfIdf = Converter.asDouble(termInfo.get("tf-idf"));
                    if (doCollectTerms) {
                        int tf = Converter.asInteger(termInfo.get("tf"));
                        int df = Converter.asInteger(termInfo.get("df"));
                        this.termsCollection.get(dataElement.getLabel()).add(new TfIdf(term, tf, df, tfIdf));
                    }
                    sum += tfIdf;
                    count += 1.0;
                }
            }
            double avg = count > 0.0 ? sum / count : 0.0;
            results.put(dataElement.getLabel() + ":sum", sum);
            results.put(dataElement.getLabel() + ":avg", avg);
        }
        return results;
    }

    public Map<String, List<TfIdf>> getTermsCollection() {
        return this.termsCollection;
    }
}

