/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.similarity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Term {
    String value;
    Map<String, Double> distances = new HashMap<String, Double>();

    public Term(String value) {
        this.value = value;
    }

    public void setDistance(Term other, double distance) {
        this.distances.put(other.value, distance);
    }

    public String getValue() {
        return this.value;
    }

    public double getDistance(Term other) {
        return this.distances.get(other.value);
    }

    public boolean hasDistance(Term other) {
        return this.distances.containsKey(other.value);
    }

    public String formatDistances() {
        ArrayList<String> formattedDistances = new ArrayList<String>();
        for (Map.Entry<String, Double> distance : this.distances.entrySet()) {
            formattedDistances.add(String.format("%s=%f", distance.getKey(), distance.getValue()));
        }
        return "{" + StringUtils.join(formattedDistances, (String)", ") + "}";
    }

    public String toString() {
        return "Term{term='" + this.value + "', distances=" + this.formatDistances() + "}";
    }
}

