/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.similarity;

import de.gwdg.metadataqa.api.similarity.BinaryMaker;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RecordPattern {
    private List<String> record;
    private String fields;
    private List<String> fieldList;
    private String binary;
    private String id;
    private Integer length;
    private Integer count;
    private Integer numberOfFields;
    private Integer total;
    private Double percent;

    public RecordPattern(BinaryMaker binaryMaker, List<String> rec) {
        this.record = rec;
        this.id = rec.get(0);
        this.fields = rec.get(1);
        this.numberOfFields = Integer.parseInt(rec.get(2));
        this.count = Integer.parseInt(rec.get(3));
        this.percent = Double.parseDouble(rec.get(4));
        this.fieldList = Arrays.asList(this.fields.split(";"));
        this.binary = binaryMaker.fieldListToBinary(this.fieldList);
    }

    public String asCsv() {
        return StringUtils.join(this.record, (String)",");
    }

    public String getFields() {
        return this.fields;
    }

    public String getBinary() {
        return this.binary;
    }

    public List<String> getFieldList() {
        return this.fieldList;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getCount() {
        return this.count;
    }

    public Double getPercent() {
        return this.percent;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Integer getNumberOfFields() {
        return this.numberOfFields;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "RecordPattern{record=" + this.record + ", fields='" + this.fields + "', fieldList=" + this.fieldList + ", binary='" + this.binary + "', id='" + this.id + "', length=" + this.length + ", count=" + this.count + ", numberOfFields=" + this.numberOfFields + ", total=" + this.total + ", percent=" + this.percent + "}";
    }
}

