/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema.edm;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.schema.ProblemCatalogSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.schema.SchemaUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class EdmSchema
implements Schema,
ProblemCatalogSchema {
    protected final Map<String, DataElement> paths = new LinkedHashMap<String, DataElement>();
    protected final Map<String, DataElement> collectionPaths = new LinkedHashMap<String, DataElement>();
    protected final List<FieldGroup> fieldGroups = new ArrayList<FieldGroup>();
    protected final List<String> noLanguageFields = new ArrayList<String>();
    protected List<DataElement> indexFields;
    protected final List<String> emptyStrings = new ArrayList<String>();
    protected String longSubjectPath;
    protected String titlePath;
    protected String descriptionPath;
    protected List<String> categories = null;
    protected List<RuleChecker> ruleCheckers;
    protected Map<String, String> extractableFields = new LinkedHashMap<String, String>();

    protected void addPath(DataElement dataElement) {
        this.paths.put(dataElement.getLabel(), dataElement);
        if (dataElement.isCollection()) {
            this.collectionPaths.put(dataElement.getLabel(), dataElement);
        }
    }

    @Override
    public List<DataElement> getPaths() {
        return new ArrayList<DataElement>(this.paths.values());
    }

    @Override
    public List<DataElement> getRootChildrenPaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DataElement getPathByLabel(String label) {
        return this.paths.get(label);
    }

    @Override
    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = Category.extractCategories(this.paths.values(), true);
        }
        return this.categories;
    }

    @Override
    public List<RuleChecker> getRuleCheckers() {
        if (this.ruleCheckers == null) {
            this.ruleCheckers = SchemaUtils.getRuleCheckers(this);
        }
        return this.ruleCheckers;
    }

    @Override
    public List<FieldGroup> getFieldGroups() {
        return this.fieldGroups;
    }

    @Override
    public List<String> getNoLanguageFields() {
        return this.noLanguageFields;
    }

    @Override
    public List<DataElement> getIndexFields() {
        if (this.indexFields == null) {
            this.indexFields = new ArrayList<DataElement>();
            for (DataElement dataElement : this.getPaths()) {
                if (!StringUtils.isNotBlank((CharSequence)dataElement.getIndexField())) continue;
                this.indexFields.add(dataElement);
            }
        }
        return this.indexFields;
    }

    @Override
    public List<String> getEmptyStringPaths() {
        return this.emptyStrings;
    }

    @Override
    public String getSubjectPath() {
        return this.longSubjectPath;
    }

    @Override
    public String getTitlePath() {
        return this.titlePath;
    }

    @Override
    public String getDescriptionPath() {
        return this.descriptionPath;
    }

    @Override
    public Map<String, String> getExtractableFields() {
        return this.extractableFields;
    }

    @Override
    public void setExtractableFields(Map<String, String> extractableFields) {
        this.extractableFields = extractableFields;
    }

    @Override
    public void addExtractableField(String label, String path) {
        this.extractableFields.put(label, path);
    }

    @Override
    public DataElement getRecordId() {
        return null;
    }

    @Override
    public void merge(Schema other, boolean allowOverwrite) {
        throw new UnsupportedOperationException("The method in ot available in this class.");
    }
}

