/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema.edm;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.edm.EdmSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EdmOaiPmhJsonSchema
extends EdmSchema
implements Serializable {
    private static final long serialVersionUID = 5281918481768643599L;

    public EdmOaiPmhJsonSchema() {
        this.initialize();
    }

    private void initialize() {
        this.longSubjectPath = "$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:subject']";
        this.titlePath = "$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:title']";
        this.descriptionPath = "$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:description']";
        DataElement providedCHO = new DataElement("ProvidedCHO", "$.['edm:ProvidedCHO'][0]");
        providedCHO.setCollection(true);
        this.addPath(providedCHO);
        DataElement providedCHOIdentifier = new DataElement("ProvidedCHO/rdf:about", providedCHO, "$.['@about']").setCategories(Category.MANDATORY).setExtractable();
        providedCHO.setIdentifier(providedCHOIdentifier);
        this.addPath(providedCHOIdentifier);
        DataElement proxy = new DataElement("Proxy", "$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]");
        proxy.setCollection(true);
        this.addPath(proxy);
        DataElement proxyIdentifier = new DataElement("Proxy/rdf:about", proxy, "$.['@about']");
        proxy.setIdentifier(proxyIdentifier);
        this.addPath(proxyIdentifier);
        this.addPath(new DataElement("Proxy/dc:title", proxy, "$.['dc:title']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_title_txt"));
        this.addPath(new DataElement("Proxy/dcterms:alternative", proxy, "$.['dcterms:alternative']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dcterms_alternative_txt"));
        this.addPath(new DataElement("Proxy/dc:description", proxy, "$.['dc:description']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_description_txt"));
        this.addPath(new DataElement("Proxy/dc:creator", proxy, "$.['dc:creator']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:publisher", proxy, "$.['dc:publisher']").setCategories(Category.SEARCHABILITY, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:contributor", proxy, "$.['dc:contributor']").setCategories(Category.SEARCHABILITY));
        this.addPath(new DataElement("Proxy/dc:type", proxy, "$.['dc:type']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:identifier", proxy, "$.['dc:identifier']").setCategories(Category.IDENTIFICATION));
        this.addPath(new DataElement("Proxy/dc:language", proxy, "$.['dc:language']").setCategories(Category.DESCRIPTIVENESS, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:coverage", proxy, "$.['dc:coverage']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:temporal", proxy, "$.['dcterms:temporal']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:spatial", proxy, "$.['dcterms:spatial']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:subject", proxy, "$.['dc:subject']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:date", proxy, "$.['dc:date']").setCategories(Category.IDENTIFICATION, Category.BROWSING, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:created", proxy, "$.['dcterms:created']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:issued", proxy, "$.['dcterms:issued']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:extent", proxy, "$.['dcterms:extent']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:medium", proxy, "$.['dcterms:medium']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:provenance", proxy, "$.['dcterms:provenance']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dcterms:hasPart", proxy, "$.['dcterms:hasPart']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:isPartOf", proxy, "$.['dcterms:isPartOf']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:format", proxy, "$.['dc:format']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:source", proxy, "$.['dc:source']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dc:rights", proxy, "$.['dc:rights']").setCategories(Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:relation", proxy, "$.['dc:relation']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:isNextInSequence", proxy, "$.['edm:isNextInSequence']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:type", proxy, "$.['edm:type']").setCategories(Category.SEARCHABILITY, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:europeanaProxy", proxy, "$.['edm:europeanaProxy']"));
        this.addPath(new DataElement("Proxy/edm:year", proxy, "$.['edm:year']"));
        this.addPath(new DataElement("Proxy/edm:userTag", proxy, "$.['edm:userTag']"));
        this.addPath(new DataElement("Proxy/ore:proxyIn", proxy, "$.['ore:proxyIn']"));
        this.addPath(new DataElement("Proxy/ore:proxyFor", proxy, "$.['ore:proxyFor']"));
        this.addPath(new DataElement("Proxy/dcterms:conformsTo", proxy, "$.['dcterms:conformsTo']"));
        this.addPath(new DataElement("Proxy/dcterms:hasFormat", proxy, "$.['dcterms:hasFormat']"));
        this.addPath(new DataElement("Proxy/dcterms:hasVersion", proxy, "$.['dcterms:hasVersion']"));
        this.addPath(new DataElement("Proxy/dcterms:isFormatOf", proxy, "$.['dcterms:isFormatOf']"));
        this.addPath(new DataElement("Proxy/dcterms:isReferencedBy", proxy, "$.['dcterms:isReferencedBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isReplacedBy", proxy, "$.['dcterms:isReplacedBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isRequiredBy", proxy, "$.['dcterms:isRequiredBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isVersionOf", proxy, "$.['dcterms:isVersionOf']"));
        this.addPath(new DataElement("Proxy/dcterms:references", proxy, "$.['dcterms:references']"));
        this.addPath(new DataElement("Proxy/dcterms:replaces", proxy, "$.['dcterms:replaces']"));
        this.addPath(new DataElement("Proxy/dcterms:requires", proxy, "$.['dcterms:requires']"));
        this.addPath(new DataElement("Proxy/dcterms:tableOfContents", proxy, "$.['dcterms:tableOfContents']"));
        this.addPath(new DataElement("Proxy/edm:currentLocation", proxy, "$.['edm:currentLocation']"));
        this.addPath(new DataElement("Proxy/edm:hasMet", proxy, "$.['edm:hasMet']"));
        this.addPath(new DataElement("Proxy/edm:hasType", proxy, "$.['edm:hasType']"));
        this.addPath(new DataElement("Proxy/edm:incorporates", proxy, "$.['edm:incorporates']"));
        this.addPath(new DataElement("Proxy/edm:isDerivativeOf", proxy, "$.['edm:isDerivativeOf']"));
        this.addPath(new DataElement("Proxy/edm:isRelatedTo", proxy, "$.['edm:isRelatedTo']"));
        this.addPath(new DataElement("Proxy/edm:isRepresentationOf", proxy, "$.['edm:isRepresentationOf']"));
        this.addPath(new DataElement("Proxy/edm:isSimilarTo", proxy, "$.['edm:isSimilarTo']"));
        this.addPath(new DataElement("Proxy/edm:isSuccessorOf", proxy, "$.['edm:isSuccessorOf']"));
        this.addPath(new DataElement("Proxy/edm:realizes", proxy, "$.['edm:realizes']"));
        this.addPath(new DataElement("Proxy/edm:wasPresentAt", proxy, "$.['edm:wasPresentAt']"));
        DataElement aggregation = new DataElement("Aggregation", "$.['ore:Aggregation']");
        aggregation.setCollection(true);
        this.addPath(aggregation);
        DataElement aggregationIdentifier = new DataElement("Aggregation/rdf:about", aggregation, "$.['@about']");
        this.addPath(aggregationIdentifier);
        aggregation.setIdentifier(aggregationIdentifier);
        this.addPath(new DataElement("Aggregation/edm:rights", aggregation, "$.['edm:rights']").setCategories(Category.MANDATORY, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:provider", aggregation, "$.['edm:provider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION));
        this.addPath(new DataElement("Aggregation/edm:dataProvider", aggregation, "$.['edm:dataProvider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION));
        this.addPath(new DataElement("Aggregation/edm:isShownAt", aggregation, "$.['edm:isShownAt']").setCategories(Category.BROWSING, Category.VIEWING));
        this.addPath(new DataElement("Aggregation/edm:isShownBy", aggregation, "$.['edm:isShownBy']").setCategories(Category.BROWSING, Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:object", aggregation, "$.['edm:object']").setCategories(Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:hasView", aggregation, "$.['edm:hasView']").setCategories(Category.BROWSING, Category.VIEWING));
        this.addPath(new DataElement("Aggregation/dc:rights", aggregation, "$.['dc:rights']"));
        this.addPath(new DataElement("Aggregation/edm:ugc", aggregation, "$.['edm:ugc']"));
        this.addPath(new DataElement("Aggregation/edm:aggregatedCHO", aggregation, "$.['edm:aggregatedCHO']"));
        this.addPath(new DataElement("Aggregation/edm:intermediateProvider", aggregation, "$.['edm:intermediateProvider']"));
        DataElement place = new DataElement("Place", "$.['edm:Place']");
        place.setCollection(true);
        this.addPath(place);
        DataElement placeIdentifier = new DataElement("Place/rdf:about", place, "$.['@about']");
        this.addPath(placeIdentifier);
        place.setIdentifier(placeIdentifier);
        this.addPath(new DataElement("Place/wgs84:lat", place, "$.['wgs84:lat']"));
        this.addPath(new DataElement("Place/wgs84:long", place, "$.['wgs84:long']"));
        this.addPath(new DataElement("Place/wgs84:alt", place, "$.['wgs84:alt']"));
        this.addPath(new DataElement("Place/dcterms:isPartOf", place, "$.['dcterms:isPartOf']"));
        this.addPath(new DataElement("Place/wgs84_pos:lat_long", place, "$.['wgs84_pos:lat_long']"));
        this.addPath(new DataElement("Place/dcterms:hasPart", place, "$.['dcterms:hasPart']"));
        this.addPath(new DataElement("Place/owl:sameAs", place, "$.['owl:sameAs']"));
        this.addPath(new DataElement("Place/skos:prefLabel", place, "$.['skos:prefLabel']"));
        this.addPath(new DataElement("Place/skos:altLabel", place, "$.['skos:altLabel']"));
        this.addPath(new DataElement("Place/skos:note", place, "$.['skos:note']"));
        DataElement agent = new DataElement("Agent", "$.['edm:Agent']");
        agent.setCollection(true);
        this.addPath(agent);
        DataElement agentIdentifier = new DataElement("Agent/rdf:about", agent, "$.['@about']");
        this.addPath(agentIdentifier);
        agent.setIdentifier(agentIdentifier);
        this.addPath(new DataElement("Agent/edm:begin", agent, "$.['edm:begin']"));
        this.addPath(new DataElement("Agent/edm:end", agent, "$.['edm:end']"));
        this.addPath(new DataElement("Agent/edm:hasMet", agent, "$.['edm:hasMet']"));
        this.addPath(new DataElement("Agent/edm:isRelatedTo", agent, "$.['edm:isRelatedTo']"));
        this.addPath(new DataElement("Agent/owl:sameAs", agent, "$.['owl:sameAs']"));
        this.addPath(new DataElement("Agent/foaf:name", agent, "$.['foaf:name']"));
        this.addPath(new DataElement("Agent/dc:date", agent, "$.['dc:date']"));
        this.addPath(new DataElement("Agent/dc:identifier", agent, "$.['dc:identifier']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfBirth", agent, "$.['rdaGr2:dateOfBirth']"));
        this.addPath(new DataElement("Agent/rdaGr2:placeOfBirth", agent, "$.['rdaGr2:placeOfBirth']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfDeath", agent, "$.['rdaGr2:dateOfDeath']"));
        this.addPath(new DataElement("Agent/rdaGr2:placeOfDeath", agent, "$.['rdaGr2:placeOfDeath']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfEstablishment", agent, "$.['rdaGr2:dateOfEstablishment']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfTermination", agent, "$.['rdaGr2:dateOfTermination']"));
        this.addPath(new DataElement("Agent/rdaGr2:gender", agent, "$.['rdaGr2:gender']"));
        this.addPath(new DataElement("Agent/rdaGr2:professionOrOccupation", agent, "$.['rdaGr2:professionOrOccupation']"));
        this.addPath(new DataElement("Agent/rdaGr2:biographicalInformation", agent, "$.['rdaGr2:biographicalInformation']"));
        this.addPath(new DataElement("Agent/skos:prefLabel", agent, "$.['skos:prefLabel']"));
        this.addPath(new DataElement("Agent/skos:altLabel", agent, "$.['skos:altLabel']"));
        this.addPath(new DataElement("Agent/skos:note", agent, "$.['skos:note']"));
        DataElement timespan = new DataElement("Timespan", "$.['edm:TimeSpan']");
        timespan.setCollection(true);
        this.addPath(timespan);
        DataElement timespanIdentifier = new DataElement("Timespan/rdf:about", timespan, "$.['@about']");
        this.addPath(timespanIdentifier);
        timespan.setIdentifier(timespanIdentifier);
        this.addPath(new DataElement("Timespan/edm:begin", timespan, "$.['edm:begin']"));
        this.addPath(new DataElement("Timespan/edm:end", timespan, "$.['edm:end']"));
        this.addPath(new DataElement("Timespan/dcterms:isPartOf", timespan, "$.['dcterms:isPartOf']"));
        this.addPath(new DataElement("Timespan/dcterms:hasPart", timespan, "$.['dcterms:hasPart']"));
        this.addPath(new DataElement("Timespan/edm:isNextInSequence", timespan, "$.['edm:isNextInSequence']"));
        this.addPath(new DataElement("Timespan/owl:sameAs", timespan, "$.['owl:sameAs']"));
        this.addPath(new DataElement("Timespan/skos:prefLabel", timespan, "$.['skos:prefLabel']"));
        this.addPath(new DataElement("Timespan/skos:altLabel", timespan, "$.['skos:altLabel']"));
        this.addPath(new DataElement("Timespan/skos:note", timespan, "$.['skos:note']"));
        DataElement concept = new DataElement("Concept", "$.['skos:Concept']");
        concept.setCollection(true);
        this.addPath(concept);
        DataElement conceptIdentifier = new DataElement("Concept/rdf:about", concept, "$.['@about']");
        this.addPath(conceptIdentifier);
        concept.setIdentifier(conceptIdentifier);
        this.addPath(new DataElement("Concept/skos:broader", concept, "$.['skos:broader']"));
        this.addPath(new DataElement("Concept/skos:narrower", concept, "$.['skos:narrower']"));
        this.addPath(new DataElement("Concept/skos:related", concept, "$.['skos:related']"));
        this.addPath(new DataElement("Concept/skos:broadMatch", concept, "$.['skos:broadMatch']"));
        this.addPath(new DataElement("Concept/skos:narrowMatch", concept, "$.['skos:narrowMatch']"));
        this.addPath(new DataElement("Concept/skos:relatedMatch", concept, "$.['skos:relatedMatch']"));
        this.addPath(new DataElement("Concept/skos:exactMatch", concept, "$.['skos:exactMatch']"));
        this.addPath(new DataElement("Concept/skos:closeMatch", concept, "$.['skos:closeMatch']"));
        this.addPath(new DataElement("Concept/skos:notation", concept, "$.['skos:notation']"));
        this.addPath(new DataElement("Concept/skos:inScheme", concept, "$.['skos:inScheme']"));
        this.addPath(new DataElement("Concept/skos:prefLabel", concept, "$.['skos:prefLabel']"));
        this.addPath(new DataElement("Concept/skos:altLabel", concept, "$.['skos:altLabel']"));
        this.addPath(new DataElement("Concept/skos:note", concept, "$.['skos:note']"));
        DataElement europeanaAggregation = new DataElement("EuropeanaAggregation", "$.['edm:EuropeanaAggregation']").setActive(false);
        europeanaAggregation.setCollection(true);
        this.addPath(europeanaAggregation);
        this.addPath(new DataElement("EuropeanaAggregation/edm:country", europeanaAggregation, "$.['edm:country']").setActive(false));
        this.addPath(new DataElement("EuropeanaAggregation/edm:language", europeanaAggregation, "$.['edm:language']").setActive(false));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:title", "Proxy/dc:description"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:type", "Proxy/dc:subject", "Proxy/dc:coverage", "Proxy/dcterms:temporal", "Proxy/dcterms:spatial"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy"));
        this.noLanguageFields.addAll(Arrays.asList("ProvidedCHO", "ProvidedCHO/rdf:about", "Proxy", "Proxy/rdf:about", "Proxy/edm:isNextInSequence", "Proxy/edm:type", "Proxy/ore:proxyFor", "Proxy/ore:proxyIn", "Proxy/edm:europeanaProxy", "Aggregation", "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy", "Aggregation/edm:object", "Aggregation/edm:hasView", "Aggregation/rdf:about", "Place", "Place/rdf:about", "Place/wgs84:lat", "Place/wgs84:long", "Place/wgs84:alt", "Place/wgs84_pos:lat_long", "Place/owl:sameAs", "Agent", "Agent/rdf:about", "Timespan", "Timespan/rdf:about", "Concept", "Concept/rdf:about"));
        this.emptyStrings.add("$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:title']");
        this.emptyStrings.add("$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:description']");
        this.emptyStrings.add("$.['ore:Proxy'][?(@['edm:europeanaProxy'][0] == 'false')]['dc:subject']");
        this.extractableFields.put("recordId", "$.identifier");
        this.extractableFields.put("dataset", "$.sets[0]");
        this.extractableFields.put("dataProvider", "$.['ore:Aggregation'][0]['edm:dataProvider'][0]");
    }

    @Override
    public Format getFormat() {
        return Format.JSON;
    }

    @Override
    public List<DataElement> getCollectionPaths() {
        return new ArrayList<DataElement>(this.collectionPaths.values());
    }
}

