/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema.edm;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.edm.EdmSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EdmFullBeanSchema
extends EdmSchema
implements Serializable {
    private static final long serialVersionUID = 3673596446212645981L;
    public static final String ABOUT = "$.['about']";

    public EdmFullBeanSchema() {
        this.initialize();
    }

    private void initialize() {
        this.longSubjectPath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcSubject']";
        this.titlePath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcTitle']";
        this.descriptionPath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcDescription']";
        DataElement providedCHO = new DataElement("ProvidedCHO", "$.['providedCHOs'][0]");
        providedCHO.setCollection(true);
        this.addPath(providedCHO);
        DataElement providedCHOIdentifier = new DataElement("ProvidedCHO/rdf:about", providedCHO, ABOUT).setCategories(Category.MANDATORY);
        providedCHO.setIdentifier(providedCHOIdentifier);
        this.addPath(providedCHOIdentifier);
        DataElement proxy = new DataElement("Proxy", "$.['proxies'][?(@['europeanaProxy'] == false)]");
        proxy.setCollection(true);
        this.addPath(proxy);
        DataElement proxyIdentifier = new DataElement("Proxy/rdf:about", proxy, ABOUT);
        proxy.setIdentifier(proxyIdentifier);
        this.addPath(proxyIdentifier);
        this.addPath(new DataElement("Proxy/dc:title", proxy, "$.['dcTitle']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_title_txt"));
        this.addPath(new DataElement("Proxy/dcterms:alternative", proxy, "$.['dctermsAlternative']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dcterms_alternative_txt"));
        this.addPath(new DataElement("Proxy/dc:description", proxy, "$.['dcDescription']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_description_txt"));
        this.addPath(new DataElement("Proxy/dc:creator", proxy, "$.['dcCreator']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:publisher", proxy, "$.['dcPublisher']").setCategories(Category.SEARCHABILITY, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:contributor", proxy, "$.['dcContributor']").setCategories(Category.SEARCHABILITY));
        this.addPath(new DataElement("Proxy/dc:type", proxy, "$.['dcType']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:identifier", proxy, "$.['dcIdentifier']").setCategories(Category.IDENTIFICATION));
        this.addPath(new DataElement("Proxy/dc:language", proxy, "$.['dcLanguage']").setCategories(Category.DESCRIPTIVENESS, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:coverage", proxy, "$.['dcCoverage']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:temporal", proxy, "$.['dctermsTemporal']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:spatial", proxy, "$.['dctermsSpatial']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:subject", proxy, "$.['dcSubject']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:date", proxy, "$.['dcDate']").setCategories(Category.IDENTIFICATION, Category.BROWSING, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:created", proxy, "$.['dctermsCreated']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:issued", proxy, "$.['dctermsIssued']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:extent", proxy, "$.['dctermsExtent']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:medium", proxy, "$.['dctermsMedium']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:provenance", proxy, "$.['dctermsProvenance']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dcterms:hasPart", proxy, "$.['dctermsHasPart']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:isPartOf", proxy, "$.['dctermsIsPartOf']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:format", proxy, "$.['dcFormat']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:source", proxy, "$.['dcSource']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dc:rights", proxy, "$.['dcRights']").setCategories(Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:relation", proxy, "$.['dcRelation']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:isNextInSequence", proxy, "$.['edmIsNextInSequence']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:type", proxy, "$.['edmType']").setCategories(Category.SEARCHABILITY, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:europeanaProxy", proxy, "$.['europeanaProxy']"));
        this.addPath(new DataElement("Proxy/edm:year", proxy, "$.['year']"));
        this.addPath(new DataElement("Proxy/edm:userTag", proxy, "$.['userTags']"));
        this.addPath(new DataElement("Proxy/ore:proxyIn", proxy, "$.['proxyIn']"));
        this.addPath(new DataElement("Proxy/ore:proxyFor", proxy, "$.['proxyFor']"));
        this.addPath(new DataElement("Proxy/dcterms:conformsTo", proxy, "$.['dctermsConformsTo']"));
        this.addPath(new DataElement("Proxy/dcterms:hasFormat", proxy, "$.['dctermsHasFormat']"));
        this.addPath(new DataElement("Proxy/dcterms:hasVersion", proxy, "$.['dctermsHasVersion']"));
        this.addPath(new DataElement("Proxy/dcterms:isFormatOf", proxy, "$.['dctermsIsFormatOf']"));
        this.addPath(new DataElement("Proxy/dcterms:isReferencedBy", proxy, "$.['dctermsIsReferencedBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isReplacedBy", proxy, "$.['dctermsIsReplacedBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isRequiredBy", proxy, "$.['dctermsIsRequiredBy']"));
        this.addPath(new DataElement("Proxy/dcterms:isVersionOf", proxy, "$.['dctermsIsVersionOf']"));
        this.addPath(new DataElement("Proxy/dcterms:references", proxy, "$.['dctermsReferences']"));
        this.addPath(new DataElement("Proxy/dcterms:replaces", proxy, "$.['dctermsReplaces']"));
        this.addPath(new DataElement("Proxy/dcterms:requires", proxy, "$.['dctermsRequires']"));
        this.addPath(new DataElement("Proxy/dcterms:tableOfContents", proxy, "$.['dctermsTOC']"));
        this.addPath(new DataElement("Proxy/edm:currentLocation", proxy, "$.['edmCurrentLocation']"));
        this.addPath(new DataElement("Proxy/edm:hasMet", proxy, "$.['edmHasMet']"));
        this.addPath(new DataElement("Proxy/edm:hasType", proxy, "$.['edmHasType']"));
        this.addPath(new DataElement("Proxy/edm:incorporates", proxy, "$.['edmIncorporates']"));
        this.addPath(new DataElement("Proxy/edm:isDerivativeOf", proxy, "$.['edmIsDerivativeOf']"));
        this.addPath(new DataElement("Proxy/edm:isRelatedTo", proxy, "$.['edmIsRelatedTo']"));
        this.addPath(new DataElement("Proxy/edm:isRepresentationOf", proxy, "$.['edmIsRepresentationOf']"));
        this.addPath(new DataElement("Proxy/edm:isSimilarTo", proxy, "$.['edmIsSimilarTo']"));
        this.addPath(new DataElement("Proxy/edm:isSuccessorOf", proxy, "$.['edmIsSuccessorOf']"));
        this.addPath(new DataElement("Proxy/edm:realizes", proxy, "$.['edmRealizes']"));
        this.addPath(new DataElement("Proxy/edm:wasPresentAt", proxy, "$.['edmWasPresentAt']"));
        DataElement aggregation = new DataElement("Aggregation", "$.['aggregations'][0]");
        aggregation.setCollection(true);
        this.addPath(aggregation);
        DataElement aggregationIdentifier = new DataElement("Aggregation/rdf:about", aggregation, ABOUT);
        this.addPath(aggregationIdentifier);
        aggregation.setIdentifier(aggregationIdentifier);
        this.addPath(new DataElement("Aggregation/edm:rights", aggregation, "$.['edmRights']").setCategories(Category.MANDATORY, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:provider", aggregation, "$.['edmProvider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION));
        this.addPath(new DataElement("Aggregation/edm:dataProvider", aggregation, "$.['edmDataProvider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION));
        this.addPath(new DataElement("Aggregation/edm:isShownAt", aggregation, "$.['edmIsShownAt']").setCategories(Category.BROWSING, Category.VIEWING));
        this.addPath(new DataElement("Aggregation/edm:isShownBy", aggregation, "$.['edmIsShownBy']").setCategories(Category.BROWSING, Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:object", aggregation, "$.['edmObject']").setCategories(Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:hasView", aggregation, "$.['hasView']").setCategories(Category.BROWSING, Category.VIEWING));
        this.addPath(new DataElement("Aggregation/dc:rights", aggregation, "$.['dcRights']"));
        this.addPath(new DataElement("Aggregation/edm:ugc", aggregation, "$.['edmUgc']"));
        this.addPath(new DataElement("Aggregation/edm:aggregatedCHO", aggregation, "$.['aggregatedCHO']"));
        this.addPath(new DataElement("Aggregation/edm:intermediateProvider", aggregation, "$.['edmIntermediateProvider']"));
        DataElement place = new DataElement("Place", "$.['places']");
        place.setCollection(true);
        this.addPath(place);
        DataElement placeIdentifier = new DataElement("Place/rdf:about", place, ABOUT);
        this.addPath(placeIdentifier);
        place.setIdentifier(placeIdentifier);
        this.addPath(new DataElement("Place/rdf:about", place, ABOUT));
        this.addPath(new DataElement("Place/wgs84:lat", place, "$.['latitude']"));
        this.addPath(new DataElement("Place/wgs84:long", place, "$.['longitude']"));
        this.addPath(new DataElement("Place/wgs84:alt", place, "$.['altitude']"));
        this.addPath(new DataElement("Place/dcterms:isPartOf", place, "$.['isPartOf']"));
        this.addPath(new DataElement("Place/wgs84_pos:lat_long", place, "$.['position']"));
        this.addPath(new DataElement("Place/dcterms:hasPart", place, "$.['dctermsHasPart']"));
        this.addPath(new DataElement("Place/owl:sameAs", place, "$.['owlSameAs']"));
        this.addPath(new DataElement("Place/skos:prefLabel", place, "$.['prefLabel']"));
        this.addPath(new DataElement("Place/skos:altLabel", place, "$.['altLabel']"));
        this.addPath(new DataElement("Place/skos:note", place, "$.['note']"));
        DataElement agent = new DataElement("Agent", "$.['agents']");
        agent.setCollection(true);
        this.addPath(agent);
        DataElement agentIdentifier = new DataElement("Agent/rdf:about", agent, ABOUT);
        this.addPath(agentIdentifier);
        agent.setIdentifier(agentIdentifier);
        this.addPath(new DataElement("Agent/edm:begin", agent, "$.['begin']"));
        this.addPath(new DataElement("Agent/edm:end", agent, "$.['end']"));
        this.addPath(new DataElement("Agent/edm:hasMet", agent, "$.['edmHasMet']"));
        this.addPath(new DataElement("Agent/edm:isRelatedTo", agent, "$.['edmIsRelatedTo']"));
        this.addPath(new DataElement("Agent/owl:sameAs", agent, "$.['owlSameAs']"));
        this.addPath(new DataElement("Agent/foaf:name", agent, "$.['foafName']"));
        this.addPath(new DataElement("Agent/dc:date", agent, "$.['dcDate']"));
        this.addPath(new DataElement("Agent/dc:identifier", agent, "$.['dcIdentifier']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfBirth", agent, "$.['rdaGr2DateOfBirth']"));
        this.addPath(new DataElement("Agent/rdaGr2:placeOfBirth", agent, "$.['rdaGr2PlaceOfBirth']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfDeath", agent, "$.['rdaGr2DateOfDeath']"));
        this.addPath(new DataElement("Agent/rdaGr2:placeOfDeath", agent, "$.['rdaGr2PlaceOfDeath']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfEstablishment", agent, "$.['rdaGr2DateOfEstablishment']"));
        this.addPath(new DataElement("Agent/rdaGr2:dateOfTermination", agent, "$.['rdaGr2DateOfTermination']"));
        this.addPath(new DataElement("Agent/rdaGr2:gender", agent, "$.['rdaGr2Gender']"));
        this.addPath(new DataElement("Agent/rdaGr2:professionOrOccupation", agent, "$.['rdaGr2ProfessionOrOccupation']"));
        this.addPath(new DataElement("Agent/rdaGr2:biographicalInformation", agent, "$.['rdaGr2BiographicalInformation']"));
        this.addPath(new DataElement("Agent/skos:prefLabel", agent, "$.['prefLabel']"));
        this.addPath(new DataElement("Agent/skos:altLabel", agent, "$.['altLabel']"));
        this.addPath(new DataElement("Agent/skos:note", agent, "$.['note']"));
        DataElement timespan = new DataElement("Timespan", "$.['timespans']");
        timespan.setCollection(true);
        this.addPath(timespan);
        DataElement timespanIdentifier = new DataElement("Timespan/rdf:about", timespan, ABOUT);
        this.addPath(timespanIdentifier);
        timespan.setIdentifier(timespanIdentifier);
        this.addPath(new DataElement("Timespan/rdf:about", timespan, ABOUT));
        this.addPath(new DataElement("Timespan/edm:begin", timespan, "$.['begin']"));
        this.addPath(new DataElement("Timespan/edm:end", timespan, "$.['end']"));
        this.addPath(new DataElement("Timespan/dcterms:isPartOf", timespan, "$.['isPartOf']"));
        this.addPath(new DataElement("Timespan/dcterms:hasPart", timespan, "$.['hasPart']"));
        this.addPath(new DataElement("Timespan/edm:isNextInSequence", timespan, "$.['edm:isNextInSequence']"));
        this.addPath(new DataElement("Timespan/owl:sameAs", timespan, "$.['owlSameAs']"));
        this.addPath(new DataElement("Timespan/skos:prefLabel", timespan, "$.['prefLabel']"));
        this.addPath(new DataElement("Timespan/skos:altLabel", timespan, "$.['altLabel']"));
        this.addPath(new DataElement("Timespan/skos:note", timespan, "$.['note']"));
        DataElement concept = new DataElement("Concept", "$.['concepts']");
        concept.setCollection(true);
        this.addPath(concept);
        DataElement conceptIdentifier = new DataElement("Concept/rdf:about", concept, ABOUT);
        this.addPath(conceptIdentifier);
        concept.setIdentifier(conceptIdentifier);
        this.addPath(new DataElement("Concept/rdf:about", concept, ABOUT));
        this.addPath(new DataElement("Concept/skos:broader", concept, "$.['broader']"));
        this.addPath(new DataElement("Concept/skos:narrower", concept, "$.['narrower']"));
        this.addPath(new DataElement("Concept/skos:related", concept, "$.['related']"));
        this.addPath(new DataElement("Concept/skos:broadMatch", concept, "$.['broadMatch']"));
        this.addPath(new DataElement("Concept/skos:narrowMatch", concept, "$.['narrowMatch']"));
        this.addPath(new DataElement("Concept/skos:relatedMatch", concept, "$.['relatedMatch']"));
        this.addPath(new DataElement("Concept/skos:exactMatch", concept, "$.['exactMatch']"));
        this.addPath(new DataElement("Concept/skos:closeMatch", concept, "$.['closeMatch']"));
        this.addPath(new DataElement("Concept/skos:notation", concept, "$.['notation']"));
        this.addPath(new DataElement("Concept/skos:inScheme", concept, "$.['inScheme']"));
        this.addPath(new DataElement("Concept/skos:prefLabel", concept, "$.['prefLabel']"));
        this.addPath(new DataElement("Concept/skos:altLabel", concept, "$.['altLabel']"));
        this.addPath(new DataElement("Concept/skos:note", concept, "$.['note']"));
        DataElement europeanaAggregation = new DataElement("EuropeanaAggregation", "$.['europeanaAggregation']").setActive(false);
        europeanaAggregation.setCollection(true);
        this.addPath(europeanaAggregation);
        this.addPath(new DataElement("EuropeanaAggregation/edm:country", europeanaAggregation, "$.['edmCountry']").setActive(false));
        this.addPath(new DataElement("EuropeanaAggregation/edm:language", europeanaAggregation, "$.['edmLanguage']").setActive(false));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:title", "Proxy/dc:description"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:type", "Proxy/dc:subject", "Proxy/dc:coverage", "Proxy/dcterms:temporal", "Proxy/dcterms:spatial"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy"));
        this.noLanguageFields.addAll(Arrays.asList("ProvidedCHO", "ProvidedCHO/rdf:about", "Proxy", "Proxy/rdf:about", "Proxy/edm:isNextInSequence", "Proxy/edm:type", "Proxy/ore:proxyFor", "Proxy/ore:proxyIn", "Proxy/edm:europeanaProxy", "Proxy/edm:year", "Proxy/edm:userTag", "Proxy/edm:hasMet", "Proxy/edm:incorporates", "Proxy/edm:isDerivativeOf", "Proxy/edm:isRepresentationOf", "Proxy/edm:isSimilarTo", "Proxy/edm:isSuccessorOf", "Proxy/edm:realizes", "Proxy/edm:wasPresentAt", "Aggregation", "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy", "Aggregation/edm:object", "Aggregation/edm:hasView", "Aggregation/rdf:about", "Aggregation/edm:rights", "Aggregation/edm:ugc", "Aggregation/edm:aggregatedCHO", "Agent", "Agent/rdf:about", "Agent/edm:hasMet", "Agent/edm:isRelatedTo", "Agent/owl:sameAs", "Concept", "Concept/rdf:about", "Concept/skos:broader", "Concept/skos:narrower", "Concept/skos:related", "Concept/skos:broadMatch", "Concept/skos:narrowMatch", "Concept/skos:relatedMatch", "Concept/skos:exactMatch", "Concept/skos:closeMatch", "Concept/skos:notation", "Concept/skos:inScheme", "Place", "Place/rdf:about", "Place/wgs84:lat", "Place/wgs84:long", "Place/wgs84:alt", "Place/wgs84_pos:lat_long", "Place/owl:sameAs", "Timespan", "Timespan/rdf:about", "Timespan/owl:sameAs"));
        this.emptyStrings.add(this.titlePath);
        this.emptyStrings.add(this.descriptionPath);
        this.emptyStrings.add(this.longSubjectPath);
        this.extractableFields.put("recordId", "$.identifier");
        this.extractableFields.put("dataset", "$.sets[0]");
        this.extractableFields.put("dataProvider", "$.['aggregations'][0]['edmDataProvider'][0]");
    }

    @Override
    public Format getFormat() {
        return Format.JSON;
    }

    @Override
    public List<DataElement> getCollectionPaths() {
        return new ArrayList<DataElement>(this.collectionPaths.values());
    }
}

