/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema.edm;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.edm.EdmSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EdmFullBeanLimitedSchema
extends EdmSchema
implements Serializable {
    private static final long serialVersionUID = 5248200128650498403L;

    public EdmFullBeanLimitedSchema() {
        this.initialize();
    }

    private void initialize() {
        this.longSubjectPath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcSubject']";
        this.titlePath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcTitle']";
        this.descriptionPath = "$.['proxies'][?(@['europeanaProxy'] == false)]['dcDescription']";
        this.addPath(new DataElement("edm:ProvidedCHO/@about", "$.['providedCHOs'][0]['about']").setCategories(Category.MANDATORY));
        this.addPath(new DataElement("Proxy/dc:title", this.titlePath).setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_title_txt"));
        this.addPath(new DataElement("Proxy/dcterms:alternative", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsAlternative']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dcterms_alternative_txt"));
        this.addPath(new DataElement("Proxy/dc:description", this.descriptionPath).setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.MULTILINGUALITY).setIndexField("dc_description_txt"));
        this.addPath(new DataElement("Proxy/dc:creator", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcCreator']").setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:publisher", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcPublisher']").setCategories(Category.SEARCHABILITY, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:contributor", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcContributor']").setCategories(Category.SEARCHABILITY));
        this.addPath(new DataElement("Proxy/dc:type", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcType']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.IDENTIFICATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:identifier", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcIdentifier']").setCategories(Category.IDENTIFICATION));
        this.addPath(new DataElement("Proxy/dc:language", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcLanguage']").setCategories(Category.DESCRIPTIVENESS, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:coverage", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcCoverage']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:temporal", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsTemporal']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:spatial", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsSpatial']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:subject", this.longSubjectPath).setCategories(Category.DESCRIPTIVENESS, Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.MULTILINGUALITY));
        this.addPath(new DataElement("Proxy/dc:date", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcDate']").setCategories(Category.IDENTIFICATION, Category.BROWSING, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:created", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsCreated']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:issued", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsIssued']").setCategories(Category.IDENTIFICATION, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:extent", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsExtent']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:medium", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsMedium']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dcterms:provenance", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsProvenance']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dcterms:hasPart", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsHasPart']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dcterms:isPartOf", "$.['proxies'][?(@['europeanaProxy'] == false)]['dctermsIsPartOf']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/dc:format", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcFormat']").setCategories(Category.DESCRIPTIVENESS, Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:source", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcSource']").setCategories(Category.DESCRIPTIVENESS));
        this.addPath(new DataElement("Proxy/dc:rights", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcRights']").setCategories(Category.REUSABILITY));
        this.addPath(new DataElement("Proxy/dc:relation", "$.['proxies'][?(@['europeanaProxy'] == false)]['dcRelation']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:isNextInSequence", "$.['proxies'][?(@['europeanaProxy'] == false)]['edmIsNextInSequence']").setCategories(Category.SEARCHABILITY, Category.CONTEXTUALIZATION, Category.BROWSING));
        this.addPath(new DataElement("Proxy/edm:type", "$.['proxies'][?(@['europeanaProxy'] == false)]['edmType']").setCategories(Category.SEARCHABILITY, Category.BROWSING));
        this.addPath(new DataElement("Aggregation/edm:rights", "$.['aggregations'][0]['edmRights']").setCategories(Category.MANDATORY, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:provider", "$.['aggregations'][0]['edmProvider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION));
        this.addPath(new DataElement("Aggregation/edm:dataProvider", "$.['aggregations'][0]['edmDataProvider']").setCategories(Category.MANDATORY, Category.SEARCHABILITY, Category.IDENTIFICATION).setExtractable());
        this.addPath(new DataElement("Aggregation/edm:isShownAt", "$.['aggregations'][0]['edmIsShownAt']").setCategories(Category.BROWSING, Category.VIEWING));
        this.addPath(new DataElement("Aggregation/edm:isShownBy", "$.['aggregations'][0]['edmIsShownBy']").setCategories(Category.BROWSING, Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:object", "$.['aggregations'][0]['edmObject']").setCategories(Category.VIEWING, Category.REUSABILITY));
        this.addPath(new DataElement("Aggregation/edm:hasView", "$.['aggregations'][0]['hasView']").setCategories(Category.BROWSING, Category.VIEWING));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:title", "Proxy/dc:description"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Proxy/dc:type", "Proxy/dc:subject", "Proxy/dc:coverage", "Proxy/dcterms:temporal", "Proxy/dcterms:spatial"));
        this.fieldGroups.add(new FieldGroup(Category.MANDATORY, "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy"));
        this.noLanguageFields.addAll(Arrays.asList("edm:ProvidedCHO/@about", "Proxy/edm:isNextInSequence", "Proxy/edm:type", "Aggregation/edm:isShownAt", "Aggregation/edm:isShownBy", "Aggregation/edm:object", "Aggregation/edm:hasView"));
        this.extractableFields.put("recordId", "$.identifier");
        this.extractableFields.put("dataset", "$.sets[0]");
        this.extractableFields.put("dataProvider", "$.['aggregations'][0]['edmDataProvider'][0]");
        this.emptyStrings.add(this.titlePath);
        this.emptyStrings.add(this.descriptionPath);
        this.emptyStrings.add(this.longSubjectPath);
    }

    @Override
    public Format getFormat() {
        return Format.JSON;
    }

    @Override
    public List<DataElement> getCollectionPaths() {
        return new ArrayList<DataElement>();
    }
}

