/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema;

import de.gwdg.metadataqa.api.configuration.schema.Rule;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.schema.Format;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface Schema
extends Serializable {
    public Format getFormat();

    public List<DataElement> getCollectionPaths();

    public List<DataElement> getRootChildrenPaths();

    public List<DataElement> getPaths();

    public DataElement getPathByLabel(String var1);

    public DataElement getRecordId();

    public List<FieldGroup> getFieldGroups();

    public List<String> getNoLanguageFields();

    public List<DataElement> getIndexFields();

    public Map<String, String> getExtractableFields();

    public void setExtractableFields(Map<String, String> var1);

    public void addExtractableField(String var1, String var2);

    public List<String> getCategories();

    public List<RuleChecker> getRuleCheckers();

    default public Map<String, String> getNamespaces() {
        return null;
    }

    default public void checkConsistency() {
        for (DataElement path : this.getPaths()) {
            List<Rule> rules = path.getRules();
            if (rules == null || rules.isEmpty()) continue;
            for (Rule rule : rules) {
                if (rule.getEquals() != null && this.getPathByLabel(rule.getEquals()) == null) {
                    throw new IllegalArgumentException(String.format("%s refers to a nonexistent field in 'equals: %s'", path.getLabel(), rule.getEquals()));
                }
                if (rule.getDisjoint() != null && this.getPathByLabel(rule.getDisjoint()) == null) {
                    throw new IllegalArgumentException(String.format("%s refers to a nonexistent field in 'disjoint: %s'", path.getLabel(), rule.getDisjoint()));
                }
                if (rule.getLessThan() != null && this.getPathByLabel(rule.getLessThan()) == null) {
                    throw new IllegalArgumentException(String.format("%s refers to a nonexistent field in 'lessThan: %s'", path.getLabel(), rule.getLessThan()));
                }
                if (rule.getLessThanOrEquals() == null || this.getPathByLabel(rule.getLessThanOrEquals()) != null) continue;
                throw new IllegalArgumentException(String.format("%s refers to a nonexistent field in 'lessThanOrEquals: %s'", path.getLabel(), rule.getLessThanOrEquals()));
            }
        }
    }

    public void merge(Schema var1, boolean var2);
}

