/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.schema;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.ProblemCatalogSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.schema.SchemaUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MarcJsonSchema
implements Schema,
ProblemCatalogSchema,
Serializable {
    private static final long serialVersionUID = -351328095358861985L;
    private static final Map<String, DataElement> PATHS = new LinkedHashMap<String, DataElement>();
    private static final Map<String, DataElement> COLLECTION_PATHS = new LinkedHashMap<String, DataElement>();
    private static final Map<String, DataElement> DIRECT_CHILDREN = new LinkedHashMap<String, DataElement>();
    public static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private static Map<String, String> extractableFields = new LinkedHashMap<String, String>();
    private static List<String> categories = null;
    private static List<RuleChecker> ruleCheckers = null;
    public static final String DATAFIELD_PATTERN = "$.datafield[?(@.tag == '%s')].subfield[?(@.code == '%s')].content";
    public static final String DATAFIELD_PARENT_PATTERN = "$.datafield[?(@.tag == '%s')]";
    public static final String DATAFIELD_IND1_PATTERN = "$.ind1";
    public static final String DATAFIELD_IND2_PATTERN = "$.ind2";
    public static final String DATAFIELD_CHILDREN_PATTERN = "$.subfield[?(@.code == '%s')].content";

    private static void registerDatafield(String tag, String ... codes) {
        DataElement parent = new DataElement(tag, MarcJsonSchema.createDatafieldParentPath(tag));
        parent.setCollection(true);
        MarcJsonSchema.addPath(parent);
        MarcJsonSchema.addPath(new DataElement(tag + "$ind1", parent, DATAFIELD_IND1_PATTERN));
        MarcJsonSchema.addPath(new DataElement(tag + "$ind2", parent, DATAFIELD_IND2_PATTERN));
        for (String code : codes) {
            MarcJsonSchema.addPath(new DataElement(tag + "$" + code, parent, MarcJsonSchema.createDatafieldChildrenPath(code)));
        }
    }

    private static DataElement createDatafieldBranch(String tag, String code) {
        return new DataElement(tag + "$" + code, MarcJsonSchema.createDatafieldPath(tag, code));
    }

    public static String createDatafieldPath(String tag, String code) {
        return String.format(DATAFIELD_PATTERN, tag, code);
    }

    private static String createDatafieldParentPath(String tag) {
        return String.format(DATAFIELD_PARENT_PATTERN, tag);
    }

    private static String createDatafieldChildrenPath(String code) {
        return String.format(DATAFIELD_CHILDREN_PATTERN, code);
    }

    @Override
    public Format getFormat() {
        return Format.JSON;
    }

    @Override
    public List<DataElement> getCollectionPaths() {
        return new ArrayList<DataElement>(COLLECTION_PATHS.values());
    }

    @Override
    public List<DataElement> getRootChildrenPaths() {
        return new ArrayList<DataElement>(DIRECT_CHILDREN.values());
    }

    @Override
    public List<DataElement> getPaths() {
        return new ArrayList<DataElement>(PATHS.values());
    }

    @Override
    public List<FieldGroup> getFieldGroups() {
        return new ArrayList<FieldGroup>();
    }

    @Override
    public List<String> getNoLanguageFields() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public List<DataElement> getIndexFields() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public Map<String, String> getExtractableFields() {
        return extractableFields;
    }

    @Override
    public void setExtractableFields(Map<String, String> extractableFields) {
        MarcJsonSchema.extractableFields = extractableFields;
    }

    @Override
    public void addExtractableField(String label, String path) {
        extractableFields.put(label, path);
    }

    private static void addPath(DataElement dataElement) {
        PATHS.put(dataElement.getLabel(), dataElement);
        if (dataElement.getParent() == null) {
            DIRECT_CHILDREN.put(dataElement.getLabel(), dataElement);
        }
        if (dataElement.isCollection()) {
            COLLECTION_PATHS.put(dataElement.getLabel(), dataElement);
        }
    }

    @Override
    public List<String> getEmptyStringPaths() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public String getSubjectPath() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public String getTitlePath() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public String getDescriptionPath() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public DataElement getPathByLabel(String label) {
        return PATHS.get(label);
    }

    @Override
    public DataElement getRecordId() {
        return PATHS.get("001");
    }

    @Override
    public List<String> getCategories() {
        if (categories == null) {
            categories = Category.extractCategories(PATHS.values());
        }
        return categories;
    }

    @Override
    public List<RuleChecker> getRuleCheckers() {
        if (ruleCheckers == null) {
            ruleCheckers = SchemaUtils.getRuleCheckers(this);
        }
        return ruleCheckers;
    }

    @Override
    public void merge(Schema schemaB, boolean allowOverwrite) {
        throw new UnsupportedOperationException("The method in ot available in this class.");
    }

    static {
        MarcJsonSchema.addPath(new DataElement("leader", "$.leader"));
        MarcJsonSchema.addPath(new DataElement("001", "$.controlfield[?(@.tag == '001')].content"));
        MarcJsonSchema.addPath(new DataElement("003", "$.controlfield[?(@.tag == '003')].content"));
        MarcJsonSchema.addPath(new DataElement("005", "$.controlfield[?(@.tag == '005')].content"));
        MarcJsonSchema.addPath(new DataElement("006", "$.controlfield[?(@.tag == '006')].content"));
        MarcJsonSchema.addPath(new DataElement("007", "$.controlfield[?(@.tag == '007')].content"));
        MarcJsonSchema.addPath(new DataElement("008", "$.controlfield[?(@.tag == '008')].content"));
        MarcJsonSchema.registerDatafield("010", "a", "b", "z", "8", "z");
        MarcJsonSchema.registerDatafield("013", "a", "c");
        MarcJsonSchema.registerDatafield("015", "2", "a", "z");
        MarcJsonSchema.registerDatafield("016", "2", "a");
        MarcJsonSchema.registerDatafield("017", "a", "b");
        MarcJsonSchema.registerDatafield("018", "a");
        MarcJsonSchema.registerDatafield("019", "a");
        MarcJsonSchema.registerDatafield("020", "6", "9", "a", "b", "c", "z");
        MarcJsonSchema.registerDatafield("022", "a", "c", "y", "z");
        MarcJsonSchema.registerDatafield("024", "2", "9", "a", "c", "d", "z");
        MarcJsonSchema.registerDatafield("025", "a");
        MarcJsonSchema.registerDatafield("026", "a", "e");
        MarcJsonSchema.registerDatafield("027", "a");
        MarcJsonSchema.registerDatafield("028", "a", "b");
        MarcJsonSchema.registerDatafield("029", "a", "b", "c");
        MarcJsonSchema.registerDatafield("030", "a", "z");
        MarcJsonSchema.registerDatafield("032", "a", "b");
        MarcJsonSchema.registerDatafield("033", "a", "b", "c");
        MarcJsonSchema.registerDatafield("034", "a", "b", "c", "d", "e", "f", "g");
        MarcJsonSchema.registerDatafield("035", "6", "a", "z");
        MarcJsonSchema.registerDatafield("036", "a");
        MarcJsonSchema.registerDatafield("037", "a", "b", "c", "f", "n");
        MarcJsonSchema.registerDatafield("038", "a");
        MarcJsonSchema.registerDatafield("040", "6", "a", "b", "c", "d", "e", "h", "t", "w");
        MarcJsonSchema.registerDatafield("041", "2", "a", "b", "d", "e", "f", "g", "h", "j", "k", "m", "n");
        MarcJsonSchema.registerDatafield("042", "a");
        MarcJsonSchema.registerDatafield("043", "2", "a", "b", "c");
        MarcJsonSchema.registerDatafield("044", "a", "h");
        MarcJsonSchema.registerDatafield("045", "a", "b");
        MarcJsonSchema.registerDatafield("046", "2", "a", "b", "d", "j", "k");
        MarcJsonSchema.registerDatafield("047", "a");
        MarcJsonSchema.registerDatafield("048", "a", "b");
        MarcJsonSchema.registerDatafield("049", "a");
        MarcJsonSchema.registerDatafield("050", "3", "a", "b", "i");
        MarcJsonSchema.registerDatafield("051", "a", "b", "c", "i");
        MarcJsonSchema.registerDatafield("052", "a", "b");
        MarcJsonSchema.registerDatafield("055", "2", "a", "b");
        MarcJsonSchema.registerDatafield("060", "b");
        MarcJsonSchema.registerDatafield("061", "a");
        MarcJsonSchema.registerDatafield("066", "a", "c");
        MarcJsonSchema.registerDatafield("070", "a", "b");
        MarcJsonSchema.registerDatafield("072", "2", "a", "x");
        MarcJsonSchema.registerDatafield("074", "a", "z");
        MarcJsonSchema.registerDatafield("080", "2", "a", "b", "x");
        MarcJsonSchema.registerDatafield("082", "2", "9", "a", "b", "m", "n", "q");
        MarcJsonSchema.registerDatafield("083", "2", "a");
        MarcJsonSchema.registerDatafield("084", "a", "b");
        MarcJsonSchema.registerDatafield("085", "8", "a", "b", "s", "z");
        MarcJsonSchema.registerDatafield("086", "2", "6", "a", "z");
        MarcJsonSchema.registerDatafield("088", "a");
        MarcJsonSchema.registerDatafield("090", "a", "b", "v");
        MarcJsonSchema.registerDatafield("100", "0", "4", "6", "a", "b", "c", "d", "e", "f", "g", "h", "k", "l", "n", "p", "q", "t", "u");
        MarcJsonSchema.registerDatafield("110", "0", "4", "6", "9", "a", "b", "c", "e", "f", "k", "l", "n", "p", "s", "t", "u");
        MarcJsonSchema.registerDatafield("111", "0", "4", "6", "9", "a", "b", "c", "d", "e", "f", "g", "j", "k", "l", "n", "q", "p", "t");
        MarcJsonSchema.registerDatafield("130", "0", "6", "7", "9", "a", "d", "f", "g", "h", "k", "l", "m", "n", "o", "p", "r", "s", "t", "x", "v");
        MarcJsonSchema.registerDatafield("199", "9");
        MarcJsonSchema.registerDatafield("210", "a");
        MarcJsonSchema.registerDatafield("222", "a", "b");
        MarcJsonSchema.registerDatafield("240", "0", "6", "7", "9", "a", "d", "f", "g", "h", "k", "l", "m", "n", "o", "p", "r", "s", "t", "x");
        MarcJsonSchema.registerDatafield("241", "a");
        MarcJsonSchema.registerDatafield("242", "a", "b", "c", "y");
        MarcJsonSchema.registerDatafield("243", "a", "f", "k", "l");
        MarcJsonSchema.registerDatafield("245", "6", "a", "b", "c", "d", "e", "f", "g", "h", "k", "n", "p", "s", "v");
        MarcJsonSchema.registerDatafield("246", "5", "6", "a", "b", "d", "f", "h", "i", "n", "p");
        MarcJsonSchema.registerDatafield("247", "a", "b", "f", "g", "p");
        MarcJsonSchema.registerDatafield("249", "a", "b", "c", "v");
        MarcJsonSchema.registerDatafield("250", "6", "9", "a", "c");
        MarcJsonSchema.registerDatafield("254", "a");
        MarcJsonSchema.registerDatafield("255", "a", "b", "c", "e");
        MarcJsonSchema.registerDatafield("257", "a");
        MarcJsonSchema.registerDatafield("258", "a");
        MarcJsonSchema.registerDatafield("260", "3", "6", "a", "b", "c", "d", "e", "f", "g", "z");
        MarcJsonSchema.registerDatafield("264", "3", "a", "b", "c");
        MarcJsonSchema.registerDatafield("265", "a");
        MarcJsonSchema.registerDatafield("270", "a", "b", "c", "d", "e", "g", "h", "k", "l", "m", "n");
        MarcJsonSchema.registerDatafield("290", "a", "b");
        MarcJsonSchema.registerDatafield("300", "2", "3", "6", "a", "b", "c", "e", "f", "g", "x");
        MarcJsonSchema.registerDatafield("306", "a");
        MarcJsonSchema.registerDatafield("307", "a");
        MarcJsonSchema.registerDatafield("310", "a", "b");
        MarcJsonSchema.registerDatafield("336", "2", "3", "8", "a", "b");
        MarcJsonSchema.registerDatafield("337", "2", "3", "8", "a", "b");
        MarcJsonSchema.registerDatafield("338", "2", "3", "8", "a", "b");
        MarcJsonSchema.registerDatafield("340", "a");
        MarcJsonSchema.registerDatafield("344", "2", "a", "b", "g", "h");
        MarcJsonSchema.registerDatafield("346", "2", "b");
        MarcJsonSchema.registerDatafield("347", "2", "3", "a", "b", "c", "d");
        MarcJsonSchema.registerDatafield("350", "a");
        MarcJsonSchema.registerDatafield("351", "3", "a", "b");
        MarcJsonSchema.registerDatafield("362", "a", "z");
        MarcJsonSchema.registerDatafield("363", "a", "b", "i", "j", "k", "u");
        MarcJsonSchema.registerDatafield("365", "2", "a");
        MarcJsonSchema.registerDatafield("366", "2", "a", "b", "c", "j", "k", "m");
        MarcJsonSchema.registerDatafield("377", "2", "a");
        MarcJsonSchema.registerDatafield("380", "0", "2", "a");
        MarcJsonSchema.registerDatafield("382", "0", "2", "a", "d", "g", "n", "p", "s", "v");
        MarcJsonSchema.registerDatafield("383", "a", "b", "c");
        MarcJsonSchema.registerDatafield("384", "a", "b");
        MarcJsonSchema.registerDatafield("385", "0", "a", "g");
        MarcJsonSchema.registerDatafield("400", "6", "a", "b", "c", "d", "e", "f", "l", "n", "p", "q", "t", "v", "x");
        MarcJsonSchema.registerDatafield("410", "6", "a", "b", "c", "d", "f", "g", "k", "n", "p", "t", "u", "x", "v");
        MarcJsonSchema.registerDatafield("411", "a", "c", "d", "e", "g", "n", "p", "q", "t", "v");
        MarcJsonSchema.registerDatafield("440", "a", "n", "p", "v", "x");
        MarcJsonSchema.registerDatafield("489", "a", "v");
        MarcJsonSchema.registerDatafield("490", "2", "3", "6", "a", "l", "n", "p", "x", "v");
        MarcJsonSchema.registerDatafield("500", "2", "3", "5", "6", "a", "g", "x");
        MarcJsonSchema.registerDatafield("501", "5", "6", "a");
        MarcJsonSchema.registerDatafield("502", "6", "a", "b", "c", "d", "6");
        MarcJsonSchema.registerDatafield("504", "6", "b");
        MarcJsonSchema.registerDatafield("505", "a", "g", "r", "t", "u");
        MarcJsonSchema.registerDatafield("506", "3", "5", "a", "c", "u");
        MarcJsonSchema.registerDatafield("507", "a");
        MarcJsonSchema.registerDatafield("508", "6", "a");
        MarcJsonSchema.registerDatafield("510", "3", "6", "b", "x");
        MarcJsonSchema.registerDatafield("511", "a");
        MarcJsonSchema.registerDatafield("513", "a", "b");
        MarcJsonSchema.registerDatafield("514", "a");
        MarcJsonSchema.registerDatafield("515", "a");
        MarcJsonSchema.registerDatafield("516", "a");
        MarcJsonSchema.registerDatafield("518", "a");
        MarcJsonSchema.registerDatafield("520", "2", "3", "6", "a", "b", "c", "u");
        MarcJsonSchema.registerDatafield("521", "6", "a", "b");
        MarcJsonSchema.registerDatafield("522", "a");
        MarcJsonSchema.registerDatafield("524", "a");
        MarcJsonSchema.registerDatafield("525", "6", "a");
        MarcJsonSchema.registerDatafield("526", "a", "b", "c", "d", "z");
        MarcJsonSchema.registerDatafield("530", "3", "6", "a", "b", "c", "d", "u");
        MarcJsonSchema.registerDatafield("533", "3", "5", "6", "7", "a", "b", "c", "d", "e", "f", "m", "n", "x");
        MarcJsonSchema.registerDatafield("534", "6", "c", "e", "f", "k", "l", "p", "t", "z");
        MarcJsonSchema.registerDatafield("535", "3", "a", "b", "c", "g", "q");
        MarcJsonSchema.registerDatafield("536", "6", "a", "b", "c", "d", "e", "f", "g", "h");
        MarcJsonSchema.registerDatafield("538", "6", "a", "u");
        MarcJsonSchema.registerDatafield("540", "3", "5", "a", "b", "c", "u");
        MarcJsonSchema.registerDatafield("541", "3", "5", "a", "b", "c", "d", "e", "f", "h", "n", "o");
        MarcJsonSchema.registerDatafield("542", "a", "c", "d", "f", "g");
        MarcJsonSchema.registerDatafield("544", "3", "a", "b", "d", "e", "n");
        MarcJsonSchema.registerDatafield("545", "a", "b");
        MarcJsonSchema.registerDatafield("546", "3", "6", "a", "b");
        MarcJsonSchema.registerDatafield("550", "a");
        MarcJsonSchema.registerDatafield("552", "a");
        MarcJsonSchema.registerDatafield("555", "a", "c", "u");
        MarcJsonSchema.registerDatafield("556", "a");
        MarcJsonSchema.registerDatafield("561", "3", "5", "6", "a");
        MarcJsonSchema.registerDatafield("562", "5", "a", "b", "c");
        MarcJsonSchema.registerDatafield("563", "5", "a");
        MarcJsonSchema.registerDatafield("565", "a");
        MarcJsonSchema.registerDatafield("580", "a");
        MarcJsonSchema.registerDatafield("581", "3", "8", "a");
        MarcJsonSchema.registerDatafield("583", "3", "5", "a", "b", "c", "d", "e", "f", "h", "i", "j", "l", "u", "x");
        MarcJsonSchema.registerDatafield("584", "a");
        MarcJsonSchema.registerDatafield("585", "3", "5", "6", "a");
        MarcJsonSchema.registerDatafield("586", "a");
        MarcJsonSchema.registerDatafield("588", "5", "a");
        MarcJsonSchema.registerDatafield("589", "c", "d");
        MarcJsonSchema.registerDatafield("590", "a");
        MarcJsonSchema.registerDatafield("591", "2", "a", "x");
        MarcJsonSchema.registerDatafield("593", "a");
        MarcJsonSchema.registerDatafield("600", "0", "1", "2", "4", "6", "9", "a", "b", "c", "d", "f", "h", "m", "n", "o", "p", "r", "s", "t", "x", "v");
        MarcJsonSchema.registerDatafield("610", "0", "2", "3", "6", "9", "a", "b", "f", "g", "h", "n", "o", "t", "u", "x", "v");
        MarcJsonSchema.registerDatafield("611", "0", "2", "3", "6", "9", "a", "b", "c", "d", "f", "g", "k", "l", "n", "p", "t");
        MarcJsonSchema.registerDatafield("630", "0", "2", "3", "6", "9", "a", "f", "n", "o", "p", "t", "x");
        MarcJsonSchema.registerDatafield("648", "2", "a", "x", "v");
        MarcJsonSchema.registerDatafield("650", "0", "2", "3", "6", "9", "a", "e", "k", "q", "x", "y", "z");
        MarcJsonSchema.registerDatafield("651", "0", "2", "3", "4", "6", "9", "a", "e", "k", "n", "t", "x", "v", "z");
        MarcJsonSchema.registerDatafield("653", "6", "a");
        MarcJsonSchema.registerDatafield("654", "2", "a", "b", "c");
        MarcJsonSchema.registerDatafield("655", "0", "2", "3", "a", "b", "g", "x", "y", "z");
        MarcJsonSchema.registerDatafield("656", "2", "a", "v", "x", "z");
        MarcJsonSchema.registerDatafield("657", "2", "a", "y");
        MarcJsonSchema.registerDatafield("662", "2", "a", "d");
        MarcJsonSchema.registerDatafield("689", "0", "2", "5", "9", "A", "a", "b", "c", "D", "d", "f", "g", "m", "n", "p", "r", "s", "t", "x", "z");
        MarcJsonSchema.registerDatafield("700", "0", "3", "4", "5", "6", "a", "b", "c", "d", "e", "f", "g", "h", "i", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "T", "u", "U", "x");
        MarcJsonSchema.registerDatafield("710", "0", "3", "4", "5", "6", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "k", "l", "m", "n", "o", "p", "r", "s", "t", "u", "x", "v");
        MarcJsonSchema.registerDatafield("711", "0", "4", "6", "9", "a", "b", "c", "d", "e", "f", "g", "i", "j", "k", "l", "n", "p", "q", "s", "t");
        MarcJsonSchema.registerDatafield("720", "4", "6", "a", "e");
        MarcJsonSchema.registerDatafield("730", "0", "5", "6", "a", "d", "f", "g", "h", "i", "k", "l", "m", "n", "o", "p", "r", "s", "t", "T", "U", "x");
        MarcJsonSchema.registerDatafield("740", "5", "6", "a", "h", "n", "p", "v");
        MarcJsonSchema.registerDatafield("751", "4", "6", "a");
        MarcJsonSchema.registerDatafield("752", "a", "b", "c", "d", "f");
        MarcJsonSchema.registerDatafield("753", "a", "c");
        MarcJsonSchema.registerDatafield("760", "a", "d", "g", "t", "x", "y", "w");
        MarcJsonSchema.registerDatafield("765", "6", "a", "b", "c", "d", "h", "i", "k", "o", "t", "w", "x", "z");
        MarcJsonSchema.registerDatafield("767", "a", "d", "i", "s", "t", "w", "z");
        MarcJsonSchema.registerDatafield("770", "6", "a", "b", "c", "d", "h", "i", "k", "n", "o", "s", "t", "w", "x", "z");
        MarcJsonSchema.registerDatafield("772", "7", "a", "b", "c", "g", "h", "i", "k", "n", "s", "t", "w", "x", "z");
        MarcJsonSchema.registerDatafield("773", "3", "6", "7", "a", "b", "d", "g", "h", "i", "n", "o", "q", "s", "t", "x", "w");
        MarcJsonSchema.registerDatafield("774", "a", "b", "c", "d", "g", "i", "s", "t", "w", "z");
        MarcJsonSchema.registerDatafield("775", "0", "6", "a", "b", "c", "d", "e", "f", "g", "h", "i", "k", "n", "o", "s", "t", "u", "w", "z");
        MarcJsonSchema.registerDatafield("776", "0", "4", "6", "9", "a", "b", "c", "d", "g", "h", "i", "k", "m", "n", "o", "q", "s", "t", "u", "x", "w", "z");
        MarcJsonSchema.registerDatafield("777", "6", "7", "a", "c", "h", "t", "w");
        MarcJsonSchema.registerDatafield("780", "0", "6", "a", "b", "c", "d", "g", "i", "k", "n", "s", "t", "x", "w", "z");
        MarcJsonSchema.registerDatafield("785", "0", "6", "a", "b", "c", "d", "i", "n", "x", "t", "x", "w", "z");
        MarcJsonSchema.registerDatafield("787", "0", "6", "7", "a", "b", "d", "g", "h", "i", "n", "o", "r", "s", "t", "w");
        MarcJsonSchema.registerDatafield("800", "2", "4", "6", "a", "b", "c", "d", "e", "f", "g", "k", "l", "p", "q", "s", "t", "v", "w");
        MarcJsonSchema.registerDatafield("810", "4", "6", "a", "b", "c", "d", "f", "g", "k", "l", "p", "q", "r", "s", "t", "v", "w", "x");
        MarcJsonSchema.registerDatafield("811", "6", "a", "b", "c", "d", "e", "f", "g", "k", "l", "n", "p", "q", "t", "v", "w");
        MarcJsonSchema.registerDatafield("830", "3", "6", "a", "d", "f", "g", "h", "k", "l", "m", "o", "p", "q", "s", "t", "x", "v", "w");
        MarcJsonSchema.registerDatafield("840", "a", "v");
        MarcJsonSchema.registerDatafield("850", "a");
        MarcJsonSchema.registerDatafield("852", "2", "3", "a", "b", "c", "e", "h", "i", "j", "k", "m", "n", "p", "t", "u", "x", "w", "z");
        MarcJsonSchema.registerDatafield("856", "2", "3", "a", "b", "c", "d", "f", "h", "i", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "u", "x", "y", "v", "w", "z");
        MarcJsonSchema.registerDatafield("865", "a");
        MarcJsonSchema.registerDatafield("866", "a");
        MarcJsonSchema.registerDatafield("880", "0", "1", "2", "3", "5", "6", "8", "a", "b", "c", "d", "f", "g", "i", "k", "l", "o", "q", "r", "s", "t", "T", "U", "x", "y", "v", "z");
        MarcJsonSchema.registerDatafield("886", "2", "a", "b", "c", "d", "e", "f", "h", "k", "x", "z");
        MarcJsonSchema.registerDatafield("887", "2", "a");
        MarcJsonSchema.registerDatafield("889", "w");
        MarcJsonSchema.registerDatafield("911", "a", "b", "9");
        MarcJsonSchema.registerDatafield("912", "a", "b", "9");
        MarcJsonSchema.registerDatafield("924", "9", "a", "b", "c", "d", "e", "g", "h", "i", "j", "k", "l", "m", "n", "q", "r", "s", "v", "w", "x", "y", "z");
        MarcJsonSchema.registerDatafield("935", "a", "b", "c", "d", "e", "m");
        MarcJsonSchema.registerDatafield("936", "0", "a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "m", "q", "y");
        MarcJsonSchema.registerDatafield("937", "a", "b", "c", "d", "e", "f");
        MarcJsonSchema.registerDatafield("938", "a", "b", "n");
        MarcJsonSchema.registerDatafield("987", "a", "b", "c", "d", "e", "f");
        MarcJsonSchema.registerDatafield("994", "a", "b");
        extractableFields.put("leader", "$.leader");
        extractableFields.put("recordId", "$.controlfield[?(@.tag == '001')].content");
        extractableFields.put("001", PATHS.get("001").getPath());
        extractableFields.put("007", "$.controlfield[?(@.tag == '007')].content");
        extractableFields.put("008", "$.controlfield[?(@.tag == '008')].content");
        extractableFields.put("020$a", MarcJsonSchema.createDatafieldPath("020", "a"));
        extractableFields.put("028$a", MarcJsonSchema.createDatafieldPath("028", "a"));
        extractableFields.put("035$a", MarcJsonSchema.createDatafieldPath("035", "a"));
        extractableFields.put("100$a", MarcJsonSchema.createDatafieldPath("100", "a"));
        extractableFields.put("110$a", MarcJsonSchema.createDatafieldPath("110", "a"));
        extractableFields.put("245$a", MarcJsonSchema.createDatafieldPath("245", "a"));
        extractableFields.put("245$n", MarcJsonSchema.createDatafieldPath("245", "n"));
        extractableFields.put("245$p", MarcJsonSchema.createDatafieldPath("245", "p"));
        extractableFields.put("254$a", MarcJsonSchema.createDatafieldPath("254", "a"));
        extractableFields.put("260$a", MarcJsonSchema.createDatafieldPath("260", "a"));
        extractableFields.put("260$b", MarcJsonSchema.createDatafieldPath("260", "b"));
        extractableFields.put("260$c", MarcJsonSchema.createDatafieldPath("260", "c"));
        extractableFields.put("300$a", MarcJsonSchema.createDatafieldPath("300", "a"));
        extractableFields.put("490$v", MarcJsonSchema.createDatafieldPath("490", "v"));
        extractableFields.put("700$a", MarcJsonSchema.createDatafieldPath("700", "a"));
        extractableFields.put("710$a", MarcJsonSchema.createDatafieldPath("710", "a"));
        extractableFields.put("773$g", MarcJsonSchema.createDatafieldPath("773", "g"));
        extractableFields.put("773$v", MarcJsonSchema.createDatafieldPath("773", "v"));
        extractableFields.put("029$a", MarcJsonSchema.createDatafieldPath("029", "a"));
        extractableFields.put("029$b", MarcJsonSchema.createDatafieldPath("029", "b"));
        extractableFields.put("040$a", MarcJsonSchema.createDatafieldPath("040", "a"));
        extractableFields.put("040$b", MarcJsonSchema.createDatafieldPath("040", "b"));
        extractableFields.put("040$c", MarcJsonSchema.createDatafieldPath("040", "c"));
        extractableFields.put("040$d", MarcJsonSchema.createDatafieldPath("040", "d"));
        extractableFields.put("650$a", MarcJsonSchema.createDatafieldPath("650", "a"));
        extractableFields.put("650$2", MarcJsonSchema.createDatafieldPath("650", "2"));
        extractableFields.put("911$9", MarcJsonSchema.createDatafieldPath("911", "9"));
        extractableFields.put("912$9", MarcJsonSchema.createDatafieldPath("911", "9"));
    }
}

