/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.UniquenessExtractor;
import java.util.List;

public class UniquenessChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = -1432138574479246596L;
    public static final String PREFIX = "uniqueness";
    protected String solrField;
    private SolrClient solrClient;

    public UniquenessChecker(DataElement field) {
        this(field, field.getLabel());
    }

    public UniquenessChecker(DataElement field, String header) {
        super(field, header + ":uniqueness");
        this.solrField = field.getLabel().equals("recordId") ? "id" : field.getIndexField() + "_ss";
    }

    @Override
    public void update(Selector cache, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                String solrResponse;
                int numFound;
                if (!instance.hasValue()) continue;
                isNA = false;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                if ((numFound = UniquenessExtractor.extractNumFound(solrResponse = this.solrClient.getSolrSearchResponse(this.solrField, instance.getValue())).intValue()) <= 1) continue;
                allPassed = false;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }
}

