/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;
import java.util.regex.Pattern;

public class PatternChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = -1432138574479246596L;
    public static final String PREFIX = "pattern";
    protected Pattern pattern;

    public PatternChecker(DataElement field, String pattern) {
        this(field, field.getLabel(), pattern);
    }

    public PatternChecker(DataElement field, String header, String pattern) {
        super(field, header + ":pattern");
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public void update(Selector cache, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                if (this.pattern.matcher(instance.getValue()).find()) continue;
                allPassed = false;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

