/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;
import java.util.StringTokenizer;

public class MaxWordsChecker
extends SingleFieldChecker {
    private static final long serialVersionUID = 3259638493041988749L;
    public static final String PREFIX = "maxWords";
    protected Integer maxWords;

    public MaxWordsChecker(DataElement field, int maxWords) {
        this(field, field.getLabel(), maxWords);
    }

    public MaxWordsChecker(DataElement field, String header, int maxWords) {
        super(field, header + ":maxWords");
        this.maxWords = maxWords;
    }

    @Override
    public void update(Selector cache, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                if (this.isDebug()) {
                    LOGGER.info("value: " + instance.getValue());
                }
                if (this.countWords(instance.getValue()) <= this.maxWords) continue;
                allPassed = false;
                break;
            }
        }
        this.addOutput(results, isNA, allPassed, outputType);
    }

    private int countWords(String value) {
        return new StringTokenizer(value).countTokens();
    }
}

