/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.singlefieldchecker;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.SingleFieldChecker;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DependencyChecker
extends SingleFieldChecker {
    private static final Logger LOGGER = Logger.getLogger(DependencyChecker.class.getCanonicalName());
    public static final String PREFIX = "dependency";
    protected List<String> dependencies;

    public DependencyChecker(DataElement field, List<String> dependencies) {
        this(field, field.getLabel(), dependencies);
    }

    public DependencyChecker(DataElement field, String header, List<String> dependencies) {
        super(field, header + ":dependency");
        this.dependencies = dependencies;
    }

    @Override
    public void update(Selector cache, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        this.update(cache, results, outputType, null);
    }

    public void update(Selector cache, FieldCounter<RuleCheckerOutput> localResults, RuleCheckingOutputType outputType, FieldCounter<RuleCheckerOutput> globalResults) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        if (globalResults == null) {
            globalResults = localResults;
        }
        boolean allPassed = true;
        boolean isNA = true;
        List instances = cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            block0: for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                isNA = false;
                for (String ruleId : this.dependencies) {
                    Object keyEnd = outputType.equals((Object)RuleCheckingOutputType.BOTH) ? ruleId + ":status" : ruleId;
                    boolean found = false;
                    for (Map.Entry<String, RuleCheckerOutput> entry : globalResults.getMap().entrySet()) {
                        if (!entry.getKey().endsWith((String)keyEnd)) continue;
                        found = true;
                        if (!entry.getValue().getStatus().equals((Object)RuleCheckingOutputStatus.FAILED)) continue;
                        allPassed = false;
                        break;
                    }
                    if (found) continue;
                    allPassed = false;
                    continue block0;
                }
            }
        }
        this.addOutput(localResults, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

