/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule.logical;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.rule.logical.LogicalChecker;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.DependencyChecker;
import java.util.List;
import java.util.logging.Logger;

public class OrChecker
extends LogicalChecker {
    private static final Logger LOGGER = Logger.getLogger(OrChecker.class.getCanonicalName());
    private static final long serialVersionUID = 1114999259831619599L;
    public static final String PREFIX = "or";

    public OrChecker(DataElement field, List<RuleChecker> checkers) {
        this(field, field.getLabel(), checkers);
    }

    public OrChecker(DataElement field, String header, List<RuleChecker> checkers) {
        super(field, header + ":or:" + OrChecker.getChildrenHeader(checkers));
        this.checkers = checkers;
    }

    @Override
    public void update(Selector cache, FieldCounter<RuleCheckerOutput> results, RuleCheckingOutputType outputType) {
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id);
        }
        boolean allPassed = false;
        boolean isNA = false;
        List instances = cache.get(this.field.getPath());
        if (instances != null && !instances.isEmpty()) {
            FieldCounter<RuleCheckerOutput> localResults = new FieldCounter<RuleCheckerOutput>();
            for (RuleChecker checker : this.checkers) {
                String key;
                if (checker instanceof DependencyChecker) {
                    ((DependencyChecker)checker).update(cache, localResults, outputType, results);
                } else {
                    checker.update(cache, localResults, outputType);
                }
                if (!localResults.get(key = outputType.equals((Object)RuleCheckingOutputType.BOTH) ? checker.getHeader(RuleCheckingOutputType.SCORE) : checker.getHeader()).getStatus().equals((Object)RuleCheckingOutputStatus.PASSED)) continue;
                allPassed = true;
                break;
            }
        } else {
            isNA = true;
        }
        this.addOutput(results, isNA, allPassed, outputType);
        if (this.isDebug()) {
            LOGGER.info(this.getClass().getSimpleName() + " " + this.id + ") result: " + RuleCheckingOutputStatus.create(isNA, allPassed));
        }
    }
}

