/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule;

import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputStatus;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;

public class RuleCheckerOutput {
    private final RuleCheckingOutputStatus status;
    private RuleCheckingOutputType outputType;
    private Integer score = 0;
    private Integer instanceCount;
    private Integer failureCount;

    public RuleCheckerOutput(RuleChecker ruleChecker, boolean isNA, boolean passed) {
        this(ruleChecker, RuleCheckingOutputStatus.create(isNA, passed));
    }

    public RuleCheckerOutput(RuleChecker ruleChecker, RuleCheckingOutputStatus status) {
        this.status = status;
        if (status.equals((Object)RuleCheckingOutputStatus.FAILED)) {
            this.score = ruleChecker.getFailureScore();
        } else if (status.equals((Object)RuleCheckingOutputStatus.PASSED)) {
            this.score = ruleChecker.getSuccessScore();
        } else if (status.equals((Object)RuleCheckingOutputStatus.NA)) {
            this.score = ruleChecker.getNaScore();
        }
    }

    public RuleCheckerOutput(RuleCheckingOutputStatus status, Integer score) {
        this.status = status;
        this.score = score;
    }

    public RuleCheckingOutputStatus getStatus() {
        return this.status;
    }

    public Integer getScore() {
        return this.score;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public RuleCheckerOutput setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public RuleCheckerOutput setFailureCount(Integer failureCount) {
        this.failureCount = failureCount;
        return this;
    }

    public String toString() {
        return this.outputType != null && this.outputType.equals((Object)RuleCheckingOutputType.STATUS) ? this.status.asString() : (this.score == null ? "0" : this.score.toString());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new RuleCheckerOutput(this.status, this.score).setInstanceCount(this.instanceCount).setFailureCount(this.failureCount);
    }

    public RuleCheckerOutput setOutputType(RuleCheckingOutputType outputType) {
        this.outputType = outputType;
        return this;
    }
}

