/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.rule;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.RuleCheckerOutput;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import java.util.logging.Logger;

public abstract class BaseRuleChecker
implements RuleChecker {
    protected static final Logger LOGGER = Logger.getLogger(BaseRuleChecker.class.getCanonicalName());
    protected String id;
    protected Integer failureScore;
    protected Integer successScore;
    protected Integer naScore;
    protected String header;
    protected Boolean hidden = false;
    private Boolean debug = false;
    private Boolean countInstances = false;

    @Override
    public String getId() {
        return this.id == null ? String.valueOf(0) : this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Integer getFailureScore() {
        return this.failureScore;
    }

    @Override
    public void setFailureScore(Integer failureScore) {
        this.failureScore = failureScore;
    }

    @Override
    public RuleChecker withFailureScore(Integer failureScore) {
        this.failureScore = failureScore;
        return this;
    }

    @Override
    public Integer getSuccessScore() {
        return this.successScore;
    }

    @Override
    public void setSuccessScore(Integer successScore) {
        this.successScore = successScore;
    }

    @Override
    public RuleChecker withSuccessScore(Integer successScore) {
        this.successScore = successScore;
        return this;
    }

    @Override
    public void setNaScore(Integer naScore) {
        this.naScore = naScore;
    }

    @Override
    public Integer getNaScore() {
        return this.naScore;
    }

    @Override
    public RuleChecker withNaScore(Integer naScore) {
        this.naScore = naScore;
        return this;
    }

    @Override
    public String getHeaderWithoutId() {
        return this.header;
    }

    @Override
    public String getHeader() {
        return this.header + ":" + this.getId();
    }

    @Override
    public String getHeader(RuleCheckingOutputType outputType) {
        String suffix = "";
        if (outputType.equals((Object)RuleCheckingOutputType.STATUS)) {
            suffix = ":status";
        } else if (outputType.equals((Object)RuleCheckingOutputType.SCORE)) {
            suffix = ":score";
        }
        return this.header + ":" + this.getId() + suffix;
    }

    protected void addOutput(FieldCounter<RuleCheckerOutput> results, boolean isNA, boolean allPassed, RuleCheckingOutputType outputType) {
        this.addOutput(results, isNA, allPassed, outputType, null, null);
    }

    protected void addOutput(FieldCounter<RuleCheckerOutput> results, boolean isNA, boolean allPassed, RuleCheckingOutputType outputType, Integer instanceCount, Integer failureCount) {
        RuleCheckerOutput output = new RuleCheckerOutput(this, isNA, allPassed);
        if (instanceCount != null) {
            output.setInstanceCount(instanceCount);
        }
        if (failureCount != null) {
            output.setFailureCount(failureCount);
        }
        if (outputType.equals((Object)RuleCheckingOutputType.STATUS) || outputType.equals((Object)RuleCheckingOutputType.SCORE)) {
            results.put(this.getHeader(), output.setOutputType(outputType));
        } else {
            try {
                RuleCheckerOutput output2 = (RuleCheckerOutput)output.clone();
                results.put(this.getHeader(RuleCheckingOutputType.STATUS), output.setOutputType(RuleCheckingOutputType.STATUS));
                results.put(this.getHeader(RuleCheckingOutputType.SCORE), output2.setOutputType(RuleCheckingOutputType.SCORE));
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void setHidden() {
        this.hidden = true;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setDebug() {
        this.debug = true;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Boolean countInstances() {
        return this.countInstances;
    }

    public void setCountInstances(Boolean countInstances) {
        this.countInstances = countInstances;
    }
}

