/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.problemcatalog;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.interfaces.Observable;
import de.gwdg.metadataqa.api.interfaces.Observer;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.BaseProblemCatalog;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.ProblemCatalogSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ProblemCatalog
extends BaseProblemCatalog<Double>
implements Serializable,
Observable {
    private static final long serialVersionUID = -8099737126539035900L;
    private static final String CALCULATOR_NAME = "problemCatalog";
    private final List<Observer> problems = new ArrayList<Observer>();
    private Selector cache;
    private ProblemCatalogSchema schema;

    public ProblemCatalog(ProblemCatalogSchema schema) {
        this.schema = schema;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public void addObserver(Observer observer) {
        this.problems.add(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        if (this.problems.contains(observer)) {
            this.problems.remove(observer);
        }
    }

    @Override
    public void notifyObservers(FieldCounter<Double> fieldCounter) {
        for (Observer observer : this.problems) {
            observer.update(this.cache, fieldCounter);
        }
    }

    @Override
    public List<MetricResult> measure(Selector cache) {
        this.cache = cache;
        FieldCounter<Double> fieldCounter = new FieldCounter<Double>();
        this.notifyObservers(fieldCounter);
        return List.of(new FieldCounterBasedResult<Double>(this.getCalculatorName(), fieldCounter));
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (Observer observer : this.problems) {
            headers.add(observer.getHeader());
        }
        return headers;
    }

    public ProblemCatalogSchema getSchema() {
        return this.schema;
    }
}

