/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.model.selector;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.PathNotFoundException;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.BaseSelector;
import de.gwdg.metadataqa.api.util.ExceptionUtils;
import de.gwdg.metadataqa.api.xml.XPathWrapper;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class XmlSelector<T extends XmlFieldInstance>
extends BaseSelector<T> {
    private static final Logger LOGGER = Logger.getLogger(XmlSelector.class.getCanonicalName());
    private static final long serialVersionUID = 3351744750302199667L;
    XPathWrapper xPathWrapper;

    public XmlSelector(String content) throws InvalidJsonException {
        this.content = content;
        this.xPathWrapper = new XPathWrapper(content);
    }

    public XmlSelector(String content, Map<String, String> namespaces) throws InvalidJsonException {
        this.content = content;
        this.xPathWrapper = new XPathWrapper(content, namespaces);
    }

    @Override
    protected void set(String address, String path, Object jsonFragment, Class clazz) {
        Object instances = this.read(path, jsonFragment);
        this.cache.put(address, instances);
    }

    @Override
    public List<T> read(String path, Object jsonFragment) {
        List<EdmFieldInstance> value = null;
        try {
            value = jsonFragment != null ? this.xPathWrapper.extractFieldInstanceList(jsonFragment, path) : this.xPathWrapper.extractFieldInstanceList(path);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (InvalidPathException e) {
            LOGGER.log(Level.SEVERE, "Invalid Path: {0} {1}\n{2}", new Object[]{path, e.getLocalizedMessage(), ExceptionUtils.extractRelevantPath((Exception)((Object)e))});
        }
        return value;
    }

    @Override
    public Object getFragment(String path) {
        List<Node> jsonFragment = null;
        if (!this.fragmentCache.containsKey(path)) {
            jsonFragment = this.xPathWrapper.extractNodes(path);
            this.fragmentCache.put(path, jsonFragment);
        } else {
            jsonFragment = this.fragmentCache.get(path);
        }
        return jsonFragment;
    }
}

