/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.model.selector;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import de.gwdg.metadataqa.api.json.JsonUtils;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.BaseSelector;
import de.gwdg.metadataqa.api.util.ExceptionUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;

public class JsonSelector<T extends XmlFieldInstance>
extends BaseSelector<T> {
    private static final Logger LOGGER = Logger.getLogger(JsonSelector.class.getCanonicalName());
    private static final long serialVersionUID = -7087854432160794878L;
    private final Object document;
    private static final JsonProvider JSON_PROVIDER = Configuration.defaultConfiguration().jsonProvider();

    public JsonSelector(String content) throws InvalidJsonException {
        this.content = content;
        this.document = JSON_PROVIDER.parse(content);
    }

    public JsonSelector(Object jsonDocument) {
        this.document = jsonDocument;
    }

    @Override
    protected void set(String address, String path, Object jsonFragment, Class clazz) {
        List<? extends XmlFieldInstance> instances = null;
        Object value = this.read(path, jsonFragment);
        if (value != null) {
            if (clazz == null) {
                instances = JsonUtils.extractFieldInstanceList(value, this.recordId, path);
            } else if (value instanceof JSONArray) {
                this.typedCache.put(address, clazz.cast(((JSONArray)value).get(0)));
            } else {
                this.typedCache.put(address, value);
            }
        }
        this.cache.put(address, instances);
    }

    @Override
    public Object read(String path, Object jsonFragment) {
        Object value = null;
        try {
            value = jsonFragment != null ? JsonPath.read((Object)jsonFragment, (String)path, (Predicate[])new Predicate[0]) : JsonPath.read((Object)this.document, (String)path, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (InvalidPathException e) {
            LOGGER.log(Level.SEVERE, "Invalid Path: {0} {1}\n{2}", new Object[]{path, e.getLocalizedMessage(), ExceptionUtils.extractRelevantPath((Exception)((Object)e))});
        }
        return value;
    }

    @Override
    public Object getFragment(String path) {
        Object jsonFragment = null;
        if (!this.fragmentCache.containsKey(path)) {
            jsonFragment = this.read(path, null);
            this.fragmentCache.put(path, jsonFragment);
        } else {
            jsonFragment = this.fragmentCache.get(path);
        }
        return jsonFragment;
    }
}

