/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.gwdg.metadataqa.api.configuration.schema.Rule;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataElement
implements Cloneable,
Serializable {
    private String label;
    private String path;
    private List<String> categories = new ArrayList<String>();
    private String solrFieldName;
    private DataElement parent = null;
    private DataElement identifier = null;
    private List<DataElement> children = new ArrayList<DataElement>();
    private boolean collection = false;
    private boolean isActive = true;
    private boolean isExtractable = false;
    private boolean isMandatory = false;
    private List<Rule> rules;
    private Schema schema;
    private String indexField;

    public DataElement(String label, String path, String solrFieldName) {
        this.label = label;
        this.path = path;
        this.solrFieldName = solrFieldName;
    }

    public DataElement(String path) {
        this.label = path;
        this.path = path;
    }

    public DataElement(String label, String path) {
        this.label = label;
        this.path = path;
    }

    public DataElement(String label, DataElement parent, String path) {
        this.label = label;
        this.path = path;
        this.setParent(parent);
    }

    public String getLabel() {
        return this.label;
    }

    public DataElement setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public DataElement setPath(String path) {
        this.path = path;
        return this;
    }

    public String getAbsolutePath() {
        Format format = this.hasFormat() ? this.schema.getFormat() : Format.JSON;
        return this.getAbsolutePath(format);
    }

    public boolean hasFormat() {
        return this.schema != null && this.schema.getFormat() != null;
    }

    public String getAbsolutePath(Format format) {
        if (this.getParent() != null) {
            if (format.equals((Object)Format.JSON)) {
                return this.getParent().getPath() + this.getPath().replace("$.", "[*]");
            }
            if (format.equals((Object)Format.XML)) {
                return this.getParent().getPath() + "/" + this.getPath();
            }
        }
        return this.getPath();
    }

    public String getAbsolutePath(int i) {
        if (this.getParent() != null) {
            String parentPath = this.getParent().getPath();
            String currentPath = i == -1 || parentPath.endsWith("[0]") ? this.getPath().replace("$.", "") : this.getPath().replace("$.", "[" + i + "]");
            return parentPath + currentPath;
        }
        return this.getPath();
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public DataElement setCategories(Category ... categories) {
        ArrayList<String> categories2 = new ArrayList<String>();
        for (Category category : categories) {
            categories2.add(category.toString());
        }
        return this.setCategories(categories2);
    }

    public DataElement setCategories(String ... categories) {
        return this.setCategories(Arrays.asList(categories));
    }

    public DataElement setCategories(List<String> categories) {
        this.categories = categories;
        if (categories.contains(Category.MANDATORY.toString())) {
            this.isMandatory = true;
        }
        return this;
    }

    public String getSolrFieldName() {
        return this.solrFieldName;
    }

    public DataElement setSolrFieldName(String solrFieldName) {
        this.solrFieldName = solrFieldName;
        return this;
    }

    public DataElement getParent() {
        return this.parent;
    }

    public DataElement setParent(DataElement parent) {
        this.parent = parent;
        this.parent.addChild(this);
        return this;
    }

    public DataElement addChild(DataElement child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        return this;
    }

    public List<DataElement> getChildren() {
        return this.children;
    }

    public DataElement setChildren(List<DataElement> children) {
        this.children = children;
        return this;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public DataElement setCollection(boolean collection) {
        this.collection = collection;
        return this;
    }

    public DataElement getIdentifier() {
        return this.identifier;
    }

    public DataElement setIdentifier(DataElement identifier) {
        this.identifier = identifier;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public DataElement setActive(boolean active) {
        this.isActive = active;
        return this;
    }

    public boolean isExtractable() {
        return this.isExtractable;
    }

    public DataElement setExtractable() {
        this.isExtractable = true;
        return this;
    }

    public DataElement setExtractable(boolean extractable) {
        this.isExtractable = extractable;
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public DataElement addRule(Rule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>();
        }
        this.rules.add(rule);
        if (rule.getMinCount() != null && rule.getMinCount() >= 1) {
            this.isMandatory = true;
        }
        return this;
    }

    public DataElement setRule(List<Rule> rules) {
        this.rules = rules;
        for (Rule rule : rules) {
            if (rule.getMinCount() == null || rule.getMinCount() < 1) continue;
            this.isMandatory = true;
        }
        return this;
    }

    public DataElement setRules(List<Rule> rules) {
        this.rules = rules;
        return this;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public String toString() {
        return "DataElement{label=" + this.label + ", path=" + this.path + ", categories=" + this.categories + ", solrFieldName=" + this.solrFieldName + ", parent=" + (this.parent == null ? "null" : this.parent.getLabel()) + ", identifier=" + (this.identifier == null ? "null" : this.identifier.getLabel()) + ", nr_of_children=" + this.children.size() + ", collection=" + this.collection + "}";
    }

    public static DataElement copy(DataElement other) throws CloneNotSupportedException {
        DataElement cloned = (DataElement)SerializationUtils.clone((Serializable)other);
        if (other.children != null && !other.children.isEmpty()) {
            ArrayList<DataElement> clonedChildren = new ArrayList<DataElement>();
            for (DataElement child : other.children) {
                DataElement clonedChild = (DataElement)SerializationUtils.clone((Serializable)child);
                clonedChild.parent = cloned;
                clonedChildren.add(clonedChild);
            }
            cloned.children = clonedChildren;
        }
        return cloned;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @JsonIgnore
    public Schema getSchema() {
        return this.schema;
    }

    public String getIndexField() {
        return this.indexField;
    }

    public DataElement setIndexField(String indexField) {
        this.indexField = indexField;
        return this;
    }

    public String generateIndexField() {
        return this.label.replaceAll("\\W", "_");
    }
}

