/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.counter;

import de.gwdg.metadataqa.api.counter.BasicCounter;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.Category;
import de.gwdg.metadataqa.api.schema.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CompletenessCounter
implements Serializable {
    public static final String TOTAL = "TOTAL";
    private static final long serialVersionUID = -3954161093449269927L;
    private Map<String, BasicCounter> basicCounters;
    private Schema schema;

    public CompletenessCounter(Schema schema) {
        this.schema = schema;
        this.initialize();
    }

    public BasicCounter get(String key) {
        return this.basicCounters.get(key);
    }

    public FieldCounter<Double> getFieldCounter() {
        FieldCounter<Double> fieldCounter = new FieldCounter<Double>();
        for (Map.Entry<String, BasicCounter> counter : this.basicCounters.entrySet()) {
            counter.getValue().calculate();
            fieldCounter.put(counter.getKey(), counter.getValue().getResult());
        }
        return fieldCounter;
    }

    public void calculateResults() {
        for (BasicCounter counter : this.basicCounters.values()) {
            counter.calculate();
        }
    }

    public void increaseInstance(List<String> categories) {
        this.basicCounters.get(TOTAL).increaseInstance();
        for (String category : categories) {
            this.basicCounters.get(category).increaseInstance();
        }
    }

    public void increaseInstance(String category, boolean increase) {
        this.basicCounters.get(category).increaseTotal();
        if (increase) {
            this.basicCounters.get(category).increaseInstance();
        }
    }

    public void increaseTotal(List<String> categories) {
        this.basicCounters.get(TOTAL).increaseTotal();
        for (String category : categories) {
            if (category == null) continue;
            this.basicCounters.get(category).increaseTotal();
        }
    }

    private void initialize() {
        this.basicCounters = new LinkedHashMap<String, BasicCounter>();
        for (String name : CompletenessCounter.getHeaders(this.schema)) {
            this.basicCounters.put(name, new BasicCounter());
        }
    }

    public static List<String> getHeaders(Schema schema) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(TOTAL);
        for (String category : schema.getCategories()) {
            headers.add(category);
        }
        for (FieldGroup group : schema.getFieldGroups()) {
            if (headers.contains(group.getCategory())) continue;
            headers.add(group.getCategory());
        }
        return headers;
    }

    public BasicCounter getStatComponent(Category category) {
        return this.basicCounters.get(category.name());
    }
}

