/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.api.rule.RuleCheckingOutputType;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.SolrConfiguration;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MeasurementConfiguration
implements Serializable {
    private static final long serialVersionUID = 7754969792852694442L;
    private boolean fieldExtractorEnabled = false;
    protected boolean fieldExistenceMeasurementEnabled = true;
    protected boolean fieldCardinalityMeasurementEnabled = true;
    protected boolean completenessMeasurementEnabled = true;
    protected boolean tfIdfMeasurementEnabled = false;
    protected boolean problemCatalogMeasurementEnabled = false;
    protected boolean ruleCatalogMeasurementEnabled = false;
    protected boolean languageMeasurementEnabled = false;
    protected boolean multilingualSaturationMeasurementEnabled = false;
    protected boolean collectTfIdfTerms = false;
    protected boolean uniquenessMeasurementEnabled = false;
    protected boolean indexingEnabled = false;
    protected boolean completenessCollectFields = false;
    protected boolean saturationExtendedResult = false;
    protected boolean checkSkippableCollections = false;
    protected boolean onlyIdInHeader = false;
    protected String solrHost;
    protected String solrPort;
    protected String solrPath;
    protected SolrClient solrClient;
    private RuleCheckingOutputType ruleCheckingOutputType = RuleCheckingOutputType.SCORE;
    private Map<String, Object> annottaionColumns;

    public MeasurementConfiguration() {
    }

    public MeasurementConfiguration(boolean runFieldExistence, boolean runFieldCardinality, boolean runCompleteness, boolean runTfIdf, boolean runProblemCatalog) {
        this.fieldExistenceMeasurementEnabled = runFieldExistence;
        this.fieldCardinalityMeasurementEnabled = runFieldCardinality;
        this.completenessMeasurementEnabled = runCompleteness;
        this.tfIdfMeasurementEnabled = runTfIdf;
        this.problemCatalogMeasurementEnabled = runProblemCatalog;
    }

    public MeasurementConfiguration enableFieldExtractor() {
        return this.enableFieldExtractor(true);
    }

    public MeasurementConfiguration disableFieldExtractor() {
        return this.enableFieldExtractor(false);
    }

    public MeasurementConfiguration enableFieldExtractor(boolean flag) {
        this.fieldExtractorEnabled = flag;
        return this;
    }

    public void setFieldExtractorEnabled(boolean fieldExtractorEnabled) {
        this.fieldExtractorEnabled = fieldExtractorEnabled;
    }

    public boolean isFieldExtractorEnabled() {
        return this.fieldExtractorEnabled;
    }

    public boolean isFieldExistenceMeasurementEnabled() {
        return this.fieldExistenceMeasurementEnabled;
    }

    public MeasurementConfiguration enableFieldExistenceMeasurement() {
        return this.enableFieldExistenceMeasurement(true);
    }

    public MeasurementConfiguration disableFieldExistenceMeasurement() {
        return this.enableFieldExistenceMeasurement(false);
    }

    public void setFieldExistenceMeasurementEnabled(boolean fieldExistenceMeasurementEnabled) {
        this.fieldExistenceMeasurementEnabled = fieldExistenceMeasurementEnabled;
    }

    public MeasurementConfiguration enableFieldExistenceMeasurement(boolean runFieldExistence) {
        this.fieldExistenceMeasurementEnabled = runFieldExistence;
        return this;
    }

    public boolean isFieldCardinalityMeasurementEnabled() {
        return this.fieldCardinalityMeasurementEnabled;
    }

    public void setFieldCardinalityMeasurementEnabled(boolean fieldCardinalityMeasurementEnabled) {
        this.fieldCardinalityMeasurementEnabled = fieldCardinalityMeasurementEnabled;
    }

    public MeasurementConfiguration enableFieldCardinalityMeasurement() {
        return this.enableFieldCardinalityMeasurement(true);
    }

    public MeasurementConfiguration disableFieldCardinalityMeasurement() {
        return this.enableFieldCardinalityMeasurement(false);
    }

    public MeasurementConfiguration enableFieldCardinalityMeasurement(boolean runFieldCardinality) {
        this.fieldCardinalityMeasurementEnabled = runFieldCardinality;
        return this;
    }

    public boolean isCompletenessMeasurementEnabled() {
        return this.completenessMeasurementEnabled;
    }

    public void setCompletenessMeasurementEnabled(boolean completenessMeasurementEnabled) {
        this.completenessMeasurementEnabled = completenessMeasurementEnabled;
    }

    public MeasurementConfiguration enableCompletenessMeasurement() {
        return this.enableCompletenessMeasurement(true);
    }

    public MeasurementConfiguration disableCompletenessMeasurement() {
        return this.enableCompletenessMeasurement(false);
    }

    public MeasurementConfiguration enableCompletenessMeasurement(boolean runCompleteness) {
        this.completenessMeasurementEnabled = runCompleteness;
        return this;
    }

    public boolean isLanguageMeasurementEnabled() {
        return this.languageMeasurementEnabled;
    }

    public void setLanguageMeasurementEnabled(boolean languageMeasurementEnabled) {
        this.languageMeasurementEnabled = languageMeasurementEnabled;
    }

    public MeasurementConfiguration enableLanguageMeasurement() {
        return this.enableLanguageMeasurement(true);
    }

    public MeasurementConfiguration disableLanguageMeasurement() {
        return this.enableLanguageMeasurement(false);
    }

    public MeasurementConfiguration enableLanguageMeasurement(boolean runLanguage) {
        this.languageMeasurementEnabled = runLanguage;
        return this;
    }

    public boolean isMultilingualSaturationMeasurementEnabled() {
        return this.multilingualSaturationMeasurementEnabled;
    }

    public void setMultilingualSaturationMeasurementEnabled(boolean multilingualSaturationMeasurementEnabled) {
        this.multilingualSaturationMeasurementEnabled = multilingualSaturationMeasurementEnabled;
    }

    public MeasurementConfiguration enableMultilingualSaturationMeasurement() {
        return this.enableMultilingualSaturationMeasurement(true);
    }

    public MeasurementConfiguration disableMultilingualSaturationMeasurement() {
        return this.enableMultilingualSaturationMeasurement(false);
    }

    public MeasurementConfiguration enableMultilingualSaturationMeasurement(boolean runMultilingualSaturation) {
        this.multilingualSaturationMeasurementEnabled = runMultilingualSaturation;
        return this;
    }

    public boolean isTfIdfMeasurementEnabled() {
        return this.tfIdfMeasurementEnabled;
    }

    public void setTfIdfMeasurementEnabled(boolean tfIdfMeasurementEnabled) {
        this.tfIdfMeasurementEnabled = tfIdfMeasurementEnabled;
    }

    public MeasurementConfiguration enableTfIdfMeasurement() {
        return this.enableTfIdfMeasurement(true);
    }

    public MeasurementConfiguration disableTfIdfMeasurement() {
        return this.enableTfIdfMeasurement(false);
    }

    public MeasurementConfiguration enableTfIdfMeasurement(boolean runTfIdf) {
        this.tfIdfMeasurementEnabled = runTfIdf;
        return this;
    }

    public boolean isProblemCatalogMeasurementEnabled() {
        return this.problemCatalogMeasurementEnabled;
    }

    public void setProblemCatalogMeasurementEnabled(boolean problemCatalogMeasurementEnabled) {
        this.problemCatalogMeasurementEnabled = problemCatalogMeasurementEnabled;
    }

    public MeasurementConfiguration enableProblemCatalogMeasurement() {
        return this.enableProblemCatalogMeasurement(true);
    }

    public MeasurementConfiguration disableProblemCatalogMeasurement() {
        return this.enableProblemCatalogMeasurement(false);
    }

    public MeasurementConfiguration enableProblemCatalogMeasurement(boolean runProblemCatalog) {
        this.problemCatalogMeasurementEnabled = runProblemCatalog;
        return this;
    }

    public boolean isRuleCatalogMeasurementEnabled() {
        return this.ruleCatalogMeasurementEnabled;
    }

    public void setRuleCatalogMeasurementEnabled(boolean ruleCatalogMeasurementEnabled) {
        this.ruleCatalogMeasurementEnabled = ruleCatalogMeasurementEnabled;
    }

    public MeasurementConfiguration enableRuleCatalogMeasurement() {
        return this.enableRuleCatalogMeasurement(true);
    }

    public MeasurementConfiguration disableRuleCatalogMeasurement() {
        return this.enableRuleCatalogMeasurement(false);
    }

    public MeasurementConfiguration enableRuleCatalogMeasurement(boolean run) {
        this.ruleCatalogMeasurementEnabled = run;
        return this;
    }

    public boolean isUniquenessMeasurementEnabled() {
        return this.uniquenessMeasurementEnabled;
    }

    public void setUniquenessMeasurementEnabled(boolean uniquenessMeasurementEnabled) {
        this.uniquenessMeasurementEnabled = uniquenessMeasurementEnabled;
    }

    public MeasurementConfiguration enableUniquenessMeasurement() {
        return this.enableUniquenessMeasurement(true);
    }

    public MeasurementConfiguration disableUniquenessMeasurement() {
        return this.enableUniquenessMeasurement(false);
    }

    public MeasurementConfiguration enableUniquenessMeasurement(boolean uniquenessMeasurementEnabled) {
        this.uniquenessMeasurementEnabled = uniquenessMeasurementEnabled;
        return this;
    }

    public boolean isIndexingEnabled() {
        return this.indexingEnabled;
    }

    public void setIndexingEnabled(boolean indexingEnabled) {
        this.indexingEnabled = indexingEnabled;
    }

    public MeasurementConfiguration enableIndexing() {
        return this.enableIndexing(true);
    }

    public MeasurementConfiguration disableIndexing() {
        return this.enableIndexing(false);
    }

    public MeasurementConfiguration enableIndexing(boolean indexingEnabled) {
        this.indexingEnabled = indexingEnabled;
        return this;
    }

    public boolean collectTfIdfTerms() {
        return this.collectTfIdfTerms;
    }

    public void setCollectTfIdfTerms(boolean collectTfIdfTerms) {
        this.collectTfIdfTerms = collectTfIdfTerms;
    }

    public MeasurementConfiguration collectTfIdfTerms(boolean collectTfIdfTerms) {
        this.collectTfIdfTerms = collectTfIdfTerms;
        return this;
    }

    public boolean isCompletenessFieldCollectingEnabled() {
        return this.completenessCollectFields;
    }

    public void setCompletenessCollectFields(boolean completenessCollectFields) {
        this.completenessCollectFields = completenessCollectFields;
    }

    public MeasurementConfiguration enableCompletenessFieldCollecting(boolean completenessCollectFields) {
        this.completenessCollectFields = completenessCollectFields;
        return this;
    }

    public boolean isSaturationExtendedResult() {
        return this.saturationExtendedResult;
    }

    public void setSaturationExtendedResult(boolean saturationExtendedResult) {
        this.saturationExtendedResult = saturationExtendedResult;
    }

    public MeasurementConfiguration enableSaturationExtendedResult(boolean saturationExtendedResult) {
        this.saturationExtendedResult = saturationExtendedResult;
        return this;
    }

    public boolean isCheckSkippableCollections() {
        return this.checkSkippableCollections;
    }

    public void setCheckSkippableCollections(boolean checkSkippableCollections) {
        this.checkSkippableCollections = checkSkippableCollections;
    }

    public MeasurementConfiguration enableCheckSkippableCollections(boolean checkSkippableCollections) {
        this.checkSkippableCollections = checkSkippableCollections;
        return this;
    }

    public String getSolrHost() {
        return this.solrHost;
    }

    public void setSolrHost(String solrHost) {
        this.solrHost = solrHost;
    }

    public MeasurementConfiguration withSolrHost(String solrHost) {
        this.solrHost = solrHost;
        return this;
    }

    public String getSolrPort() {
        return this.solrPort;
    }

    public void setSolrPort(String solrPort) {
        this.solrPort = solrPort;
    }

    public MeasurementConfiguration withSolrPort(String solrPort) {
        this.solrPort = solrPort;
        return this;
    }

    public boolean isOnlyIdInHeader() {
        return this.onlyIdInHeader;
    }

    public void setOnlyIdInHeader(boolean onlyIdInHeader) {
        this.onlyIdInHeader = onlyIdInHeader;
    }

    public MeasurementConfiguration withOnlyIdInHeader(boolean onlyIdInHeader) {
        this.onlyIdInHeader = onlyIdInHeader;
        return this;
    }

    public RuleCheckingOutputType getRuleCheckingOutputType() {
        return this.ruleCheckingOutputType;
    }

    public void setRuleCheckingOutputType(RuleCheckingOutputType ruleCheckingOutputType) {
        this.ruleCheckingOutputType = ruleCheckingOutputType;
    }

    public MeasurementConfiguration withRuleCheckingOutputType(RuleCheckingOutputType ruleCheckingOutputType) {
        this.ruleCheckingOutputType = ruleCheckingOutputType;
        return this;
    }

    public String getSolrPath() {
        return this.solrPath;
    }

    public void setSolrPath(String solrPath) {
        this.solrPath = solrPath;
    }

    public MeasurementConfiguration withSolrPath(String solrPath) {
        this.solrPath = solrPath;
        return this;
    }

    public SolrConfiguration getSolrConfiguration() {
        if (StringUtils.isNotBlank((CharSequence)this.solrHost) && StringUtils.isNotBlank((CharSequence)this.solrPort) && StringUtils.isNotBlank((CharSequence)this.solrPath)) {
            return new SolrConfiguration(this.solrHost, this.solrPort, this.solrPath);
        }
        return null;
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public MeasurementConfiguration withSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
        return this;
    }

    public MeasurementConfiguration withSolrConfiguration(String solrHost, String solrPort, String solrPath) {
        this.solrHost = solrHost;
        this.solrPort = solrPort;
        this.solrPath = solrPath;
        return this;
    }

    public void setAnnotationColumns(Map<String, Object> annotationColumns) {
        this.annottaionColumns = annotationColumns;
    }

    public MeasurementConfiguration withAnnotationColumns(Map<String, Object> annotationColumns) {
        this.annottaionColumns = annotationColumns;
        return this;
    }

    public void setAnnotationColumns(String jsonString) {
        this.withAnnotationColumns(jsonString);
    }

    public MeasurementConfiguration withAnnotationColumns(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        this.annottaionColumns = new LinkedHashMap<String, Object>();
        try {
            Map map = (Map)mapper.readValue(jsonString, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String || value instanceof Integer || value instanceof Double) {
                    this.annottaionColumns.put((String)entry.getKey(), value);
                    continue;
                }
                System.err.println(String.format("The %s key has a value, which is a %s: %s", entry.getKey(), value.getClass(), value));
            }
            System.err.println(map.keySet());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Map<String, Object> getAnnottaionColumns() {
        return this.annottaionColumns;
    }
}

