/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.api.configuration.MeasurementConfiguration;
import de.gwdg.metadataqa.api.configuration.SchemaConfiguration;
import de.gwdg.metadataqa.api.configuration.schema.Rule;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.schema.BaseSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigurationReader {
    private ConfigurationReader() {
    }

    public static SchemaConfiguration readSchemaJson(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readJson(fileName, SchemaConfiguration.class);
    }

    public static MeasurementConfiguration readMeasurementJson(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readJson(fileName, MeasurementConfiguration.class);
    }

    public static SchemaConfiguration readSchemaYaml(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readYaml(fileName, SchemaConfiguration.class);
    }

    public static MeasurementConfiguration readMeasurementYaml(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readYaml(fileName, MeasurementConfiguration.class);
    }

    private static <T> T readJson(String fileName, Class<T> clazz) throws FileNotFoundException {
        Object config;
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(fileName);
        try {
            config = objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return (T)config;
    }

    private static <T> T readYaml(String fileName, Class<T> clazz) throws FileNotFoundException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz, new LoaderOptions()));
        FileInputStream inputStream = new FileInputStream(new File(fileName));
        return (T)yaml.load((InputStream)inputStream);
    }

    public static <T> String toJson(T object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String toYaml(T object) {
        DumperOptions options = new DumperOptions();
        Representer representer = new Representer(options);
        representer.addClassTag(DataElement.class, Tag.MAP);
        representer.addClassTag(BaseSchema.class, Tag.MAP);
        representer.addClassTag(Rule.class, Tag.MAP);
        Yaml yaml = new Yaml(representer, new DumperOptions());
        return yaml.dumpAs(object, Tag.MAP, DumperOptions.FlowStyle.AUTO);
    }
}

