/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.cli;

import com.opencsv.exceptions.CsvValidationException;
import de.gwdg.metadataqa.api.calculator.CalculatorFacade;
import de.gwdg.metadataqa.api.io.reader.CSVRecordReader;
import de.gwdg.metadataqa.api.io.reader.JSONRecordReader;
import de.gwdg.metadataqa.api.io.reader.RecordReader;
import de.gwdg.metadataqa.api.io.reader.XMLRecordReader;
import de.gwdg.metadataqa.api.io.writer.CSVJSONResultWriter;
import de.gwdg.metadataqa.api.io.writer.CSVResultWriter;
import de.gwdg.metadataqa.api.io.writer.JSONResultWriter;
import de.gwdg.metadataqa.api.io.writer.ResultWriter;
import de.gwdg.metadataqa.api.schema.Schema;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;

public class RecordFactory {
    private RecordFactory() {
    }

    public static RecordReader getRecordReader(String inputFile, CalculatorFacade calculator, boolean gzip) throws CsvValidationException, IOException {
        Schema schema = calculator.getSchema();
        BufferedReader inputReader = null;
        if (gzip) {
            FileInputStream fis = new FileInputStream(inputFile);
            GZIPInputStream gis = new GZIPInputStream(fis);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
            inputReader = new BufferedReader(inputStreamReader);
        } else {
            Path inputPath = Paths.get(inputFile, new String[0]);
            inputReader = Files.newBufferedReader(inputPath);
        }
        switch (schema.getFormat()) {
            case JSON: {
                return new JSONRecordReader(inputReader, calculator);
            }
            case XML: {
                return new XMLRecordReader(inputReader, calculator);
            }
        }
        return new CSVRecordReader(inputReader, calculator);
    }

    public static ResultWriter getResultWriter(String outputFormat, String outputFile) throws IOException {
        if (outputFormat == null) {
            outputFormat = FilenameUtils.getExtension((String)outputFile);
        }
        switch (outputFormat) {
            case "json": 
            case "ndjson": {
                return new JSONResultWriter(outputFile);
            }
            case "csvjson": {
                return new CSVJSONResultWriter(outputFile);
            }
        }
        return new CSVResultWriter(outputFile);
    }

    public static ResultWriter getResultWriter(String outputFormat) {
        switch (outputFormat) {
            case "ndjson": {
                return new JSONResultWriter();
            }
            case "csvjson": {
                return new CSVJSONResultWriter();
            }
        }
        return new CSVResultWriter();
    }
}

