/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator.solr;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.UniquenessExtractor;
import de.gwdg.metadataqa.api.uniqueness.UniquenessField;
import de.gwdg.metadataqa.api.uniqueness.UniquenessFieldCalculator;
import java.util.ArrayList;
import java.util.List;

public class QaSolrClient {
    public static final String SUFFIX = "_ss";
    protected List<UniquenessField> solrFields;
    protected final SolrClient solrClient;
    protected UniquenessExtractor extractor = new UniquenessExtractor();
    protected final Schema schema;

    public QaSolrClient() {
        this(null, null);
    }

    public QaSolrClient(SolrClient solrClient, Schema schema) {
        this.solrClient = solrClient;
        this.schema = schema;
        this.initialize(schema);
    }

    private void initialize(Schema schema) {
        this.solrFields = new ArrayList<UniquenessField>();
        for (DataElement dataElement : schema.getIndexFields()) {
            UniquenessField field = new UniquenessField(dataElement.getLabel());
            field.setPath(dataElement.getAbsolutePath().replace("[*]", ""));
            if (schema.getRecordId() != null && dataElement.equals(schema.getRecordId())) continue;
            String solrField = QaSolrClient.getSolrField(dataElement);
            field.setSolrField(solrField);
            String solrResponse = this.solrClient.getSolrSearchResponse(solrField, "*");
            Integer numFound = UniquenessExtractor.extractNumFound(solrResponse);
            field.setTotal(numFound);
            field.setScoreForUniqueValue(UniquenessFieldCalculator.calculateScore(numFound.intValue(), 1.0));
            this.solrFields.add(field);
        }
    }

    public static String getSolrField(DataElement dataElement) {
        Object solrField;
        Object object = solrField = dataElement.getIndexField() != null ? dataElement.getIndexField() : dataElement.generateIndexField();
        if (((String)solrField).endsWith("_txt")) {
            solrField = ((String)solrField).replaceAll("_txt$", SUFFIX);
        } else if (!((String)solrField).endsWith(SUFFIX)) {
            solrField = (String)solrField + SUFFIX;
        }
        return solrField;
    }
}

