/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator.output;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.gwdg.metadataqa.api.calculator.output.OutputCollector;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.json.JsonUtils;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MetricCollector
implements OutputCollector {
    Map<String, List<MetricResult>> results = new LinkedHashMap<String, List<MetricResult>>();

    @Override
    public void addResult(Calculator calculator, List<MetricResult> metricResults, CompressionLevel compressionLevel) {
        this.results.put(calculator.getCalculatorName(), metricResults);
    }

    @Override
    public Object getResults() {
        return this.results;
    }

    public Object createOutput(OutputCollector.TYPE type, CompressionLevel compressionLevel) {
        Object output = null;
        switch (type) {
            case METRIC: {
                output = this.results;
                break;
            }
            case STRING: {
                output = this.getString(compressionLevel);
                break;
            }
            case STRING_LIST: {
                output = this.getStringList(compressionLevel);
                break;
            }
            case OBJECT_LIST: {
                output = this.getObjectList(compressionLevel);
                break;
            }
            case MAP: {
                output = this.getMap(compressionLevel);
                break;
            }
            case JSON: {
                output = this.getJson(compressionLevel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }
        return output;
    }

    private Object getString(CompressionLevel compressionLevel) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<MetricResult>> entry : this.results.entrySet()) {
            if (entry.getValue() == null) continue;
            for (MetricResult metricResult : entry.getValue()) {
                result.add(metricResult.getCsv(false, compressionLevel));
            }
        }
        return StringUtils.join(result, (String)",");
    }

    private Object getStringList(CompressionLevel compressionLevel) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<MetricResult>> entry : this.results.entrySet()) {
            for (MetricResult metricResult : entry.getValue()) {
                result.addAll(metricResult.getList(false, compressionLevel));
            }
        }
        return result;
    }

    private Object getObjectList(CompressionLevel compressionLevel) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, List<MetricResult>> entry : this.results.entrySet()) {
            for (MetricResult metricResult : entry.getValue()) {
                result.addAll(metricResult.getCsv());
            }
        }
        return result;
    }

    private Object getMap(CompressionLevel compressionLevel) {
        LinkedHashMap<CallSite, Object> result = new LinkedHashMap<CallSite, Object>();
        for (Map.Entry<String, List<MetricResult>> entry : this.results.entrySet()) {
            for (MetricResult metricResult : entry.getValue()) {
                for (Map.Entry<String, ? extends Object> entry2 : metricResult.getResultMap().entrySet()) {
                    result.put((CallSite)((Object)(metricResult.getName() + ":" + entry2.getKey())), entry2.getValue());
                }
            }
        }
        return result;
    }

    private Object getJson(CompressionLevel compressionLevel) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, List<MetricResult>> entry : this.results.entrySet()) {
            LinkedHashMap<String, Map<String, ? extends Object>> calcResult = new LinkedHashMap<String, Map<String, ? extends Object>>();
            for (MetricResult metricResult : entry.getValue()) {
                calcResult.put(metricResult.getName(), metricResult.getResultMap());
            }
            result.put(entry.getKey(), calcResult);
        }
        try {
            return JsonUtils.toJson(result);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

