/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator.language;

import de.gwdg.metadataqa.api.counter.BasicCounter;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.Converter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Language {
    private final Selector cache;
    private final Schema schema;
    FieldCounter<String> languageMap;
    Map<String, SortedMap<String, Integer>> rawLanguageMap;

    public Language(Schema schema, Selector cache) {
        this.schema = schema;
        this.cache = cache;
    }

    public FieldCounter<String> measure() {
        this.languageMap = new FieldCounter();
        this.rawLanguageMap = new LinkedHashMap<String, SortedMap<String, Integer>>();
        if (this.schema.getCollectionPaths().isEmpty()) {
            for (DataElement dataElement : this.schema.getPaths()) {
                if (!dataElement.isActive() || this.schema.getNoLanguageFields().contains(dataElement.getLabel())) continue;
                this.extractLanguageTags(null, dataElement, dataElement.getPath());
            }
        } else {
            for (DataElement collection : this.schema.getCollectionPaths()) {
                Object rawJsonFragment = this.cache.getFragment(collection.getPath());
                if (rawJsonFragment == null) {
                    for (DataElement child : collection.getChildren()) {
                        if (!child.isActive() || this.schema.getNoLanguageFields().contains(child.getLabel())) continue;
                        TreeMap<String, BasicCounter> languages = new TreeMap<String, BasicCounter>();
                        this.increase(languages, "_1");
                        this.updateMaps(child.getLabel(), this.transformLanguages(languages));
                    }
                    continue;
                }
                List<Object> jsonFragments = Converter.jsonObjectToList(rawJsonFragment, this.schema);
                int len = jsonFragments.size();
                for (int i = 0; i < len; ++i) {
                    Object jsonFragment = jsonFragments.get(i);
                    for (DataElement child : collection.getChildren()) {
                        if (!child.isActive() || this.schema.getNoLanguageFields().contains(child.getLabel())) continue;
                        String address = String.format("%s/%d/%s", collection.getPath(), i, child.getPath());
                        this.extractLanguageTags(jsonFragment, child, address);
                    }
                }
            }
        }
        return this.languageMap;
    }

    private void extractLanguageTags(Object jsonFragment, DataElement dataElement, String address) {
        List values = this.cache.get(address, dataElement.getPath(), jsonFragment);
        TreeMap<String, BasicCounter> languages = new TreeMap<String, BasicCounter>();
        if (values != null && !values.isEmpty()) {
            for (EdmFieldInstance field : values) {
                if (field.hasValue()) {
                    if (field.hasLanguage()) {
                        this.increase(languages, field.getLanguage());
                        continue;
                    }
                    this.increase(languages, "_0");
                    continue;
                }
                this.increase(languages, "_2");
            }
        } else {
            this.increase(languages, "_1");
        }
        this.updateMaps(dataElement.getLabel(), this.transformLanguages(languages));
    }

    private void increase(Map<String, BasicCounter> languages, String key) {
        if (!languages.containsKey(key)) {
            languages.put(key, new BasicCounter(1.0));
        } else {
            languages.get(key).increaseTotal();
        }
    }

    private void updateMaps(String label, SortedMap<String, Integer> instance) {
        if (!this.rawLanguageMap.containsKey(label)) {
            this.rawLanguageMap.put(label, instance);
        } else {
            Map existing = this.rawLanguageMap.get(label);
            for (Map.Entry<String, Integer> entry : instance.entrySet()) {
                if (!existing.containsKey(entry.getKey())) {
                    existing.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getKey() == null || entry.getKey().equals("_1")) continue;
                existing.put(entry.getKey(), (Integer)existing.get(entry.getKey()) + entry.getValue());
            }
        }
        this.languageMap.put(label, this.extractLanguagesFromRaw((Map<String, Integer>)this.rawLanguageMap.get(label)));
    }

    protected String extractLanguagesFromRaw(Map<String, Integer> languages) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Integer> lang : languages.entrySet()) {
            if (result.length() > 0) {
                result.append(";");
            }
            result.append(lang.getKey() + ":" + lang.getValue());
        }
        return result.toString();
    }

    private SortedMap<String, Integer> transformLanguages(Map<String, BasicCounter> languages) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        for (Map.Entry<String, BasicCounter> lang : languages.entrySet()) {
            result.put(lang.getKey(), Double.valueOf(lang.getValue().getTotal()).intValue());
        }
        return result;
    }
}

