/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator.edm;

import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.JsonUtils;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class EnhancementIdExtractor
implements Serializable {
    private static final List<String> TECHNICAL_PROPERTIES = Arrays.asList("@about", "edm:europeanaProxy", "ore:proxyFor", "ore:proxyIn", "edm:type");
    private static final List<String> TECHNICAL_PROPERTIES_LABELS = Arrays.asList("Proxy/rdf:about", "Proxy/edm:europeanaProxy", "Proxy/ore:proxyFor", "Proxy/ore:proxyIn", "Proxy/edm:type");
    private static final long serialVersionUID = -7398960966530263051L;

    private EnhancementIdExtractor() {
    }

    public static List<String> extractIds(Selector cache, Schema schema) {
        ArrayList<String> enhancementIds = new ArrayList<String>();
        String path = schema.getPathByLabel("Proxy").getPath().replace("false", "true");
        Object rawJsonFragment = cache.getFragment(path);
        List<Object> jsonFragments = Converter.jsonObjectToList(rawJsonFragment, schema);
        if (schema.getFormat().equals((Object)Format.JSON)) {
            EnhancementIdExtractor.processJson(enhancementIds, jsonFragments);
        } else if (schema.getFormat().equals((Object)Format.XML)) {
            EnhancementIdExtractor.processXml(cache, schema, enhancementIds, jsonFragments);
        }
        return enhancementIds;
    }

    public static void processXml(Selector cache, Schema schema, List<String> enhancementIds, List<Object> jsonFragments) {
        DataElement parent = schema.getPathByLabel("Proxy");
        for (DataElement child : parent.getChildren()) {
            if (!EnhancementIdExtractor.isEnrichmentField(child.getLabel())) continue;
            String address = child.getAbsolutePath(schema.getFormat());
            Object context = jsonFragments.get(0);
            List fieldInstances = cache.get(address, child.getPath(), context);
            if (fieldInstances == null || fieldInstances.isEmpty()) continue;
            for (EdmFieldInstance fieldInstance : fieldInstances) {
                if (!fieldInstance.isUrl()) continue;
                enhancementIds.add(fieldInstance.getUrl());
            }
        }
    }

    public static void processJson(List<String> enhancementIds, List<Object> jsonFragments) {
        Map jsonFragment = (Map)jsonFragments.get(0);
        for (Map.Entry entry : jsonFragment.entrySet()) {
            List<? extends XmlFieldInstance> fieldInstances;
            if (!EnhancementIdExtractor.isEnrichmentField((String)entry.getKey()) || (fieldInstances = JsonUtils.extractFieldInstanceList(entry.getValue(), null, null)) == null) continue;
            for (EdmFieldInstance edmFieldInstance : fieldInstances) {
                if (!edmFieldInstance.isUrl()) continue;
                enhancementIds.add(edmFieldInstance.getUrl());
            }
        }
    }

    private static boolean isEnrichmentField(String fieldName) {
        return !TECHNICAL_PROPERTIES.contains(fieldName) && !TECHNICAL_PROPERTIES_LABELS.contains(fieldName);
    }
}

