/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.BaseLanguageCalculator;
import de.gwdg.metadataqa.api.calculator.SkippedEntryChecker;
import de.gwdg.metadataqa.api.calculator.language.Multilinguality;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.SkippedEntitySelector;
import java.util.ArrayList;
import java.util.List;

public class MultilingualitySaturationCalculator
extends BaseLanguageCalculator {
    public static final String CALCULATOR_NAME = "multilingualitySaturation";
    private ResultTypes resultType = ResultTypes.NORMAL;
    private Schema schema;
    private SkippedEntryChecker skippedEntryChecker = null;
    private SkippedEntitySelector skippedEntitySelector = new SkippedEntitySelector();

    public MultilingualitySaturationCalculator() {
    }

    public MultilingualitySaturationCalculator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        block3: for (DataElement dataElement : this.schema.getPaths()) {
            if (!dataElement.isActive() || this.schema.getNoLanguageFields().contains(dataElement.getLabel())) continue;
            switch (this.resultType) {
                case EXTENDED: {
                    headers.add("lang:sum:" + dataElement.getLabel());
                    headers.add("lang:average:" + dataElement.getLabel());
                    headers.add("lang:normalized:" + dataElement.getLabel());
                    continue block3;
                }
            }
            headers.add("lang:" + dataElement.getLabel());
        }
        if (this.resultType.equals((Object)ResultTypes.EXTENDED)) {
            headers.add("multilingualitySaturation:sum");
            headers.add("multilingualitySaturation:average");
        }
        headers.add("multilingualitySaturation:normalized");
        return headers;
    }

    @Override
    public List<MetricResult> measure(Selector cache) throws InvalidJsonException {
        Multilinguality multilinguality = new Multilinguality(this.schema, cache, this.resultType, this.skippedEntryChecker, this.skippedEntitySelector);
        FieldCounter<Double> saturationMap = multilinguality.measure();
        return List.of(new FieldCounterBasedResult<Double>(this.getCalculatorName(), saturationMap));
    }

    public ResultTypes getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultTypes resultType) {
        this.resultType = resultType;
    }

    public SkippedEntryChecker getSkippedEntryChecker() {
        return this.skippedEntryChecker;
    }

    public void setSkippedEntryChecker(SkippedEntryChecker skippedEntryChecker) {
        this.skippedEntryChecker = skippedEntryChecker;
        this.skippedEntitySelector.setSkippedEntryChecker(skippedEntryChecker);
    }

    public static enum ResultTypes {
        NORMAL(0),
        EXTENDED(1);

        private final int value;

        private ResultTypes(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

