/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import de.gwdg.metadataqa.api.calculator.AnnotationCalculator;
import de.gwdg.metadataqa.api.calculator.CompletenessCalculator;
import de.gwdg.metadataqa.api.calculator.FieldExtractor;
import de.gwdg.metadataqa.api.calculator.Indexer;
import de.gwdg.metadataqa.api.calculator.LanguageCalculator;
import de.gwdg.metadataqa.api.calculator.MultilingualitySaturationCalculator;
import de.gwdg.metadataqa.api.calculator.TfIdfCalculator;
import de.gwdg.metadataqa.api.calculator.UniquenessCalculator;
import de.gwdg.metadataqa.api.configuration.MeasurementConfiguration;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.problemcatalog.EmptyStrings;
import de.gwdg.metadataqa.api.problemcatalog.LongSubject;
import de.gwdg.metadataqa.api.problemcatalog.ProblemCatalog;
import de.gwdg.metadataqa.api.problemcatalog.TitleAndDescriptionAreSame;
import de.gwdg.metadataqa.api.rule.RuleCatalog;
import de.gwdg.metadataqa.api.rule.RuleChecker;
import de.gwdg.metadataqa.api.rule.logical.LogicalChecker;
import de.gwdg.metadataqa.api.rule.singlefieldchecker.UniquenessChecker;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.schema.edm.EdmSchema;
import de.gwdg.metadataqa.api.uniqueness.DefaultSolrClient;
import de.gwdg.metadataqa.api.uniqueness.SolrConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CalculatorFactory {
    private MeasurementConfiguration configuration;
    private Schema schema;
    private List<Calculator> calculators = new ArrayList<Calculator>();

    private CalculatorFactory(MeasurementConfiguration configuration, Schema schema) {
        this.configuration = configuration;
        this.schema = schema;
        this.configure();
    }

    public static List<Calculator> create(MeasurementConfiguration configuration, Schema schema) {
        CalculatorFactory factory = new CalculatorFactory(configuration, schema);
        return factory.getCalculators();
    }

    private void configure() {
        this.addExtractor();
        this.addAnnotator();
        this.addCompleteness();
        this.addTfIdfMeasurement();
        this.addProblemCatalogMeasurement();
        this.addRuleCatalogMeasurement();
        this.addLanguageMeasurement();
        this.addMultilingualSaturationMeasurement();
        this.addUniquenessMeasurement();
        this.addIndexer();
    }

    private void addExtractor() {
        if (this.configuration.isFieldExtractorEnabled() && !this.schema.getExtractableFields().isEmpty()) {
            this.calculators.add(new FieldExtractor(this.schema));
        }
    }

    private void addAnnotator() {
        if (this.configuration.getAnnottaionColumns() != null && !this.configuration.getAnnottaionColumns().isEmpty()) {
            this.calculators.add(new AnnotationCalculator(this.configuration.getAnnottaionColumns()));
        }
    }

    private void addCompleteness() {
        if (this.configuration.isCompletenessMeasurementEnabled()) {
            CompletenessCalculator completenessCalculator = new CompletenessCalculator(this.schema);
            completenessCalculator.collectFields(this.configuration.isCompletenessFieldCollectingEnabled());
            completenessCalculator.setExistence(this.configuration.isFieldExistenceMeasurementEnabled());
            completenessCalculator.setCardinality(this.configuration.isFieldCardinalityMeasurementEnabled());
            this.calculators.add(completenessCalculator);
        }
    }

    private void addTfIdfMeasurement() {
        if (this.configuration.isTfIdfMeasurementEnabled()) {
            TfIdfCalculator tfidfCalculator = new TfIdfCalculator(this.schema);
            if (!(StringUtils.isNotBlank((CharSequence)this.configuration.getSolrHost()) && StringUtils.isNotBlank((CharSequence)this.configuration.getSolrPort()) && StringUtils.isNotBlank((CharSequence)this.configuration.getSolrPath()))) {
                throw new IllegalArgumentException("If TF-IDF measurement is enabled, Solr configuration should not be null.");
            }
            tfidfCalculator.setSolrConfiguration(new SolrConfiguration(this.configuration.getSolrHost(), this.configuration.getSolrPort(), this.configuration.getSolrPath()));
            tfidfCalculator.enableTermCollection(this.configuration.collectTfIdfTerms());
            this.calculators.add(tfidfCalculator);
        }
    }

    private void addProblemCatalogMeasurement() {
        if (this.configuration.isProblemCatalogMeasurementEnabled() && this.schema instanceof EdmSchema) {
            ProblemCatalog problemCatalog = new ProblemCatalog((EdmSchema)this.schema);
            new LongSubject(problemCatalog);
            new TitleAndDescriptionAreSame(problemCatalog);
            new EmptyStrings(problemCatalog);
            this.calculators.add(problemCatalog);
        }
    }

    private void addRuleCatalogMeasurement() {
        if (this.configuration.isRuleCatalogMeasurementEnabled()) {
            RuleCatalog caclulator = new RuleCatalog(this.schema).setOnlyIdInHeader(this.configuration.isOnlyIdInHeader()).setOutputType(this.configuration.getRuleCheckingOutputType());
            this.injectSolr(this.schema.getRuleCheckers());
            this.calculators.add(caclulator);
        }
    }

    private void injectSolr(List<RuleChecker> ruleCheckers) {
        for (RuleChecker ruleChecker : ruleCheckers) {
            if (ruleChecker instanceof UniquenessChecker) {
                this.initializeSolrConfiguration();
                ((UniquenessChecker)ruleChecker).setSolrClient(this.configuration.getSolrClient());
                continue;
            }
            if (!(ruleChecker instanceof LogicalChecker)) continue;
            this.injectSolr(((LogicalChecker)ruleChecker).getCheckers());
        }
    }

    private void addLanguageMeasurement() {
        if (this.configuration.isLanguageMeasurementEnabled()) {
            this.calculators.add(new LanguageCalculator(this.schema));
        }
    }

    private void addMultilingualSaturationMeasurement() {
        if (this.configuration.isMultilingualSaturationMeasurementEnabled()) {
            MultilingualitySaturationCalculator multilingualSaturationCalculator = new MultilingualitySaturationCalculator(this.schema);
            if (this.configuration.isSaturationExtendedResult()) {
                multilingualSaturationCalculator.setResultType(MultilingualitySaturationCalculator.ResultTypes.EXTENDED);
            }
            this.calculators.add(multilingualSaturationCalculator);
        }
    }

    private void addUniquenessMeasurement() {
        if (this.configuration.isUniquenessMeasurementEnabled()) {
            this.initializeSolrConfiguration();
            this.calculators.add(new UniquenessCalculator(this.configuration.getSolrClient(), this.schema));
        }
    }

    private void initializeSolrConfiguration() {
        if (this.configuration.getSolrClient() == null && this.configuration.getSolrConfiguration() == null) {
            throw new IllegalArgumentException("If Uniqueness measurement is enabled, Solr configuration should not be null.");
        }
        if (this.configuration.getSolrClient() == null && this.configuration.getSolrConfiguration() != null) {
            this.configuration.setSolrClient(new DefaultSolrClient(this.configuration.getSolrConfiguration()));
        }
    }

    private void addIndexer() {
        if (this.configuration.isIndexingEnabled()) {
            if (this.configuration.getSolrClient() == null && this.configuration.getSolrConfiguration() == null) {
                throw new IllegalArgumentException("If indexer is enabled, Solr configuration should not be null.");
            }
            if (this.configuration.getSolrClient() == null && this.configuration.getSolrConfiguration() != null) {
                this.configuration.setSolrClient(new DefaultSolrClient(this.configuration.getSolrConfiguration()));
            }
            this.calculators.add(new Indexer(this.configuration.getSolrClient(), this.schema));
        }
    }

    public List<Calculator> getCalculators() {
        return this.calculators;
    }
}

