/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.Track;
import java.util.Iterator;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public class LoopedTrack
implements Track,
Iterator<Sound> {
    private final Sound track;

    public LoopedTrack(String soundName) {
        this((Sound)Resources.sounds().get(soundName));
    }

    public LoopedTrack(Sound sound) {
        this.track = Objects.requireNonNull(sound);
    }

    @Override
    public Iterator<Sound> iterator() {
        return this;
    }

    @Override
    public AudioFormat getFormat() {
        return this.track.getFormat();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Sound next() {
        return this.track;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object anObject) {
        if (this == anObject) return true;
        if (!(anObject instanceof LoopedTrack)) return false;
        LoopedTrack lt = (LoopedTrack)anObject;
        if (!lt.track.equals(this.track)) return false;
        return true;
    }

    public int hashCode() {
        return this.track.hashCode();
    }

    public String toString() {
        return "looped track: " + String.valueOf(this.track);
    }
}

