/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.resources.TextureAtlas;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class Images
extends ResourcesContainer<BufferedImage> {
    Images() {
    }

    public void load(TextureAtlas textureAtlas) {
        BufferedImage atlasImage = (BufferedImage)Resources.images().get(textureAtlas.getAbsoluteImagePath());
        if (atlasImage == null || atlasImage.getWidth() == 0 || atlasImage.getHeight() == 0) {
            return;
        }
        for (TextureAtlas.Sprite sprite : textureAtlas.getSprites()) {
            BufferedImage image = atlasImage.getSubimage(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
            if (sprite.isRotated()) {
                image = Imaging.rotate(image, Rotation.ROTATE_270);
            }
            Resources.images().add(sprite.getName(), image);
        }
    }

    @Override
    protected BufferedImage load(URL resourceName) throws IOException {
        BufferedImage img = ImageIO.read(resourceName);
        if (img == null) {
            return null;
        }
        return Imaging.toCompatibleImage(img);
    }
}

