/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.ImageComponentList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntConsumer;

public class Menu
extends ImageComponentList {
    private int currentSelection;
    private final String[] items;
    private final List<IntConsumer> selectionChangeConsumers;

    public Menu(double x, double y, double width, double height, String ... items) {
        this(x, y, width, height, (Spritesheet)null, items);
    }

    public Menu(double x, double y, double width, double height, Spritesheet background, String ... items) {
        super(x, y, width, height, items.length, 1, null, background);
        this.items = items;
        this.selectionChangeConsumers = new CopyOnWriteArrayList<IntConsumer>();
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public void onChange(IntConsumer cons) {
        this.selectionChangeConsumers.add(cons);
    }

    @Override
    public void prepare() {
        super.prepare();
        for (int i = 0; i < this.items.length; ++i) {
            ImageComponent menuButton = this.getCellComponents().get(i);
            menuButton.setText(this.items[i]);
            menuButton.onClicked(c -> this.setCurrentSelection(this.getCellComponents().indexOf(menuButton)));
        }
    }

    public void setCurrentSelection(int currentSelection) {
        this.currentSelection = currentSelection;
        for (int i = 0; i < this.getCellComponents().size(); ++i) {
            this.getCellComponents().get(this.currentSelection).setSelected(i == this.currentSelection);
        }
        this.selectionChangeConsumers.forEach(c -> c.accept(this.getCurrentSelection()));
    }
}

