/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.gui.Appearance;
import de.gurkenlabs.litiengine.gui.ComponentMouseEvent;
import de.gurkenlabs.litiengine.gui.ComponentMouseWheelEvent;
import de.gurkenlabs.litiengine.gui.ComponentRenderEvent;
import de.gurkenlabs.litiengine.gui.ComponentRenderListener;
import de.gurkenlabs.litiengine.gui.ComponentRenderedListener;
import de.gurkenlabs.litiengine.gui.GuiProperties;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.tweening.TweenType;
import de.gurkenlabs.litiengine.tweening.Tweenable;
import de.gurkenlabs.litiengine.util.ColorHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class GuiComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
IRenderable,
Tweenable {
    protected static final Font ICON_FONT;
    private static int id;
    private final List<Consumer<ComponentMouseEvent>> clickConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseDraggedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseEnterConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseLeaveConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseMovedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mousePressedConsumer;
    private final List<Consumer<ComponentMouseEvent>> mouseReleasedConsumer;
    private final List<Consumer<ComponentMouseWheelEvent>> mouseWheelConsumer;
    private final List<Consumer<ComponentMouseEvent>> hoverConsumer;
    private final List<Consumer<String>> textChangedConsumer;
    private final Collection<ComponentRenderListener> renderListeners = ConcurrentHashMap.newKeySet();
    private final Collection<ComponentRenderedListener> renderedListeners = ConcurrentHashMap.newKeySet();
    private final int componentId;
    private final Appearance appearance;
    private final Appearance hoveredAppearance;
    private final List<GuiComponent> components = new CopyOnWriteArrayList<GuiComponent>();
    private final Appearance disabledAppearance;
    private boolean enabled;
    private Font font;
    private boolean forwardMouseEvents = true;
    private double width;
    private double height;
    private Sound hoverSound;
    private boolean textAntialiasing;
    private boolean textShadow;
    private Color textShadowColor;
    private float textShadowRadius;
    private boolean isHovered;
    private boolean isPressed;
    private boolean isSelected;
    private String name;
    private boolean suspended;
    private Object tag;
    private String text;
    private Align textAlign;
    private Valign textValign;
    private boolean automaticLineBreaks;
    private int textAngle = 0;
    private double textX;
    private double textY;
    private boolean visible;
    private Point2D location;
    private Rectangle2D boundingBox;

    protected GuiComponent(double x, double y) {
        this(x, y, 0.0, 0.0);
    }

    protected GuiComponent(double x, double y, double width, double height) {
        this.clickConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.hoverConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mousePressedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseDraggedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseEnterConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseLeaveConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseReleasedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.mouseWheelConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseWheelEvent>>();
        this.mouseMovedConsumer = new CopyOnWriteArrayList<Consumer<ComponentMouseEvent>>();
        this.textChangedConsumer = new CopyOnWriteArrayList<Consumer<String>>();
        this.appearance = new Appearance();
        this.appearance.update(GuiProperties.getDefaultAppearance());
        this.appearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearance().update(this.getAppearance());
            }
        });
        this.hoveredAppearance = new Appearance();
        this.hoveredAppearance.update(GuiProperties.getDefaultAppearanceHovered());
        this.hoveredAppearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearanceHovered().update(this.getAppearanceHovered());
            }
        });
        this.disabledAppearance = new Appearance();
        this.disabledAppearance.update(GuiProperties.getDefaultAppearanceDisabled());
        this.disabledAppearance.onChange(app -> {
            for (GuiComponent child : this.getComponents()) {
                child.getAppearanceDisabled().update(this.getAppearanceDisabled());
            }
        });
        this.setTextAlign(GuiProperties.getDefaultTextAlign());
        this.setTextValign(GuiProperties.getDefaultTextValign());
        this.setTextAntialiasing(GuiProperties.getDefaultTextAntialiasing());
        this.setTextShadow(GuiProperties.getDefaultTextShadow());
        this.setTextShadowColor(GuiProperties.getDefaultTextShadowColor());
        this.setTextShadowRadius(GuiProperties.getDefaultTextShadowRadius());
        this.componentId = ++id;
        this.location = new Point2D.Double(x, y);
        this.setDimension(width, height);
        this.setFont(GuiProperties.getDefaultFont());
        this.setSelected(false);
        this.setEnabled(true);
        this.initializeComponents();
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public Appearance getAppearanceDisabled() {
        return this.disabledAppearance;
    }

    public Appearance getAppearanceHovered() {
        return this.hoveredAppearance;
    }

    public Rectangle2D getBoundingBox() {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        this.boundingBox = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return this.boundingBox;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public List<GuiComponent> getComponents() {
        return this.components;
    }

    public Font getFont() {
        return this.font;
    }

    public double getHeight() {
        return this.height;
    }

    public Sound getHoverSound() {
        return this.hoverSound;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public Object getTag() {
        return this.tag;
    }

    public String getText() {
        return this.text;
    }

    public Align getTextAlign() {
        return this.textAlign;
    }

    public Valign getTextValign() {
        return this.textValign;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public boolean hasTextAntialiasing() {
        return this.textAntialiasing;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public Color getTextShadowColor() {
        return this.textShadowColor;
    }

    public void setTextShadowColor(Color textShadowColor) {
        this.textShadowColor = textShadowColor;
    }

    public float getTextShadowRadius() {
        return this.textShadowRadius;
    }

    public void setTextShadowRadius(float textShadowRadius) {
        this.textShadowRadius = textShadowRadius;
    }

    public boolean hasAutomaticLineBreaks() {
        return this.automaticLineBreaks;
    }

    public String getTextToRender(Graphics2D g) {
        if (this.getText() == null) {
            return "";
        }
        if (this.hasAutomaticLineBreaks()) {
            return this.getText();
        }
        FontMetrics fm = g.getFontMetrics();
        String newText = this.getText();
        while (newText.length() > 1 && (double)fm.stringWidth(newText) >= this.getWidth()) {
            newText = newText.substring(1);
        }
        return newText;
    }

    public double getTextX() {
        return this.textX;
    }

    public double getTextY() {
        return this.textY;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.getLocation().getX();
    }

    public double getCenterX() {
        return this.getBoundingBox().getCenterX();
    }

    public double getCenterY() {
        return this.getBoundingBox().getCenterY();
    }

    public double getY() {
        return this.getLocation().getY();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isForwardMouseEvents() {
        return this.forwardMouseEvents;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        if (this.isPressed()) {
            ComponentMouseEvent event = new ComponentMouseEvent(e, this);
            this.getClickConsumer().forEach(consumer -> consumer.accept(event));
            this.isPressed = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseDraggedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isForwardMouseEvents()) {
            return;
        }
        if (!this.mouseEventShouldBeForwarded(e)) {
            this.isHovered = false;
            return;
        }
        this.isHovered = true;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getHoverConsumer().forEach(consumer -> consumer.accept(event));
        if (this.getHoverSound() != null) {
            Game.audio().playSound(this.getHoverSound());
        }
        this.getMouseEnterConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isForwardMouseEvents()) {
            return;
        }
        this.isHovered = false;
        this.isPressed = false;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseLeaveConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e) && this.isHovered()) {
            this.mouseExited(e);
            return;
        }
        if (!this.isHovered()) {
            this.mouseEntered(e);
        }
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMouseMovedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        this.isPressed = true;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getMousePressedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mouseEventShouldBeForwarded(e)) {
            return;
        }
        this.isPressed = false;
        ComponentMouseEvent event = new ComponentMouseEvent(e, this);
        this.getClickConsumer().forEach(consumer -> consumer.accept(event));
        this.getMouseReleasedConsumer().forEach(consumer -> consumer.accept(event));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.getMouseWheelConsumer().forEach(consumer -> consumer.accept(new ComponentMouseWheelEvent(e, this)));
    }

    public void onClicked(Consumer<ComponentMouseEvent> callback) {
        if (!this.getClickConsumer().contains(callback)) {
            this.getClickConsumer().add(callback);
        }
    }

    public void onHovered(Consumer<ComponentMouseEvent> callback) {
        if (!this.getHoverConsumer().contains(callback)) {
            this.getHoverConsumer().add(callback);
        }
    }

    public void onMouseDragged(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseDraggedConsumer().contains(callback)) {
            this.getMouseDraggedConsumer().add(callback);
        }
    }

    public void onMouseEnter(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseEnterConsumer().contains(callback)) {
            this.getMouseEnterConsumer().add(callback);
        }
    }

    public void onMouseLeave(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseLeaveConsumer().contains(callback)) {
            this.getMouseLeaveConsumer().add(callback);
        }
    }

    public void onMouseMoved(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseMovedConsumer().contains(callback)) {
            this.getMouseMovedConsumer().add(callback);
        }
    }

    public void onMousePressed(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMousePressedConsumer().contains(callback)) {
            this.getMousePressedConsumer().add(callback);
        }
    }

    public void onMouseReleased(Consumer<ComponentMouseEvent> callback) {
        if (!this.getMouseReleasedConsumer().contains(callback)) {
            this.getMouseReleasedConsumer().add(callback);
        }
    }

    public void onMouseWheelScrolled(Consumer<ComponentMouseWheelEvent> callback) {
        if (!this.getMouseWheelConsumer().contains(callback)) {
            this.getMouseWheelConsumer().add(callback);
        }
    }

    public void onTextChanged(Consumer<String> cons) {
        this.textChangedConsumer.add(cons);
    }

    public void addRenderListener(ComponentRenderListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeListener(ComponentRenderListener listener) {
        this.renderListeners.remove(listener);
    }

    public void addRenderedListener(ComponentRenderedListener listener) {
        this.renderedListeners.add(listener);
    }

    public void removeListener(ComponentRenderedListener listener) {
        this.renderedListeners.remove(listener);
    }

    public void prepare() {
        this.suspended = false;
        this.visible = true;
        Input.mouse().addMouseListener(this);
        Input.mouse().onWheelMoved(this);
        Input.mouse().addMouseMotionListener(this);
        for (GuiComponent component : this.getComponents()) {
            component.prepare();
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.isSuspended() || !this.isVisible()) {
            return;
        }
        for (ComponentRenderListener componentRenderListener : this.renderListeners) {
            if (componentRenderListener.canRender(this)) continue;
            return;
        }
        ComponentRenderEvent event = new ComponentRenderEvent(g, this);
        for (ComponentRenderListener listener : this.renderListeners) {
            listener.rendering(event);
        }
        Shape shape = g.getClip();
        g.clip(this.getShape());
        if (!this.getCurrentAppearance().isTransparentBackground()) {
            g.setPaint(this.getCurrentAppearance().getBackgroundPaint(this.getWidth(), this.getHeight()));
            ShapeRenderer.render(g, this.getBoundingBox());
        }
        g.setColor(this.getCurrentAppearance().getForeColor());
        g.setFont(this.getFont());
        this.renderText(g);
        g.setClip(shape);
        if (this.getCurrentAppearance().getBorderColor() != null && this.getCurrentAppearance().getBorderStyle() != null) {
            g.setColor(this.getCurrentAppearance().getBorderColor());
            ShapeRenderer.renderOutline(g, (Shape)this.getBoundingBox(), this.getCurrentAppearance().getBorderStyle());
        }
        for (GuiComponent guiComponent : this.getComponents()) {
            if (!guiComponent.isVisible() || guiComponent.isSuspended()) continue;
            guiComponent.render(g);
        }
        for (ComponentRenderListener componentRenderListener : this.renderListeners) {
            componentRenderListener.rendered(event);
        }
        for (ComponentRenderedListener componentRenderedListener : this.renderedListeners) {
            componentRenderedListener.rendered(event);
        }
        if (Game.config().debug().renderGuiComponentBoundingBoxes()) {
            g.setColor(Color.RED);
            ShapeRenderer.renderOutline(g, this.getBoundingBox());
        }
    }

    @Override
    public float[] getTweenValues(TweenType tweenType) {
        switch (tweenType) {
            case LOCATION_X: {
                return new float[]{(float)this.getX()};
            }
            case LOCATION_Y: {
                return new float[]{(float)this.getY()};
            }
            case LOCATION_XY: {
                return new float[]{(float)this.getX(), (float)this.getY()};
            }
            case SIZE_WIDTH: {
                return new float[]{(float)this.getWidth()};
            }
            case SIZE_HEIGHT: {
                return new float[]{(float)this.getHeight()};
            }
            case SIZE_BOTH: {
                return new float[]{(float)this.getWidth(), (float)this.getHeight()};
            }
            case ANGLE: {
                return new float[]{this.getTextAngle()};
            }
            case FONTSIZE: {
                return new float[]{this.getFont().getSize2D()};
            }
            case OPACITY: {
                Color bg1 = this.getCurrentAppearance().getBackgroundColor1();
                Color bg2 = this.getCurrentAppearance().getBackgroundColor2();
                Color fore = this.getCurrentAppearance().getForeColor();
                Color shadow = this.getTextShadowColor();
                Color border = this.getCurrentAppearance().getBorderColor();
                return new float[]{bg1 == null ? 0.0f : (float)bg1.getAlpha(), bg2 == null ? 0.0f : (float)bg2.getAlpha(), fore == null ? 0.0f : (float)fore.getAlpha(), shadow == null ? 0.0f : (float)shadow.getAlpha(), border == null ? 0.0f : (float)border.getAlpha()};
            }
        }
        return Tweenable.super.getTweenValues(tweenType);
    }

    @Override
    public void setTweenValues(TweenType tweenType, float[] newValues) {
        switch (tweenType) {
            case LOCATION_X: {
                this.setX(newValues[0]);
                break;
            }
            case LOCATION_Y: {
                this.setY(newValues[0]);
                break;
            }
            case LOCATION_XY: {
                this.setX(newValues[0]);
                this.setY(newValues[1]);
                break;
            }
            case SIZE_WIDTH: {
                this.setWidth(newValues[0]);
                break;
            }
            case SIZE_HEIGHT: {
                this.setHeight(newValues[0]);
                break;
            }
            case SIZE_BOTH: {
                this.setWidth(newValues[0]);
                this.setHeight(newValues[1]);
                break;
            }
            case ANGLE: {
                this.setTextAngle(Math.round(newValues[0]));
                break;
            }
            case FONTSIZE: {
                this.setFontSize(newValues[0]);
                break;
            }
            case OPACITY: {
                Color bg1 = this.getCurrentAppearance().getBackgroundColor1();
                Color bg2 = this.getCurrentAppearance().getBackgroundColor2();
                Color fore = this.getCurrentAppearance().getForeColor();
                Color border = this.getCurrentAppearance().getBorderColor();
                this.getCurrentAppearance().setBackgroundColor1(bg1 == null ? null : ColorHelper.getTransparentVariant(bg1, (int)newValues[0]));
                this.getCurrentAppearance().setBackgroundColor2(bg2 == null ? null : ColorHelper.getTransparentVariant(bg2, (int)newValues[1]));
                this.getCurrentAppearance().setForeColor(fore == null ? null : ColorHelper.getTransparentVariant(fore, (int)newValues[2]));
                this.setTextShadowColor(this.getTextShadowColor() == null ? null : ColorHelper.getTransparentVariant(this.getTextShadowColor(), (int)newValues[3]));
                this.getCurrentAppearance().setBorderColor(border == null ? null : ColorHelper.getTransparentVariant(border, (int)newValues[4]));
                break;
            }
            default: {
                Tweenable.super.setTweenValues(tweenType, newValues);
            }
        }
    }

    public RectangularShape getShape() {
        float radius = this.getCurrentAppearance().getBorderRadius();
        if (radius == 0.0f) {
            return this.getBoundingBox();
        }
        return new RoundRectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getCurrentAppearance().getBorderRadius(), this.getCurrentAppearance().getBorderRadius());
    }

    public void setDimension(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (GuiComponent comp : this.getComponents()) {
            comp.setEnabled(this.isEnabled());
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontSize(float size) {
        if (this.font == null) {
            return;
        }
        this.setFont(this.getFont().deriveFont(size));
    }

    public void setForwardMouseEvents(boolean forwardMouseEvents) {
        this.forwardMouseEvents = forwardMouseEvents;
    }

    public void setHeight(double height) {
        this.height = height;
        this.boundingBox = null;
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public void setHoverSound(Sound hoverSound) {
        this.hoverSound = hoverSound;
    }

    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    public void setLocation(Point2D location) {
        double deltaX = location.getX() - this.getX();
        double deltaY = location.getY() - this.getY();
        this.location = location;
        this.boundingBox = null;
        for (GuiComponent component : this.getComponents()) {
            component.setLocation(new Point2D.Double(component.getX() + deltaX, component.getY() + deltaY));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelected(boolean bool) {
        this.isSelected = bool;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void setText(String text) {
        this.text = text;
        for (Consumer<String> cons : this.textChangedConsumer) {
            cons.accept(this.getText());
        }
    }

    public void setTextAntialiasing(boolean antialiasing) {
        this.textAntialiasing = antialiasing;
    }

    public void setAutomaticLineBreaks(boolean automaticLineBreaks) {
        this.automaticLineBreaks = automaticLineBreaks;
    }

    public void setTextAlign(Align textAlign) {
        this.textAlign = textAlign;
    }

    public void setTextValign(Valign textValign) {
        this.textValign = textValign;
    }

    public void setTextAngle(int textAngle) {
        this.textAngle = textAngle;
    }

    public void setTextShadow(boolean drawTextShadow) {
        this.textShadow = drawTextShadow;
        for (GuiComponent comp : this.getComponents()) {
            comp.setTextShadow(drawTextShadow);
        }
    }

    public void setTextX(double x) {
        this.textX = x;
    }

    public void setTextY(double y) {
        this.textY = y;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        for (GuiComponent component : this.getComponents()) {
            component.setVisible(visible);
        }
    }

    public void setWidth(double width) {
        this.width = width;
        this.boundingBox = null;
    }

    public void setX(double x) {
        this.setLocation(x, this.getY());
    }

    public void setY(double y) {
        this.setLocation(this.getX(), y);
    }

    public void suspend() {
        Input.mouse().removeMouseListener(this);
        Input.mouse().removeMouseWheelListener(this);
        Input.mouse().removeMouseMotionListener(this);
        this.suspended = true;
        this.visible = false;
        for (GuiComponent childComp : this.getComponents()) {
            childComp.suspend();
        }
    }

    public void toggleSelection() {
        this.setSelected(!this.isSelected());
    }

    public void toggleSuspension() {
        if (!this.isSuspended()) {
            this.suspend();
        } else {
            this.prepare();
        }
    }

    public Appearance getCurrentAppearance() {
        if (!this.isEnabled()) {
            return this.getAppearanceDisabled();
        }
        return this.isHovered() ? this.getAppearanceHovered() : this.getAppearance();
    }

    protected List<Consumer<ComponentMouseEvent>> getClickConsumer() {
        return this.clickConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getHoverConsumer() {
        return this.hoverConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseDraggedConsumer() {
        return this.mouseDraggedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseEnterConsumer() {
        return this.mouseEnterConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseLeaveConsumer() {
        return this.mouseLeaveConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseMovedConsumer() {
        return this.mouseMovedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMousePressedConsumer() {
        return this.mousePressedConsumer;
    }

    protected List<Consumer<ComponentMouseEvent>> getMouseReleasedConsumer() {
        return this.mouseReleasedConsumer;
    }

    protected List<Consumer<ComponentMouseWheelEvent>> getMouseWheelConsumer() {
        return this.mouseWheelConsumer;
    }

    protected void initializeComponents() {
    }

    protected boolean mouseEventShouldBeForwarded(MouseEvent e) {
        return this.isForwardMouseEvents() && this.isVisible() && this.isEnabled() && !this.isSuspended() && e != null && this.getBoundingBox().contains(e.getPoint());
    }

    private void renderText(Graphics2D g) {
        double yCoord;
        if (this.getText() == null || this.getText().isEmpty()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        double textWidth = fm.stringWidth(this.getTextToRender(g));
        double textHeight = (double)fm.getAscent() + (double)fm.getDescent();
        double xCoord = this.getTextAlign() != null ? this.getX() + this.getTextAlign().getLocation(this.getWidth(), textWidth) : this.getTextX();
        double d = yCoord = this.getTextValign() != null ? this.getY() + this.getTextValign().getLocation(this.getHeight(), textHeight) : this.getTextY();
        if (this.getTextAngle() == 0) {
            if (this.hasTextShadow()) {
                TextRenderer.renderWithOutline(g, this.getTextToRender(g), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getTextShadowColor(), this.getTextShadowRadius(), this.getTextAlign(), this.getTextValign(), this.hasTextAntialiasing());
            } else {
                TextRenderer.renderWithLinebreaks(g, this.getTextToRender(g), this.getTextAlign(), this.getTextValign(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.hasTextAntialiasing());
            }
        } else if (this.getTextAngle() == 90) {
            TextRenderer.renderRotated(g, this.getTextToRender(g), xCoord, yCoord - (double)fm.stringWidth(this.getTextToRender(g)), this.getTextAngle(), this.hasTextAntialiasing());
        } else {
            TextRenderer.renderRotated(g, this.getTextToRender(g), xCoord, yCoord, this.getTextAngle(), this.hasTextAntialiasing());
        }
    }

    static {
        id = 0;
        Font icon = (Font)Resources.fonts().get("fontello.ttf");
        ICON_FONT = icon != null ? icon.deriveFont(16.0f) : null;
    }
}

