/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.xml;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.emitters.particles.ParticleType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.physics.Collision;
import de.gurkenlabs.litiengine.resources.Resource;
import de.gurkenlabs.litiengine.util.ColorHelper;
import de.gurkenlabs.litiengine.util.MathUtilities;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@XmlRootElement(name="emitter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EmitterData
implements Serializable,
Resource {
    public static final Color DEFAULT_COLOR = new Color(0, 165, 188, 204);
    public static final String DEFAULT_SPRITESHEET = "";
    public static final String DEFAULT_NAME = "Custom Emitter";
    public static final String DEFAULT_TEXT = "LITI";
    public static final boolean DEFAULT_ANIMATE_SPRITE = true;
    public static final boolean DEFAULT_LOOP_SPRITE = true;
    public static final boolean DEFAULT_FADE = true;
    public static final boolean DEFAULT_FADE_ON_COLLISION = false;
    public static final boolean DEFAULT_OUTLINE_ONLY = false;
    public static final boolean DEFAULT_ANTIALIASING = false;
    public static final Collision DEFAULT_COLLISION = Collision.NONE;
    public static final ParticleType DEFAULT_PARTICLE_TYPE = ParticleType.RECTANGLE;
    public static final Quality DEFAULT_REQUIRED_QUALITY = Quality.VERYLOW;
    public static final Align DEFAULT_ORIGIN_ALIGN = Align.CENTER;
    public static final Valign DEFAULT_ORIGIN_VALIGN = Valign.MIDDLE;
    public static final float DEFAULT_WIDTH = 16.0f;
    public static final float DEFAULT_HEIGHT = 16.0f;
    public static final float DEFAULT_COLOR_VARIANCE = 0.0f;
    public static final float DEFAULT_ALPHA_VARIANCE = 0.0f;
    public static final int DEFAULT_UPDATERATE = 40;
    public static final int DEFAULT_SPAWNAMOUNT = 20;
    public static final int DEFAULT_SPAWNRATE = 100;
    public static final int DEFAULT_MAXPARTICLES = 400;
    public static final int DEFAULT_DURATION = 0;
    public static final int DEFAULT_MIN_PARTICLE_TTL = 400;
    public static final int DEFAULT_MAX_PARTICLE_TTL = 1500;
    public static final float DEFAULT_MIN_OFFSET_X = -4.0f;
    public static final float DEFAULT_MAX_OFFSET_X = 4.0f;
    public static final float DEFAULT_MIN_OFFSET_Y = -4.0f;
    public static final float DEFAULT_MAX_OFFSET_Y = 4.0f;
    public static final float DEFAULT_MIN_DELTA_WIDTH = -0.1f;
    public static final float DEFAULT_MAX_DELTA_WIDTH = 0.1f;
    public static final float DEFAULT_MIN_DELTA_HEIGHT = -0.1f;
    public static final float DEFAULT_MAX_DELTA_HEIGHT = 0.1f;
    public static final float DEFAULT_MIN_ACCELERATION_X = -0.01f;
    public static final float DEFAULT_MAX_ACCELERATION_X = 0.01f;
    public static final float DEFAULT_MIN_ACCELERATION_Y = -0.01f;
    public static final float DEFAULT_MAX_ACCELERATION_Y = 0.01f;
    public static final float DEFAULT_MIN_ANGLE = 0.0f;
    public static final float DEFAULT_MAX_ROTATION = 360.0f;
    public static final float DEFAULT_MIN_DELTA_ANGLE = -1.0f;
    public static final float DEFAULT_MAX_DELTA_ANGLE = 1.0f;
    public static final float DEFAULT_MIN_VELOCITY_X = -0.1f;
    public static final float DEFAULT_MAX_VELOCITY_X = 0.1f;
    public static final float DEFAULT_MIN_VELOCITY_Y = -0.1f;
    public static final float DEFAULT_MAX_VELOCITY_Y = 0.1f;
    public static final float DEFAULT_MIN_WIDTH = 2.0f;
    public static final float DEFAULT_MAX_WIDTH = 6.0f;
    public static final float DEFAULT_MIN_HEIGHT = 2.0f;
    public static final float DEFAULT_MAX_HEIGHT = 6.0f;
    private static final long serialVersionUID = 50238884097993529L;
    @XmlElement
    private float alphaVariance;
    @XmlElement
    private boolean animateSprite;
    @XmlElement
    private boolean loopSprite;
    @XmlElement
    private Collision collision;
    @XmlElement
    private Quality requiredQuality = DEFAULT_REQUIRED_QUALITY;
    @XmlElement
    private float colorVariance;
    @XmlElementWrapper
    @XmlElement(name="color")
    private List<String> colors;
    @XmlTransient
    private List<Color> decodedColors;
    @XmlElement
    private ParticleParameter deltaHeight;
    @XmlElement
    private ParticleParameter deltaWidth;
    @XmlElement
    private ParticleParameter velocityX;
    @XmlElement
    private ParticleParameter velocityY;
    @XmlAttribute
    private int emitterDuration;
    @XmlElement
    private boolean fade;
    @XmlElement
    private boolean fadeOnCollision;
    @XmlElement
    private boolean outlineOnly;
    @XmlElement
    private boolean antiAliasing;
    @XmlElement
    private ParticleParameter accelerationX;
    @XmlElement
    private ParticleParameter accelerationY;
    @XmlElement
    private ParticleParameter angle;
    @XmlElement
    private ParticleParameter deltaAngle;
    @XmlAttribute
    private float height;
    @XmlAttribute
    private int maxParticles;
    @XmlAttribute
    private String name;
    @XmlElement
    private Align originAlign;
    @XmlElement
    private Valign originValign;
    @XmlElement
    private ParticleParameter particleHeight;
    @XmlElement
    private ParticleParameter particleTTL;
    @XmlElementWrapper
    @XmlElement(name="text")
    private List<String> texts;
    @XmlAttribute
    private ParticleType particleType;
    @XmlElement
    private ParticleParameter particleWidth;
    @XmlAttribute
    private int spawnAmount;
    @XmlAttribute
    private int spawnRate;
    @XmlElement
    private String spritesheet;
    @XmlAttribute
    private int updateRate;
    @XmlAttribute
    private float width;
    @XmlElement
    private ParticleParameter offsetX = new ParticleParameter();
    @XmlElement
    private ParticleParameter offsetY = new ParticleParameter();

    public EmitterData() {
        this.deltaWidth = new ParticleParameter();
        this.deltaHeight = new ParticleParameter();
        this.angle = new ParticleParameter();
        this.deltaAngle = new ParticleParameter();
        this.velocityX = new ParticleParameter();
        this.velocityY = new ParticleParameter();
        this.accelerationX = new ParticleParameter();
        this.accelerationY = new ParticleParameter();
        this.particleWidth = new ParticleParameter();
        this.particleHeight = new ParticleParameter();
        this.particleTTL = new ParticleParameter();
        this.collision = DEFAULT_COLLISION;
        this.particleType = DEFAULT_PARTICLE_TYPE;
        this.originValign = DEFAULT_ORIGIN_VALIGN;
        this.originAlign = DEFAULT_ORIGIN_ALIGN;
        this.setColor(DEFAULT_COLOR);
    }

    @XmlTransient
    public float getAlphaVariance() {
        return this.alphaVariance;
    }

    public void setAlphaVariance(float alphaVariance) {
        this.alphaVariance = MathUtilities.clamp(alphaVariance, 0.0f, 1.0f);
    }

    @XmlTransient
    public Collision getCollision() {
        return this.collision;
    }

    public void setCollision(Collision collision) {
        this.collision = collision;
    }

    @XmlTransient
    public Quality getRequiredQuality() {
        return this.requiredQuality;
    }

    public void setRequiredQuality(Quality minQuality) {
        this.requiredQuality = minQuality;
    }

    @XmlTransient
    public float getColorVariance() {
        return this.colorVariance;
    }

    public void setColorVariance(float colorVariance) {
        this.colorVariance = MathUtilities.clamp(colorVariance, 0.0f, 1.0f);
    }

    @XmlTransient
    public List<String> getColors() {
        return this.colors;
    }

    public List<Color> getDecodedColors() {
        if (this.decodedColors != null) {
            return this.decodedColors;
        }
        ArrayList<Color> newColors = new ArrayList<Color>();
        for (String color : this.getColors()) {
            Color decoded = ColorHelper.decode(color);
            newColors.add(decoded != null ? decoded : DEFAULT_COLOR);
        }
        this.decodedColors = newColors;
        return this.decodedColors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
        this.decodedColors = null;
    }

    public void setColors(Color ... colors) {
        this.colors = Arrays.stream(colors).map(ColorHelper::encode).toList();
    }

    @XmlTransient
    public ParticleParameter getDeltaHeight() {
        return this.deltaHeight;
    }

    public void setDeltaHeight(ParticleParameter deltaHeight) {
        this.deltaHeight = deltaHeight;
    }

    @XmlTransient
    public ParticleParameter getDeltaWidth() {
        return this.deltaWidth;
    }

    public void setDeltaWidth(ParticleParameter deltaWidth) {
        this.deltaWidth = deltaWidth;
    }

    @XmlTransient
    public ParticleParameter getAngle() {
        return this.angle;
    }

    public void setAngle(ParticleParameter angle) {
        this.angle = angle;
    }

    @XmlTransient
    public ParticleParameter getDeltaAngle() {
        return this.deltaAngle;
    }

    @XmlTransient
    public ParticleParameter getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityX(ParticleParameter velocityX) {
        this.velocityX = velocityX;
    }

    @XmlTransient
    public ParticleParameter getVelocityY() {
        return this.velocityY;
    }

    public void setVelocityY(ParticleParameter velocityY) {
        this.velocityY = velocityY;
    }

    @XmlTransient
    public int getEmitterDuration() {
        return this.emitterDuration;
    }

    public void setEmitterDuration(int emitterDuration) {
        this.emitterDuration = emitterDuration;
    }

    @XmlTransient
    public ParticleParameter getAccelerationX() {
        return this.accelerationX;
    }

    public void setAccelerationX(ParticleParameter accelerationX) {
        this.accelerationX = accelerationX;
    }

    @XmlTransient
    public ParticleParameter getAccelerationY() {
        return this.accelerationY;
    }

    public void setAccelerationY(ParticleParameter accelerationY) {
        this.accelerationY = accelerationY;
    }

    @XmlTransient
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    @XmlTransient
    public int getMaxParticles() {
        return this.maxParticles;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public Align getOriginAlign() {
        return this.originAlign;
    }

    public void setOriginAlign(Align align) {
        this.originAlign = align;
    }

    @XmlTransient
    public Valign getOriginValign() {
        return this.originValign;
    }

    public void setOriginValign(Valign valign) {
        this.originValign = valign;
    }

    @XmlTransient
    public ParticleParameter getParticleHeight() {
        return this.particleHeight;
    }

    public void setParticleHeight(ParticleParameter particleHeight) {
        this.particleHeight = particleHeight;
    }

    @XmlTransient
    public ParticleParameter getParticleTTL() {
        return this.particleTTL;
    }

    public void setParticleTTL(ParticleParameter particleTTL) {
        this.particleTTL = particleTTL;
    }

    @XmlTransient
    public List<String> getTexts() {
        return this.texts;
    }

    public void setTexts(List<String> texts) {
        this.texts = texts;
    }

    @XmlTransient
    public ParticleType getParticleType() {
        return this.particleType;
    }

    public void setParticleType(ParticleType particleType) {
        this.particleType = particleType;
    }

    @XmlTransient
    public ParticleParameter getParticleWidth() {
        return this.particleWidth;
    }

    public void setParticleWidth(ParticleParameter particleWidth) {
        this.particleWidth = particleWidth;
    }

    @XmlTransient
    public ParticleParameter getParticleOffsetX() {
        return this.offsetX;
    }

    public void setParticleOffsetX(ParticleParameter x) {
        this.offsetX = x;
    }

    @XmlTransient
    public ParticleParameter getParticleOffsetY() {
        return this.offsetY;
    }

    public void setParticleOffsetY(ParticleParameter y) {
        this.offsetY = y;
    }

    @XmlTransient
    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    @XmlTransient
    public int getSpawnRate() {
        return this.spawnRate;
    }

    public void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    @XmlTransient
    public String getSpritesheet() {
        return this.spritesheet;
    }

    public void setSpritesheet(String spritesheetName) {
        this.spritesheet = spritesheetName;
    }

    public void setSpritesheet(Spritesheet spritesheet) {
        this.spritesheet = spritesheet.getName();
    }

    @XmlTransient
    public int getUpdateRate() {
        return this.updateRate;
    }

    public void setUpdateRate(int updateRate) {
        if (updateRate == 0) {
            return;
        }
        this.updateRate = updateRate;
    }

    @XmlTransient
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean isAnimatingSprite() {
        return this.animateSprite;
    }

    public boolean isLoopingSprite() {
        return this.loopSprite;
    }

    public boolean isFading() {
        return this.fade;
    }

    public boolean isFadingOnCollision() {
        return this.fadeOnCollision;
    }

    public boolean isOutlineOnly() {
        return this.outlineOnly;
    }

    public void setOutlineOnly(boolean outlineOnly) {
        this.outlineOnly = outlineOnly;
    }

    public boolean isAntiAliased() {
        return this.antiAliasing;
    }

    public void setAnimateSprite(boolean animateSprite) {
        this.animateSprite = animateSprite;
    }

    public void setLoopSprite(boolean loopSprite) {
        this.loopSprite = loopSprite;
    }

    public void setColor(Color color) {
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(ColorHelper.encode(color));
        this.colors = tmpList;
    }

    public void initDefaults() {
        this.width = 16.0f;
        this.height = 16.0f;
        this.originAlign = DEFAULT_ORIGIN_ALIGN;
        this.originValign = DEFAULT_ORIGIN_VALIGN;
        this.offsetX.setMinValue(-4.0);
        this.offsetX.setMaxValue(4.0);
        this.offsetY.setMinValue(-4.0);
        this.offsetY.setMaxValue(4.0);
        this.deltaWidth.setMinValue(-0.1f);
        this.deltaWidth.setMaxValue(0.1f);
        this.deltaHeight.setMinValue(-0.1f);
        this.deltaHeight.setMaxValue(0.1f);
        this.angle.setMinValue(0.0);
        this.angle.setMaxValue(360.0);
        this.deltaAngle.setMinValue(-1.0);
        this.deltaAngle.setMaxValue(1.0);
        this.velocityX.setMinValue(-0.1f);
        this.velocityX.setMaxValue(0.1f);
        this.velocityY.setMinValue(-0.1f);
        this.velocityY.setMaxValue(0.1f);
        this.accelerationX.setMinValue(-0.01f);
        this.accelerationX.setMaxValue(0.01f);
        this.accelerationY.setMinValue(-0.01f);
        this.accelerationY.setMaxValue(0.01f);
        this.particleWidth.setMinValue(2.0);
        this.particleWidth.setMaxValue(6.0);
        this.particleHeight.setMinValue(2.0);
        this.particleHeight.setMaxValue(6.0);
        this.particleTTL.setMinValue(400.0);
        this.particleTTL.setMaxValue(1500.0);
        this.setColor(DEFAULT_COLOR);
        this.emitterDuration = 0;
        this.colorVariance = 0.0f;
        this.alphaVariance = 0.0f;
        this.updateRate = 40;
        this.maxParticles = 400;
        this.name = DEFAULT_NAME;
        this.setText(DEFAULT_TEXT);
        this.spawnAmount = 20;
        this.spawnRate = 100;
        this.animateSprite = true;
        this.loopSprite = true;
        this.spritesheet = DEFAULT_SPRITESHEET;
        this.fade = true;
        this.fadeOnCollision = false;
        this.outlineOnly = false;
        this.antiAliasing = false;
    }

    public void setDeltaRotation(ParticleParameter deltaRotation) {
        this.deltaAngle = deltaRotation;
    }

    public void setFade(boolean fade) {
        this.fade = fade;
    }

    public void setFadeOnCollision(boolean fadeOnCollision) {
        this.fadeOnCollision = fadeOnCollision;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setText(String text) {
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.add(text);
        this.texts = tmpList;
    }
}

