/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.AnimationController;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class SpriteParticle
extends Particle {
    private AnimationController animation;
    private boolean animateSprite;
    private boolean loopSprite;
    private BufferedImage currentImage;
    private Spritesheet spritesheet;

    public SpriteParticle(Spritesheet spritesheet) {
        super(0.0f, 0.0f);
        this.spritesheet = spritesheet;
        if (spritesheet == null) {
            return;
        }
        this.setWidth(spritesheet.getSpriteWidth());
        this.setHeight(spritesheet.getSpriteHeight());
        this.animation = new AnimationController(this.spritesheet);
    }

    @Override
    public void render(Graphics2D g, Point2D emitterOrigin) {
        Point2D renderLocation = this.getRenderLocation(emitterOrigin);
        if (this.isAnimatingSprite()) {
            this.currentImage = this.animation.getCurrentImage();
        }
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.getOpacity()));
        if (this.getAngle() != 0.0f) {
            ImageRenderer.renderRotated(g, this.currentImage, renderLocation, this.getAngle());
        } else {
            ImageRenderer.render(g, this.currentImage, renderLocation);
        }
        g.setComposite(oldComp);
    }

    @Override
    public void update(Point2D emitterOrigin, float updateRatio) {
        super.update(emitterOrigin, updateRatio);
        this.animation.update();
    }

    @Override
    public Rectangle2D getBoundingBox(Point2D origin) {
        return new Rectangle2D.Double(origin.getX() + (double)this.getX() - (double)(this.getWidth() / 2.0f), origin.getY() + (double)this.getY() - (double)(this.getHeight() / 2.0f), this.getWidth(), this.getHeight());
    }

    public boolean isAnimatingSprite() {
        return this.animateSprite;
    }

    public SpriteParticle setAnimateSprite(boolean animateSprite) {
        this.animateSprite = animateSprite;
        if (!this.animateSprite) {
            this.currentImage = this.spritesheet.getRandomSprite();
        }
        return this;
    }

    public boolean isLoopingSprite() {
        return this.loopSprite;
    }

    public SpriteParticle setLoopSprite(boolean loopSprite) {
        this.loopSprite = loopSprite;
        this.animation.getDefault().setLooping(loopSprite);
        return this;
    }
}

