/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import java.awt.geom.Point2D;

public class EntityEmitter
extends Emitter {
    private final IEntity entity;
    private boolean dynamicLocation;

    public EntityEmitter(IEntity entity, String emitterResourceName, boolean dynamicLocation) {
        this(entity, dynamicLocation);
        this.setEmitterData(emitterResourceName);
    }

    public EntityEmitter(IEntity entity, String emitterResourceName) {
        this(entity, emitterResourceName, false);
    }

    public EntityEmitter(IEntity entity, EmitterData emitterData, boolean dynamicLocation) {
        this(entity, dynamicLocation);
        this.setEmitterData(emitterData);
    }

    public EntityEmitter(IEntity entity, EmitterData emitterData) {
        this(entity, emitterData, false);
    }

    public EntityEmitter(IEntity entity) {
        this(entity, false);
    }

    public EntityEmitter(IEntity entity, boolean dynamicLocation) {
        this.entity = entity;
        this.dynamicLocation = dynamicLocation;
        this.setX(entity.getCenter().getX() - this.getWidth() / 2.0);
        this.setY(entity.getCenter().getY() - this.getHeight() / 2.0);
    }

    public IEntity getEntity() {
        return this.entity;
    }

    public boolean hasDynamicLocation() {
        return this.dynamicLocation;
    }

    public void setDynamicLocation(boolean dynamicLocation) {
        this.dynamicLocation = dynamicLocation;
    }

    @Override
    public double getWidth() {
        return this.getEntity() != null ? this.getEntity().getWidth() : super.getWidth();
    }

    @Override
    public double getHeight() {
        return this.getEntity() != null ? this.getEntity().getHeight() : super.getHeight();
    }

    @Override
    public double getX() {
        return this.getEntity() != null && this.hasDynamicLocation() ? this.getEntity().getX() : super.getX();
    }

    @Override
    public double getY() {
        return this.getEntity() != null && this.hasDynamicLocation() ? this.getEntity().getY() : super.getY();
    }

    @Override
    public Point2D getLocation() {
        return this.getEntity() != null && this.hasDynamicLocation() ? this.getEntity().getLocation() : super.getLocation();
    }
}

