/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public final class TextRenderer {
    private TextRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void render(Graphics2D g, String text, double x, double y) {
        TextRenderer.render(g, text, x, y, true);
    }

    public static void render(Graphics2D g, String text, Point2D location) {
        TextRenderer.render(g, text, location.getX(), location.getY());
    }

    public static void render(Graphics2D g, String text, Align align, Valign valign, double offsetX, double offsetY) {
        Rectangle bounds = g.getClipBounds();
        TextRenderer.render(g, text, bounds, align, valign, offsetX, offsetY, false);
    }

    public static void render(Graphics2D g, String text, Rectangle2D bounds, Align alignment, Valign verticalAlignment, boolean scaleFont) {
        TextRenderer.render(g, text, bounds, alignment, verticalAlignment, 0.0, 0.0, scaleFont);
    }

    public static void render(Graphics2D g, String text, Rectangle2D bounds, Align align, Valign valign, double offsetX, double offsetY, boolean scaleFont) {
        if (bounds == null) {
            return;
        }
        float previousFontSize = g.getFont().getSize2D();
        if (scaleFont) {
            float currentFontSize = previousFontSize;
            while ((TextRenderer.getWidth(g, text) > bounds.getWidth() || TextRenderer.getHeight(g, text) > bounds.getHeight()) && currentFontSize > 0.1f) {
                g.setFont(g.getFont().deriveFont(currentFontSize -= 0.1f));
            }
        }
        double locationX = bounds.getX() + align.getLocation(bounds.getWidth(), g.getFontMetrics().stringWidth(text)) + offsetX;
        double locationY = bounds.getY() + valign.getLocation(bounds.getHeight(), TextRenderer.getHeight(g, text)) + (double)g.getFontMetrics().getAscent() + offsetY;
        TextRenderer.render(g, text, locationX, locationY);
        g.setFont(g.getFont().deriveFont(previousFontSize));
    }

    public static void render(Graphics2D g, String text, double x, double y, boolean antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        RenderingHints originalHints = g.getRenderingHints();
        if (antiAliasing) {
            TextRenderer.enableTextAntiAliasing(g);
        }
        g.drawString(text, (float)x, (float)y);
        g.setRenderingHints(originalHints);
    }

    public static void render(Graphics2D g, String text, Point2D location, boolean antiAliasing) {
        TextRenderer.render(g, text, location.getX(), location.getY(), antiAliasing);
    }

    public static void renderRotated(Graphics2D g, String text, double x, double y, double angle, boolean antiAliasing) {
        RenderingHints originalHints = g.getRenderingHints();
        if (antiAliasing) {
            TextRenderer.enableTextAntiAliasing(g);
        }
        TextRenderer.renderRotated(g, text, x, y, angle);
        g.setRenderingHints(originalHints);
    }

    public static void renderRotated(Graphics2D g, String text, double x, double y, double angle) {
        AffineTransform oldTx = g.getTransform();
        g.rotate(Math.toRadians(angle), x, y);
        TextRenderer.render(g, text, x, y);
        g.setTransform(oldTx);
    }

    public static void renderRotated(Graphics2D g, String text, Point2D location, double angle) {
        TextRenderer.renderRotated(g, text, location.getX(), location.getY(), angle);
    }

    public static void renderRotated(Graphics2D g, String text, Point2D location, double angle, boolean antiAliasing) {
        TextRenderer.renderRotated(g, text, location.getX(), location.getY(), angle, antiAliasing);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, double x, double y, double lineWidth) {
        TextRenderer.renderWithLinebreaks(g, text, x, y, lineWidth, true);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, Point2D location, double lineWidth) {
        TextRenderer.renderWithLinebreaks(g, text, location.getX(), location.getY(), lineWidth);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, double x, double y, double lineWidth, boolean antiAliasing) {
        TextRenderer.renderWithLinebreaks(g, text, Align.LEFT, Valign.TOP, x, y, lineWidth, 0.0, antiAliasing);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, Align align, Valign valign, double x, double y, double width, double height, boolean antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        RenderingHints originalHints = g.getRenderingHints();
        if (antiAliasing) {
            TextRenderer.enableTextAntiAliasing(g);
        }
        FontRenderContext frc = g.getFontRenderContext();
        ArrayList<TextLayout> lines = new ArrayList<TextLayout>();
        float textHeight = 0.0f;
        block0: for (String s : text.split(System.lineSeparator())) {
            AttributedString styledText = new AttributedString(s);
            styledText.addAttribute(TextAttribute.FONT, g.getFont());
            AttributedCharacterIterator iterator = styledText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
            while (true) {
                TextLayout nextLayout = measurer.nextLayout((float)width);
                lines.add(nextLayout);
                textHeight += nextLayout.getAscent() + nextLayout.getDescent();
                if (measurer.getPosition() >= text.length()) continue block0;
                textHeight += nextLayout.getLeading();
            }
        }
        float textY = (float)(y + valign.getLocation(height, textHeight));
        for (TextLayout layout : lines) {
            layout.draw(g, (float)(x + align.getLocation(width, layout.getAdvance())), textY += layout.getAscent());
            textY += layout.getDescent() + layout.getLeading();
        }
        g.setRenderingHints(originalHints);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, Point2D location, double lineWidth, boolean antiAliasing) {
        TextRenderer.renderWithLinebreaks(g, text, location.getX(), location.getY(), lineWidth, antiAliasing);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, Color outlineColor) {
        TextRenderer.renderWithOutline(g, text, x, y, outlineColor, false);
    }

    public static void renderWithOutline(Graphics2D g, String text, Point2D location, Color outlineColor) {
        TextRenderer.renderWithOutline(g, text, location.getX(), location.getY(), outlineColor);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, Color outlineColor, boolean antiAliasing) {
        float stroke = (float)MathUtilities.clamp((double)(g.getFont().getSize2D() * 1.0f / 5.0f) * Math.log(Game.world().camera().getRenderScale()), 1.0, 100.0);
        TextRenderer.renderWithOutline(g, text, x, y, outlineColor, stroke, antiAliasing);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, Color outlineColor, float stroke, boolean antiAliasing) {
        TextRenderer.renderWithOutline(g, text, x, y, 0.0, 0.0, outlineColor, stroke, Align.LEFT, Valign.TOP, antiAliasing);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, double width, double height, Color outlineColor, float stroke, Align align, Valign valign, boolean antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Color fillColor = g.getColor();
        BasicStroke outlineStroke = new BasicStroke(stroke);
        Color originalColor = g.getColor();
        Stroke originalStroke = g.getStroke();
        RenderingHints originalHints = g.getRenderingHints();
        GlyphVector glyphVector = g.getFont().createGlyphVector(g.getFontRenderContext(), text);
        Rectangle2D bounds = glyphVector.getVisualBounds();
        AffineTransform at = new AffineTransform();
        at.translate(x + align.getLocation(width, bounds.getWidth()), y + valign.getLocation(height, bounds.getHeight()) + bounds.getHeight());
        Shape textShape = at.createTransformedShape(glyphVector.getOutline());
        if (antiAliasing) {
            TextRenderer.enableTextAntiAliasing(g);
        }
        g.setColor(outlineColor);
        g.setStroke(outlineStroke);
        g.draw(textShape);
        g.setColor(fillColor);
        g.fill(textShape);
        g.setColor(originalColor);
        g.setStroke(originalStroke);
        g.setRenderingHints(originalHints);
    }

    public static void renderWithOutline(Graphics2D g, String text, Point2D location, Color outlineColor, boolean antiAliasing) {
        TextRenderer.renderWithOutline(g, text, location.getX(), location.getY(), outlineColor, antiAliasing);
    }

    public static Rectangle2D getBounds(Graphics2D g, String text) {
        return g.getFontMetrics().getStringBounds(text, g);
    }

    public static double getWidth(Graphics2D g, String text) {
        return TextRenderer.getBounds(g, text).getWidth();
    }

    public static double getHeight(Graphics2D g, String text) {
        return TextRenderer.getBounds(g, text).getHeight();
    }

    public static void enableTextAntiAliasing(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

